/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.http.Request;

public class DmsServletRequest
extends Request {
    private HttpServletRequest m_request = null;
    private boolean m_isLogout = true;

    public DmsServletRequest(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(this.toString() + ": request=" + request);
        }
        this.m_request = request;
    }

    @Override
    public String getMethod() {
        return this.m_request.getMethod();
    }

    @Override
    public String getHeader(String name) {
        return this.m_request.getHeader(name);
    }

    @Override
    public String getParameter(String name) {
        return this.m_request.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.m_request.getParameterValues(name);
    }

    @Override
    public String getRequestedSessionId() {
        return this.m_request.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        String requestURI = this.m_request.getRequestURI();
        String pathInfo = this.m_request.getPathInfo();
        if (pathInfo != null && pathInfo.trim().length() > 0) {
            if (requestURI.endsWith(pathInfo)) {
                requestURI = requestURI.substring(0, requestURI.length() - pathInfo.length());
            } else {
                try {
                    String decoded = URLDecoder.decode(requestURI, "UTF-8").replace(' ', '+');
                    if (decoded.endsWith(pathInfo)) {
                        requestURI = decoded.substring(0, decoded.length() - pathInfo.length());
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return requestURI;
    }

    public String getContextPath() {
        return this.m_request.getContextPath();
    }

    @Override
    public String getServerName() {
        return this.m_request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.m_request.getServerPort();
    }

    @Override
    public String getQueryString() {
        return this.m_request.getQueryString();
    }

    public boolean isLogout() {
        return this.m_isLogout;
    }

    public void setLogout(boolean isLogout) {
        this.m_isLogout = isLogout;
    }
}

