/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class RID {
    public static final char DELIM = ':';
    public static final int BASE_UNIQUE_CHILD = 100000000;
    private static final String ROOT_STRING = "0";
    private static final char KNOWN_LINEAGE_FIRST_CHAR = '0';
    private static final char UNKNOWN_LINEAGE_FIRST_CHAR = '1';
    private static final int ROOT_HASH = "0".hashCode();
    private static int s_uniqueChild = 100000000;
    public static final RID ROOT = new RID();
    private int m_id = 0;
    private AtomicInteger m_kids = null;
    private String m_stringID = null;
    private int m_hash = -1;
    private int m_depth = 1;
    private boolean m_hex = false;
    private static int notSignBit = Integer.MAX_VALUE;
    private static AtomicInteger unknownLineageSequenceNumber = new AtomicInteger(new Random().nextInt(16384) + 16384);

    public RID() {
        this.m_stringID = ROOT_STRING;
        this.m_hash = ROOT_HASH;
        this.m_kids = new AtomicInteger();
    }

    private RID(RID parent, int id) {
        this.m_id = id;
        String s = Integer.toString(this.m_id);
        this.m_stringID = parent.toString() + ":" + s;
        this.m_hash = this.m_stringID.hashCode();
        this.m_depth = parent.depth() + 1;
        this.m_kids = new AtomicInteger();
    }

    private RID(String path, int id, int kids, boolean hex) {
        this.m_id = id;
        this.m_stringID = path;
        this.m_kids = new AtomicInteger(kids);
        this.m_hash = this.m_stringID.hashCode();
        this.m_hex = true;
        int idx = 0;
        int last = 0;
        int len = path.length();
        while (idx < len && (idx = path.indexOf(":", last)) >= 0) {
            ++this.m_depth;
            last = ++idx;
        }
    }

    public String toString() {
        return this.m_stringID;
    }

    public int[] toArray() {
        int length = this.m_stringID.length();
        int rIndex = this.m_depth;
        if (rIndex <= 0 || length <= 2) {
            rIndex = 1;
        }
        int[] rid = new int[rIndex];
        int n = rid[0] = this.m_stringID.charAt(0) == '1' ? 1 : 0;
        if (rIndex > 1) {
            rIndex = 1;
            int start = this.m_stringID.indexOf(58, 0);
            if (start > 0) {
                String hex;
                String field;
                int sIndex = this.m_stringID.indexOf(58, ++start);
                while (sIndex > start) {
                    field = this.m_stringID.substring(start, sIndex);
                    try {
                        rid[rIndex] = Integer.parseInt(field);
                    }
                    catch (NumberFormatException nfe) {
                        hex = field.substring(2);
                        try {
                            rid[rIndex] = Integer.parseInt(hex, 16);
                        }
                        catch (Exception e) {
                            rid[rIndex] = 0;
                        }
                    }
                    ++rIndex;
                    start = sIndex + 1;
                    sIndex = this.m_stringID.indexOf(58, start);
                }
                field = this.m_stringID.substring(start, length);
                try {
                    rid[rIndex] = Integer.parseInt(field);
                }
                catch (NumberFormatException nfe) {
                    hex = field.substring(2);
                    try {
                        rid[rIndex] = Integer.parseInt(hex, 16);
                    }
                    catch (Exception e) {
                        rid[rIndex] = 0;
                    }
                }
            }
        }
        return rid;
    }

    public int depth() {
        return this.m_depth;
    }

    public int getKidCount() {
        return this.m_kids.get();
    }

    public RID createChildRID() {
        return new RID(this, this.m_kids.incrementAndGet());
    }

    public String getRID() {
        return this.toString();
    }

    public int getMyChildId() {
        return this.m_id;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o == this) {
            retVal = true;
        } else if (o instanceof RID) {
            RID r = (RID)o;
            if (r.m_hash == this.m_hash && r.m_stringID.equals(this.m_stringID)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static RID createRID(String in, boolean createUniqueChild) {
        int last;
        boolean hex = false;
        if (!RID.isStringRoughlyRIDLike(in)) {
            return null;
        }
        int len = in.length();
        if (len == 1) {
            return new RID();
        }
        int idx = -1;
        int kids = 0;
        String str = null;
        idx = in.indexOf(",");
        if (idx != -1) {
            if (idx + 1 > len - 1) {
                return null;
            }
            str = in.substring(idx + 1, len);
            try {
                kids = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            if (kids < 0) {
                return null;
            }
        }
        String ridStr = null;
        int myId = -1;
        if (createUniqueChild) {
            last = idx > 0 ? idx : len;
            myId = RID.getUniqueId();
            ridStr = in.substring(0, last) + ':' + Integer.toString(myId);
            idx = in.length();
        } else {
            last = idx > 0 ? idx : len;
            idx = in.lastIndexOf(":");
            str = in.substring(idx + 1, last);
            ridStr = in.substring(0, last);
            try {
                myId = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                try {
                    if (!str.startsWith("0x")) {
                        return null;
                    }
                    String newStr = str.substring(2);
                    myId = Integer.parseInt(newStr, 16);
                    hex = true;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    ioobe.printStackTrace();
                    return null;
                }
                catch (NumberFormatException nnfe) {
                    nnfe.printStackTrace();
                    return null;
                }
            }
        }
        String start = in.substring(0, idx);
        if (!RID.isValidRID(start)) {
            return null;
        }
        return new RID(ridStr, myId, kids, hex);
    }

    private static boolean isValidRID(String in) {
        if (!RID.isStringRoughlyRIDLike(in)) {
            return false;
        }
        int len = in.length();
        if (RID.isRootRIDString(in)) {
            return true;
        }
        if (in.charAt(1) != ':') {
            return false;
        }
        int next = 1;
        int last = 2;
        String chunk = null;
        while (next > 0) {
            next = in.indexOf(":", last);
            chunk = next > 0 ? in.substring(last, next) : in.substring(last);
            try {
                int val = Integer.parseInt(chunk);
            }
            catch (NumberFormatException nfe) {
                if (!chunk.startsWith("0x")) {
                    return false;
                }
                try {
                    String nchunk = chunk.substring(2);
                    int val = Integer.parseInt(nchunk, 16);
                }
                catch (Exception e) {
                    return false;
                }
            }
            last = next + 1;
        }
        return true;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean descendsFrom(RID rid) {
        if (this.m_depth <= rid.depth()) {
            return false;
        }
        return this.m_stringID.startsWith(rid.toString());
    }

    public static synchronized int getUniqueId() {
        if (s_uniqueChild == Integer.MAX_VALUE) {
            s_uniqueChild = 100000000;
        }
        return s_uniqueChild++;
    }

    public boolean isRoot() {
        return this.m_depth == 1 && this.m_id == 0;
    }

    public RID getParent() {
        if (this.isRoot()) {
            return null;
        }
        int finalColon = this.m_stringID.lastIndexOf(":");
        String parentString = this.m_stringID.substring(0, finalColon);
        RID parentRID = RID.createRID(parentString, false);
        return parentRID;
    }

    public static RID createRIDWithUnknownLineage() {
        int id = unknownLineageSequenceNumber.incrementAndGet() & notSignBit;
        String idStr = "1:" + id;
        RID retVal = new RID(idStr, id, 0, false);
        return retVal;
    }

    private static boolean isValidFirstChar(char c) {
        return c == '0' || c == '1';
    }

    private static boolean isStringRoughlyRIDLike(String s) {
        return s != null && s.length() >= 1 && RID.isValidFirstChar(s.charAt(0));
    }

    private static boolean isRootRIDString(String s) {
        return s != null && s.length() == 1 && s.charAt(0) == '0';
    }

    public static boolean isRIDWithUnknownLineage(String s) {
        return s != null && s.length() >= 3 && s.charAt(0) == '1' && s.charAt(1) == ':';
    }
}

