/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import oracle.dms.ParameterDescriptor;

public interface ContextParameterDescriptor
extends ParameterDescriptor {
    public int getMaxValueLength();

    public boolean isUpdateable();

    public int getECIDCardinality();

    public Scope getScope();

    public static enum Scope {
        SINGLE_CONTEXT_ONLY(false, false, false),
        SINGLE_CONTEXT_PLUS_DB(false, true, false),
        LOCAL_CONTEXT_FAMILY_ONLY(true, false, false),
        LOCAL_CONTEXT_FAMILY_PLUS_DB(true, true, false),
        LOCAL_CONTEXT_FAMILY_PLUS_CHILDREN_AND_DB(true, true, true);

        private boolean mIsSharedInFamily;
        private boolean mIsPropagatedViaWrap;
        private boolean mIsPropagatedToDB;

        private Scope(boolean isSharedInFamily, boolean isPropagatedToDB, boolean isPropagatedViaWrap) {
            if (isPropagatedViaWrap && !isPropagatedToDB) {
                throw new IllegalArgumentException("A parameter is not permitted to be propagated to all children but not propagated to the database.");
            }
            this.mIsSharedInFamily = isSharedInFamily;
            this.mIsPropagatedViaWrap = isPropagatedViaWrap;
            this.mIsPropagatedToDB = isPropagatedToDB;
        }

        @Deprecated
        public boolean isSharedInFamily() {
            return this.mIsSharedInFamily;
        }

        @Deprecated
        public boolean isPropagatedViaWrap() {
            return this.mIsPropagatedViaWrap;
        }

        @Deprecated
        public boolean isPropagatedToDB() {
            return this.mIsPropagatedToDB;
        }
    }
}

