/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.jmx;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import oracle.dfw.incident.Incident;

class OpenTypeHelper {
    private static final String INCIDENT_ATTRIBUTE_NAME = "Incident";

    OpenTypeHelper() {
    }

    static Incident deserializeIncident(Object userData) {
        OpenTypeSerializer ots = new OpenTypeSerializer();
        Attribute attr = new Attribute(INCIDENT_ATTRIBUTE_NAME, userData);
        try {
            ots.setAttribute(attr);
            return ots.getIncident();
        }
        catch (AttributeNotFoundException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (MBeanException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (ReflectionException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    static Object serializeIncident(Incident incident) {
        try {
            OpenTypeSerializer ots = new OpenTypeSerializer();
            ots.setIncident(incident);
            return ots.getAttribute(INCIDENT_ATTRIBUTE_NAME);
        }
        catch (AttributeNotFoundException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (MBeanException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (ReflectionException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    public static class OpenTypeSerializer
    extends StandardMBean
    implements OpenTypeSerializerInterface {
        private Incident m_incident;

        public OpenTypeSerializer() {
            super(OpenTypeSerializerInterface.class, true);
        }

        @Override
        public Incident getIncident() {
            return this.m_incident;
        }

        @Override
        public void setIncident(Incident incident) {
            this.m_incident = incident;
        }
    }

    public static interface OpenTypeSerializerInterface {
        public Incident getIncident();

        public void setIncident(Incident var1);
    }
}

