/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.http.SimpleRequest;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.NounDumperThread;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.NounRefresh;
import oracle.dms.instrument.Rollup;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.reporter.Agency;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SimpleAgency;
import oracle.dms.spy.Metric;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.ClientObjectHolderImpl;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class Noun
extends TreeNode
implements NounIntf {
    private boolean mIsSpecialCaseNotTraceable;
    private boolean mTraceImplicitStateValueEvents;
    private final ClientObjectHolderImpl mClientObjectHolderImpl;
    private static final String RU_SUFFIX = "_rollup";
    private static final String RU_DESCENDENTS = "descendents";
    private static final String RU_DESCENDENTS_DESC = "which descendents are canditate nouns for rollup";
    private static final String RU_COUNT = "rolled";
    private static final String RU_UNITS = "nouns";
    private static final String RU_COUNT_DESC = "number of nouns rolled up in aggregated metrics";
    private static final Level INITIAL_LOG_LEVEL = Level.NOTIFICATION;
    private Level sEnabledLogLevel;
    private HashMap<String, String> sLogProperties;
    private ArrayList<LogWriter> sLogWriters;
    private ArrayList<String> mCachedRefKeys;
    private static ConcurrentHashMap<String, Noun> sNounCache = new ConcurrentHashMap();
    private static Hashtable<String, NounRefresh> sNounRefreshes = new Hashtable();
    private static Hashtable<String, NounDescriptor> sDescriptorMap = new Hashtable();
    private NounDescriptor mDescriptor;
    private long mCreateTime;
    private static int sStatus = 0;
    private Vector<Noun> mChildNouns;
    private Vector<Sensor> mSensors;
    private NounDumperThread mDumperThread;
    private static final String NOUN_DESC = "Noun";
    private static final String ROOT_TYPE = "DMS_ROOT";
    private static final String DRILLDOWN_TYPE_PREFIX = "xxx_";
    private static final String DRILLDOWN_INDICATOR = "CALLS_TO";
    private String mTypeName;
    private static volatile HashMap<String, ArrayList<String>> sBucketTypes;
    private ArrayList<String> mBucketKeys;
    private static final Logger LOGGER;
    private static Noun sRootNoun;
    private static final String QUERY_STRING_BASE;

    private Noun() {
        block3: {
            super("Process" + DMSUtil.getProcessID(), NOUN_DESC);
            this.mIsSpecialCaseNotTraceable = false;
            this.mTraceImplicitStateValueEvents = false;
            this.mClientObjectHolderImpl = new ClientObjectHolderImpl(ClientObjectKeyManager.ClientObjectHolderType.NOUN);
            this.sEnabledLogLevel = Level.OFF;
            this.sLogProperties = null;
            this.sLogWriters = new ArrayList();
            this.mCachedRefKeys = null;
            this.mDescriptor = null;
            this.mCreateTime = Time.currentTimeMillis();
            this.mChildNouns = new Vector();
            this.mSensors = new Vector();
            this.mDumperThread = null;
            this.mTypeName = "n/a";
            this.mBucketKeys = null;
            this.mTypeName = ROOT_TYPE;
            sRootNoun = this;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("Level", Level.DEBUG.toString());
            this.sLogProperties = properties;
            this.sEnabledLogLevel = INITIAL_LOG_LEVEL;
            if (sStatus != 2) {
                DMSConsole console = new DMSConsole();
                try {
                    console.init(null, null, false);
                    sStatus = 1;
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(java.util.logging.Level.INFO)) break block3;
                    LOGGER.logp(java.util.logging.Level.INFO, this.getClass().getName(), this.getClass().getName(), "DMS-50700", e);
                }
            }
        }
    }

    @Deprecated
    public Noun(Noun parent, String name, String type) {
        super(parent, name, NOUN_DESC);
        Event evt;
        HashMap<String, Object> prop;
        this.mIsSpecialCaseNotTraceable = false;
        this.mTraceImplicitStateValueEvents = false;
        this.mClientObjectHolderImpl = new ClientObjectHolderImpl(ClientObjectKeyManager.ClientObjectHolderType.NOUN);
        this.sEnabledLogLevel = Level.OFF;
        this.sLogProperties = null;
        this.sLogWriters = new ArrayList();
        this.mCachedRefKeys = null;
        this.mDescriptor = null;
        this.mCreateTime = Time.currentTimeMillis();
        this.mChildNouns = new Vector();
        this.mSensors = new Vector();
        this.mDumperThread = null;
        this.mTypeName = "n/a";
        this.mBucketKeys = null;
        if (type != null && type.length() > 0 && !type.equals("n/a")) {
            this.mTypeName = DMSUtil.sanitize(type, 511, true, true);
            if (sBucketTypes == null) {
                sBucketTypes = new HashMap();
            } else {
                this.mBucketKeys = sBucketTypes.get(this.mTypeName);
            }
        }
        if (parent == null || name.length() < 1) {
            throw new InstrumentationException("DMS-50752", "Noun()", "" + parent + ":" + name);
        }
        this.sEnabledLogLevel = INITIAL_LOG_LEVEL;
        if (DMSProperties.hasNounProperties() && (prop = DMSProperties.getNounProperties(this.toString())) != null) {
            List logwriters;
            String strLev = (String)prop.get("loglevel");
            if (strLev != null) {
                this.setLogLevel(Level.getLevel(strLev), false);
            }
            if ((logwriters = (List)prop.get("logwriter")) != null) {
                for (int i = 0; i < logwriters.size(); ++i) {
                    String lwName = (String)logwriters.get(i);
                    LogWriter lw = Log.getLogWriter(lwName);
                    if (lw == null) continue;
                    this.addLogWriter(lw);
                }
            }
        }
        if ((evt = StatisticsProducer._nounCreate) != null) {
            evt.occurred(new Object[]{this});
        } else {
            ++StatisticsProducer._nounCreateCount;
        }
        this.rememberType(null);
        this.toString();
        if (this.mTypeName.equals("oc4j_servlet") && this._name.equals("jsp")) {
            this.mIsSpecialCaseNotTraceable = true;
        }
        if (type != null && type.startsWith("JDBC")) {
            this.mTraceImplicitStateValueEvents = true;
        }
        this._parent.childAdded(this);
    }

    public static Noun create(String pathname, String type) {
        if (pathname == null || type == null || pathname.length() == 0) {
            throw new InstrumentationException("DMS-50752", "Noun.create()", "" + pathname + ":" + type + ":" + pathname);
        }
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n;
        }
        String cleanpath = DMSUtil.removeTrailingDelimFromPath(pathname);
        String my_name = DMSUtil.getLeafFromPath(cleanpath);
        String parentName = DMSUtil.getParentFromPath(cleanpath);
        Noun parent = parentName.length() > 0 ? Noun.create(parentName) : Noun.getRoot();
        return Noun.create(parent, my_name, type);
    }

    public static Noun create(String pathname) {
        return Noun.create(pathname, "n/a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun create(Noun parent, String name, String type) {
        EventReportingManager eMgr;
        if (parent == null || type == null || name == null) {
            throw new InstrumentationException("DMS-50752", "Noun.create()", "" + parent + ":" + name + ":" + type);
        }
        Noun n = null;
        boolean newNoun = false;
        Noun noun = parent;
        synchronized (noun) {
            n = parent.getChild(name);
            if (n == null) {
                n = new Noun(parent, name, type);
                newNoun = true;
            }
        }
        if (newNoun && n.mDescriptor != null && n.mDescriptor.getEventable(EventActionType.CREATE) && (eMgr = EventSystem.getEventReportingManager()) != null) {
            long timeNow = Time.currentTimeMillis();
            eMgr.reportEvent(n, EventSourceType.NOUN, EventActionType.CREATE, timeNow, null, null);
        }
        return n;
    }

    public static String getType(String pathname) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n.getType();
        }
        return null;
    }

    @Override
    public String getType() {
        return this.mTypeName;
    }

    public static void setType(String pathname, String type) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            n.setType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(String type) {
        Noun noun = this;
        synchronized (noun) {
            if (!this._alive) {
                return;
            }
            if (type == null || type.trim().length() == 0) {
                return;
            }
            if ((type = DMSUtil.sanitize(type, 511, true, true)).equals(this.mTypeName)) {
                return;
            }
            NounDescriptor removedNounDescriptor = this.forgetType();
            if (!type.equals("n/a")) {
                this.mTypeName = type;
            }
            this.rememberType(removedNounDescriptor);
        }
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null && this.mDescriptor != null && this.mDescriptor.getEventable(EventActionType.TYPE_CHANGE)) {
            eMgr.reportEvent(this, EventSourceType.NOUN, EventActionType.TYPE_CHANGE, Time.currentTimeMillis(), null, null);
        }
    }

    public NounDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public static Noun get(String pathname) {
        if (pathname == null || pathname.length() == 0) {
            return null;
        }
        Noun noun = sNounCache.get(pathname);
        if (noun != null) {
            return noun;
        }
        String cleanpath = DMSUtil.removeTrailingDelimFromPath(pathname);
        String sanitizedPathname = DMSUtil.sanitize(cleanpath, 511, false, false);
        if (sanitizedPathname.length() == 1) {
            return Noun.getRoot();
        }
        char delim = sanitizedPathname.charAt(0);
        Noun n = Noun.getRoot();
        int index = 1;
        boolean done = false;
        while (true) {
            String name;
            int nextDelim;
            if ((nextDelim = sanitizedPathname.indexOf(delim, index)) == index) {
                index = nextDelim + 1;
                continue;
            }
            if (nextDelim < 0) {
                name = sanitizedPathname.substring(index);
                done = true;
            } else {
                name = sanitizedPathname.substring(index, nextDelim);
            }
            n = n.getChild(name);
            if (n == null) {
                return null;
            }
            if (done) {
                n.addToCache(pathname);
                if (!pathname.equals(cleanpath)) {
                    n.addToCache(cleanpath);
                }
                if (!cleanpath.equals(sanitizedPathname)) {
                    n.addToCache(sanitizedPathname);
                }
                return n;
            }
            index = nextDelim + 1;
            if (index >= sanitizedPathname.length()) break;
        }
        n.addToCache(pathname);
        if (!pathname.equals(sanitizedPathname)) {
            n.addToCache(sanitizedPathname);
        }
        return n;
    }

    private synchronized void addToCache(String pathname) {
        if (!this._alive) {
            return;
        }
        Noun prev = sNounCache.put(pathname, this);
        if (prev != null) {
            return;
        }
        if (this.mCachedRefKeys == null) {
            this.mCachedRefKeys = new ArrayList();
        }
        this.mCachedRefKeys.add(pathname);
    }

    private synchronized void cleanupCache() {
        if (this.mCachedRefKeys == null) {
            return;
        }
        for (int i = 0; i < this.mCachedRefKeys.size(); ++i) {
            String key = this.mCachedRefKeys.get(i);
            sNounCache.remove(key);
        }
        this.mCachedRefKeys = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberType(NounDescriptor descriptor) {
        if (this == sRootNoun || "n/a".equals(this.mTypeName) || this.mTypeName.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return;
        }
        Hashtable<String, NounDescriptor> hashtable = sDescriptorMap;
        synchronized (hashtable) {
            if (descriptor == null) {
                this.mDescriptor = sDescriptorMap.get(this.mTypeName);
            } else {
                this.mDescriptor = descriptor;
                this.mDescriptor.setName(this.mTypeName);
            }
            if (this.mDescriptor == null) {
                this.mDescriptor = new NounDescriptor(this.mTypeName);
                sDescriptorMap.put(this.mTypeName, this.mDescriptor);
            } else if (!sDescriptorMap.containsKey(this.mTypeName)) {
                sDescriptorMap.put(this.mTypeName, this.mDescriptor);
            } else {
                this.mDescriptor = sDescriptorMap.get(this.mTypeName);
            }
            this.mDescriptor.addNoun(this);
        }
        this.mDescriptor.addAncestorTypes(this._parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NounDescriptor forgetType() {
        if (this == sRootNoun || "n/a".equals(this.mTypeName) || this.mTypeName.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return null;
        }
        NounDescriptor removedNounDescriptor = null;
        Hashtable<String, NounDescriptor> hashtable = sDescriptorMap;
        synchronized (hashtable) {
            this.mDescriptor = sDescriptorMap.get(this.mTypeName);
            if (this.mDescriptor != null) {
                this.mDescriptor.removeNoun(this);
                removedNounDescriptor = this.mDescriptor.getNounCount() == 0 ? sDescriptorMap.remove(this.mTypeName) : this.mDescriptor.duplicateWithoutNouns();
            }
        }
        return removedNounDescriptor;
    }

    public synchronized Sensor[] getSensors() {
        if (!this._alive) {
            return new Sensor[0];
        }
        Object[] retval = new Sensor[this.mSensors.size()];
        this.mSensors.copyInto(retval);
        return retval;
    }

    public synchronized Vector<Metric> getMetrics() {
        Vector<Metric> retval = new Vector<Metric>();
        if (!this._alive) {
            return retval;
        }
        for (int i = this.mSensors.size() - 1; i >= 0; --i) {
            Sensor sensor = this.mSensors.elementAt(i);
            sensor.getMetrics(retval);
        }
        return retval;
    }

    @Override
    public synchronized Vector<Noun> getNouns() {
        if (!this._alive) {
            return new Vector<Noun>(0);
        }
        return (Vector)this.mChildNouns.clone();
    }

    public synchronized int getNumChildNouns() {
        return this.mChildNouns.size();
    }

    protected synchronized void childAdded(Noun child) {
        int i;
        if (!this._alive) {
            return;
        }
        int numChildren = this.mChildNouns.size();
        String childName = child.getName();
        for (i = 0; i < numChildren; ++i) {
            Noun n = this.mChildNouns.elementAt(i);
            if (childName.compareTo(n._name) <= 0) break;
        }
        this.mChildNouns.insertElementAt(child, i);
    }

    protected synchronized void sensorAdded(Sensor sensor) {
        Sensor s;
        int i;
        if (!this._alive) {
            return;
        }
        int numSensors = this.mSensors.size();
        String sensorName = sensor.getName();
        for (i = 0; i < numSensors && sensorName.compareTo((s = this.mSensors.elementAt(i)).getName()) > 0; ++i) {
        }
        this.mSensors.insertElementAt(sensor, i);
    }

    protected synchronized void childDestroyed(Noun child) {
        if (!this.mChildNouns.removeElement(child)) {
            // empty if block
        }
    }

    protected synchronized void sensorDestroyed(Sensor sensor) {
        if (!this.mSensors.removeElement(sensor)) {
            // empty if block
        }
    }

    public static Noun getRoot() {
        return sRootNoun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        block11: {
            String METHOD_NAME = "destroy";
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null && this.mDescriptor != null && this.mDescriptor.getEventable(EventActionType.DELETE)) {
                eMgr.reportEvent(this, EventSourceType.NOUN, EventActionType.DELETE, Time.currentTimeMillis(), null, null);
            }
            try {
                Noun parent;
                Noun noun = parent = this.getParent();
                synchronized (noun) {
                    Noun noun2 = this;
                    synchronized (noun2) {
                        if (!this._alive) {
                            return;
                        }
                        this.cleanupCache();
                        Event evt = StatisticsProducer._nounDestroy;
                        if (evt != null) {
                            evt.occurred(new Object[]{this});
                        }
                        this.forgetType();
                        this._parent.childDestroyed(this);
                        this.invalidateSubtree();
                        super.destroy();
                        this._alive = false;
                    }
                }
                this.disableDumping();
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(java.util.logging.Level.FINE)) break block11;
                LOGGER.logp(java.util.logging.Level.FINE, this.getClass().getName(), "destroy", e.getMessage(), e);
            }
        }
    }

    synchronized void invalidateSubtree() {
        while (this.mSensors.size() > 0) {
            Sensor sensor = this.mSensors.firstElement();
            sensor.destroy();
        }
        while (this.mChildNouns.size() > 0) {
            Noun child = this.mChildNouns.firstElement();
            child.destroy();
        }
    }

    @Deprecated
    public TreeNode search(TreeNode previous, String matchStr) {
        TreeNode[] nodes = this.search(matchStr);
        return nodes == null ? null : nodes[0];
    }

    @Deprecated
    public TreeNode[] search(String matchStr) {
        if (!this._alive) {
            return null;
        }
        Vector<TreeNode> holder = new Vector<TreeNode>();
        this.doSearch(matchStr, holder);
        if (holder.size() == 0) {
            return null;
        }
        Object[] retval = new TreeNode[holder.size()];
        holder.copyInto(retval);
        return retval;
    }

    private void doSearch(String matchStr, Vector<TreeNode> holder) {
        int i;
        Vector<Metric> mets;
        if (this._name.indexOf(matchStr) != -1) {
            holder.addElement(this);
        }
        if ((mets = this.getMetrics()) != null) {
            for (i = mets.size() - 1; i >= 0; --i) {
                Metric met = mets.elementAt(i);
                String metname = met.getName();
                if (metname.indexOf(matchStr) == -1) continue;
                holder.addElement(met);
            }
        }
        if (this.mChildNouns != null) {
            for (i = this.mChildNouns.size() - 1; i >= 0; --i) {
                Noun child = this.mChildNouns.elementAt(i);
                child.doSearch(matchStr, holder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Noun[] getDescendants(boolean recurse, String type) {
        if (!this._alive) {
            return null;
        }
        if (recurse) {
            return this.getDescendants(type);
        }
        int j = 0;
        int kids = 0;
        Noun[] all = null;
        Noun noun = this;
        synchronized (noun) {
            kids = this.mChildNouns.size();
            all = new Noun[kids];
            Noun kid = null;
            for (int i = 0; i < kids; ++i) {
                kid = this.mChildNouns.elementAt(i);
                if (!type.equals(kid.getType())) continue;
                all[j++] = kid;
            }
        }
        if (j == 0) {
            return null;
        }
        kids = j;
        Noun[] type_nouns = new Noun[kids];
        for (int i = 0; i < kids; ++i) {
            type_nouns[i] = all[i];
        }
        return type_nouns;
    }

    public synchronized TreeNode[] getDescendants(boolean recurse) {
        if (!this._alive) {
            return new TreeNode[0];
        }
        Vector<TreeNode> holder = new Vector<TreeNode>();
        if (!recurse) {
            int i;
            holder.addElement(this);
            Vector<Metric> mets = this.getMetrics();
            for (i = mets.size() - 1; i >= 0; --i) {
                holder.addElement(mets.elementAt(i));
            }
            for (i = this.mChildNouns.size() - 1; i >= 0; --i) {
                holder.addElement(this.mChildNouns.elementAt(i));
            }
        } else {
            this.getDescendants(holder);
        }
        Object[] array = new TreeNode[holder.size()];
        holder.copyInto(array);
        return array;
    }

    public synchronized void getDescendants(Vector<TreeNode> holder) {
        int i;
        if (!this._alive) {
            return;
        }
        holder.addElement(this);
        Vector<Metric> mets = this.getMetrics();
        for (i = mets.size() - 1; i >= 0; --i) {
            holder.addElement(mets.elementAt(i));
        }
        for (i = this.mChildNouns.size() - 1; i >= 0; --i) {
            Noun noun = this.mChildNouns.elementAt(i);
            noun.getDescendants(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun[] getNounsByType(String type) {
        if (type == null || type.length() == 0 || "n/a".equals(type)) {
            return null;
        }
        Hashtable<String, NounDescriptor> hashtable = sDescriptorMap;
        synchronized (hashtable) {
            NounDescriptor ndesc = sDescriptorMap.get(type);
            if (ndesc != null) {
                return ndesc.getNouns();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAllTypes() {
        String[] ret = null;
        Hashtable<String, NounDescriptor> hashtable = sDescriptorMap;
        synchronized (hashtable) {
            ret = new String[sDescriptorMap.size()];
            sDescriptorMap.keySet().toArray(ret);
        }
        return ret;
    }

    public static int getTypeCount() {
        return sDescriptorMap.size();
    }

    public static NounDescriptor getDescriptorByType(String type) {
        if (type == null || type.length() == 0) {
            return null;
        }
        return sDescriptorMap.get(type);
    }

    public static void setNounRefresh(String nountype, NounRefresh refresh) {
        if (nountype != null && nountype.length() > 0 && refresh != null) {
            sNounRefreshes.put(nountype, refresh);
        }
    }

    public static void removeNounRefresh(String nountype) {
        if (nountype != null && nountype.length() > 0) {
            sNounRefreshes.remove(nountype);
        }
    }

    public static NounRefresh getNounRefresh(String nountype) {
        if (nountype != null && nountype.length() > 0) {
            return sNounRefreshes.get(nountype);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<NounRefresh> getNounRefresh() {
        Hashtable<String, NounRefresh> hashtable = sNounRefreshes;
        synchronized (hashtable) {
            return new HashSet<NounRefresh>(sNounRefreshes.values());
        }
    }

    public Noun[] getDescendants(String type) {
        if (!this._alive || type == null) {
            return null;
        }
        Vector<Noun> holder = this.getDescendantsByType(type);
        int size = holder.size();
        if (size == 0) {
            return null;
        }
        Object[] nouns = new Noun[size];
        holder.copyInto(nouns);
        return nouns;
    }

    private Vector<Noun> getDescendantsByType(String type) {
        Vector<Noun> descendants = new Vector<Noun>();
        if (type == null || type.length() == 0 || "n/a".equals(type)) {
            return descendants;
        }
        Noun[] nouns = Noun.getNounsByType(type);
        if (nouns == null) {
            return descendants;
        }
        block0: for (int i = nouns.length - 1; i >= 0; --i) {
            if (this == sRootNoun || nouns[i] == this) {
                descendants.addElement(nouns[i]);
                continue;
            }
            Noun n = nouns[i];
            while (n != sRootNoun) {
                if (n == this) {
                    descendants.addElement(nouns[i]);
                    continue block0;
                }
                n = n._parent;
            }
        }
        return descendants;
    }

    public synchronized Noun getChild(String name) {
        for (int i = 0; i < this.mChildNouns.size(); ++i) {
            Noun n = this.mChildNouns.elementAt(i);
            if (!n._name.equals(name)) continue;
            return n;
        }
        return null;
    }

    @Override
    public synchronized Sensor getSensor(String name) {
        for (int i = 0; i < this.mSensors.size(); ++i) {
            Sensor s = this.mSensors.elementAt(i);
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public static Noun create(String pathname, String type, Properties properties) {
        Noun n = Noun.create(pathname, type);
        if (n != null) {
            n.setLoggingProperties(properties);
        }
        return n;
    }

    public static Noun create(Noun parent, String name, String type, Properties properties) {
        Noun n = Noun.create(parent, name, type);
        if (n != null) {
            n.setLoggingProperties(properties);
        }
        return n;
    }

    @Override
    public void setLogLevel(Level level, boolean recurse) {
        if (!this._alive) {
            return;
        }
        if (level == null) {
            return;
        }
        this.sEnabledLogLevel = level;
        if (recurse) {
            int i;
            for (i = this.mChildNouns.size() - 1; i >= 0; --i) {
                Noun child = this.mChildNouns.elementAt(i);
                child.setLogLevel(level, true);
            }
            for (i = this.mSensors.size() - 1; i >= 0; --i) {
                Sensor sensor = this.mSensors.elementAt(i);
                sensor.setLogLevel(level);
            }
        } else {
            for (int i = this.mSensors.size() - 1; i >= 0; --i) {
                Sensor sensor = this.mSensors.elementAt(i);
                sensor.notifyLogLevel(this.sEnabledLogLevel);
            }
        }
    }

    @Override
    @Deprecated
    public void setLogLevel(LogLevel level, boolean recurse) {
        this.setLogLevel((Level)level, recurse);
    }

    @Override
    public Level getLogLevel() {
        return this.sEnabledLogLevel;
    }

    public static void setLogLevel(String pathname, Level level, boolean recurse) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            n.setLogLevel(level, recurse);
        }
    }

    @Deprecated
    public static void setLogLevel(String pathname, LogLevel level, boolean recurse) {
        Noun.setLogLevel(pathname, (Level)level, recurse);
    }

    public static Level getLogLevel(String pathname) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n.getLogLevel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogWriter(LogWriter writer) {
        if (!this._alive) {
            return;
        }
        ArrayList<LogWriter> arrayList = this.sLogWriters;
        synchronized (arrayList) {
            if (!this.sLogWriters.contains(writer)) {
                this.sLogWriters.add(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogWriter(LogWriter writer) {
        if (!this._alive) {
            return;
        }
        ArrayList<LogWriter> arrayList = this.sLogWriters;
        synchronized (arrayList) {
            this.sLogWriters.remove(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogWriter[] getLogWriters() {
        LogWriter[] writers;
        if (!this._alive) {
            return new LogWriter[0];
        }
        ArrayList<LogWriter> arrayList = this.sLogWriters;
        synchronized (arrayList) {
            writers = this.sLogWriters.toArray(new LogWriter[this.sLogWriters.size()]);
        }
        return writers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(LogMessage msg, boolean flush) {
        for (Noun n = this; n != null; n = n.getParent()) {
            ArrayList<LogWriter> arrayList = n.sLogWriters;
            synchronized (arrayList) {
                for (int i = 0; i < n.sLogWriters.size(); ++i) {
                    n.sLogWriters.get(i).write(msg, flush);
                    Log.logMsgEventOccurred();
                }
                continue;
            }
        }
    }

    @Override
    public void setLoggingProperties(Properties properties) {
        HashMap<String, String> logProperties = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            logProperties.put(key, properties.getProperty(key));
        }
        this.sLogProperties = logProperties;
    }

    protected String getLogProperty(String name) {
        String value = null;
        for (Noun n = this; n != null; n = n.getParent()) {
            HashMap<String, String> properties = n.sLogProperties;
            if (properties == null || (value = properties.get(name)) == null) continue;
            return value;
        }
        return value;
    }

    public void disableDumping() {
        block3: {
            String METHOD_NAME = "disableDumping";
            if (this.mDumperThread != null) {
                try {
                    this.mDumperThread.interrupt();
                    this.mDumperThread.join();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(java.util.logging.Level.FINE)) break block3;
                    LOGGER.logp(java.util.logging.Level.FINE, this.getClass().getName(), "disableDumping", e.getMessage(), e);
                }
            }
        }
    }

    public void enableDumping(int interval, String dumpdir, int max, NounDumpListener lsnr) {
        if (!this._alive) {
            return;
        }
        if (interval <= 0 || dumpdir == null || dumpdir.equals("") || max <= 0) {
            return;
        }
        if (this.mDumperThread != null) {
            return;
        }
        this.mDumperThread = new NounDumperThread(this, interval, dumpdir, max, lsnr);
        this.mDumperThread.setDaemon(true);
        this.mDumperThread.start();
    }

    public Noun getCousin(Noun pre) {
        if (!this._alive) {
            return null;
        }
        if (pre == null) {
            return pre;
        }
        Vector<Noun> ancestors = new Vector<Noun>();
        Noun anc = this;
        while (anc != sRootNoun) {
            ancestors.addElement(anc);
            anc = anc._parent;
        }
        pre = Noun.create(pre, DRILLDOWN_INDICATOR, "n/a");
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            anc = (Noun)ancestors.elementAt(i);
            String cousinType = anc.getType();
            if (!cousinType.equals("n/a")) {
                cousinType = DRILLDOWN_TYPE_PREFIX + cousinType;
            }
            pre = Noun.create(pre, anc.getName(), cousinType);
            Sensor[] sArray = anc.getSensors();
            for (int s = 0; s < sArray.length; ++s) {
                Sensor sens = sArray[s];
                if (!(sens instanceof State)) continue;
                State.create(pre, sens.getName(), "", "cousin", sens.getValue());
            }
        }
        return pre;
    }

    @Override
    public void dump(PrintWriter pw, String format) {
        this.dumpMetrics(pw, this._getQueryString(format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpMetrics(PrintWriter pw, String queryString) {
        String METHOD_NAME = "dumpMetrics";
        if (!this._alive) {
            return;
        }
        SimpleAgency agency = new SimpleAgency();
        SimpleRequest req = new SimpleRequest();
        req.parseQueryStrings(queryString);
        Reporter reporter = null;
        try {
            reporter = ((Agency)agency).getReporter(req);
            reporter.printResponse(pw);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.logp(java.util.logging.Level.FINE, this.getClass().getName(), "dumpMetrics", e.getMessage(), e);
            }
        }
        finally {
            if (reporter != null) {
                reporter.clear();
            }
        }
    }

    @Override
    public void dump(String filename, String format, boolean append) {
        this.dumpMetrics(filename, this._getQueryString(format), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpMetrics(String filename, String queryString, boolean append) {
        String METHOD_NAME = "dump";
        if (!this._alive) {
            return;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        PrintWriter pw = null;
        try {
            File file = new File(filename);
            boolean isExist = DMSFileUtil.exists(file);
            fos = DMSFileUtil.createFileOutputStream(file, append);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            pw = new PrintWriter(bw);
            this.dumpMetrics(pw, queryString);
            if (!isExist) {
                DMSFileUtil.setReadable(file, false, false);
                DMSFileUtil.setWritable(file, false, false);
                DMSFileUtil.setExecutable(file, false, false);
                DMSFileUtil.setReadable(file, true, true);
                DMSFileUtil.setWritable(file, true, true);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.logp(java.util.logging.Level.FINE, this.getClass().getName(), "dump", e.getMessage(), e);
            }
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                } else if (bw != null) {
                    bw.close();
                } else if (osw != null) {
                    osw.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    private String _getQueryString(String format) {
        StringBuilder queryString = new StringBuilder(QUERY_STRING_BASE);
        queryString.append(format);
        queryString.append('&');
        queryString.append("name");
        queryString.append('=');
        queryString.append(this.toString());
        return queryString.toString();
    }

    public Noun rollup(String type, byte descendents) throws InstrumentationException {
        boolean recurse;
        String ru_name;
        if (!this._alive || type == null || type.length() <= 0 || type.equals("n/a")) {
            return null;
        }
        type = DMSUtil.sanitize(type, 511, true, true);
        String ru_type = ru_name = type + RU_SUFFIX;
        Noun ru_noun = Noun.create(this, ru_name, ru_type);
        State desc = State.create(ru_noun, RU_DESCENDENTS, (byte)5, "", RU_DESCENDENTS_DESC);
        if (descendents == 2) {
            desc.update("all");
            recurse = true;
        } else {
            desc.update("direct");
            recurse = false;
        }
        State count = State.create(ru_noun, RU_COUNT, (byte)3, RU_UNITS, RU_COUNT_DESC);
        count.update(0);
        Rollup ru = new Rollup(ru_noun, count, type, recurse);
        count.setRefresh(ru);
        return ru_noun;
    }

    public static void bucket(String type, String key) {
        if (type == null || key == null) {
            return;
        }
        ArrayList<String> keys = sBucketTypes.get(type);
        if (keys == null) {
            keys = new ArrayList();
        }
        keys.add(key);
        sBucketTypes.put(type, keys);
    }

    ArrayList<String> getBucketKeys() {
        return this.mBucketKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        if (DMSConsole.s_logger.isLoggable(java.util.logging.Level.FINE)) {
            DMSConsole.s_logger.log(java.util.logging.Level.FINE, "Noun class is being shutdown {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        sStatus = 2;
        Noun rootNoun = sRootNoun;
        sRootNoun = new Noun();
        Noun noun = rootNoun;
        synchronized (noun) {
            rootNoun.invalidateSubtree();
        }
        sNounCache.clear();
        if (sBucketTypes != null) {
            sBucketTypes.clear();
        }
        sDescriptorMap.clear();
        sStatus = 2;
    }

    public boolean getTraceImplicitStateValueEvents() {
        return this.mTraceImplicitStateValueEvents;
    }

    void setTraceImplicitStateValueEvents(boolean b) {
        this.mTraceImplicitStateValueEvents = b;
    }

    public int getDepthInTree() {
        if (this._parent == null) {
            return 1;
        }
        return 1 + this._parent.getDepthInTree();
    }

    public int getDescendantNounCount() {
        int retVal = 0;
        if (this.mChildNouns != null) {
            for (Noun n : this.mChildNouns) {
                retVal = retVal + 1 + n.getDescendantNounCount();
            }
        }
        return retVal;
    }

    public int getDescendantSensorCount() {
        int retVal = this.getChildSensorCount();
        if (this.mChildNouns != null) {
            for (Noun n : this.mChildNouns) {
                retVal += n.getDescendantSensorCount();
            }
        }
        return retVal;
    }

    public int getChildSensorCount() {
        int retVal = 0;
        if (this.mSensors != null) {
            retVal = this.mSensors.size();
        }
        return retVal;
    }

    public int getChildNounCount() {
        int retVal = 0;
        if (this.mChildNouns != null) {
            retVal = this.mChildNouns.size();
        }
        return retVal;
    }

    public Object setClientObject(ClientObjectKey key, Object value) {
        return this.mClientObjectHolderImpl.setClientObject(key, value);
    }

    public Object getClientObject(ClientObjectKey key) {
        return this.mClientObjectHolderImpl.getClientObject(key);
    }

    static {
        LOGGER = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");
        sRootNoun = new Noun();
        StringBuilder queryString = new StringBuilder("operation");
        queryString.append('=');
        queryString.append("get");
        queryString.append('&');
        queryString.append("units");
        queryString.append('=');
        queryString.append("true");
        queryString.append('&');
        queryString.append("value");
        queryString.append('=');
        queryString.append("true");
        queryString.append('&');
        queryString.append("description");
        queryString.append('=');
        queryString.append("true");
        queryString.append('&');
        queryString.append("recurse");
        queryString.append('=');
        queryString.append("all");
        queryString.append('&');
        queryString.append("format");
        QUERY_STRING_BASE = queryString.toString();
    }
}

