/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import oracle.dms.table.Bool;
import oracle.dms.table.Row;
import oracle.dms.table.RowSelector;
import oracle.dms.table.Selector;
import oracle.dms.table.ValueType;

class CompareSelector
extends RowSelector {
    String m_column = null;
    Serializable m_value = null;

    CompareSelector(String column, Serializable value, Selector.Operator operator) {
        super(operator);
        if (column == null || column.trim().length() == 0) {
            throw new IllegalArgumentException("column=" + column + " value=" + value);
        }
        this.m_column = column;
        this.m_value = value;
    }

    @Override
    public boolean select(Row row) {
        if (row == null) {
            return false;
        }
        ValueType typeId = row.getTypeID(this.m_column);
        Serializable value1 = row.getValue(this.m_column);
        Bool bool = this.selectObject(value1, this.m_value, typeId);
        return bool.equals(Bool.TRUE);
    }

    public String toString() {
        switch (this.m_operator) {
            case EQ: {
                return '(' + this.m_column + " EQ " + this.m_value.toString() + ')';
            }
            case NE: {
                return '(' + this.m_column + " NE " + this.m_value.toString() + ')';
            }
            case GT: {
                return '(' + this.m_column + " GT " + this.m_value.toString() + ')';
            }
            case GE: {
                return '(' + this.m_column + " GE " + this.m_value.toString() + ')';
            }
            case LT: {
                return '(' + this.m_column + " LT " + this.m_value.toString() + ')';
            }
            case LE: {
                return '(' + this.m_column + " LE " + this.m_value.toString() + ')';
            }
            case EQNOCASE: {
                return '(' + this.m_column + " EQNoCase " + this.m_value.toString() + ')';
            }
            case CONTAINS: {
                return '(' + this.m_column + " Contains " + this.m_value.toString() + ')';
            }
            case CONTAINSTOKEN: {
                return '(' + this.m_column + " ContainsToken " + this.m_value.toString() + ')';
            }
            case STARTSWITH: {
                return '(' + this.m_column + " StartsWith " + this.m_value.toString() + ')';
            }
            case ENDSWITH: {
                return '(' + this.m_column + " EndsWith " + this.m_value.toString() + ')';
            }
            case IS_NULL: {
                return "(IS_NULL " + this.m_column + ')';
            }
            case NOT_NULL: {
                return "(NOT_NULL " + this.m_column + ')';
            }
        }
        return super.toString();
    }
}

