/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.common;

import java.io.Serializable;

public enum ArgumentType implements Serializable
{
    DOUBLE(Double.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Double(value);
        }
    }),
    FLOAT(Float.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Float(value);
        }
    }),
    INTEGER(Integer.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Integer(value);
        }
    }),
    LONG(Long.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Long(value);
        }
    }),
    SHORT(Short.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Short(value);
        }
    }),
    BYTE(Byte.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return new Byte(value);
        }
    }),
    CHAR(Character.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            if (value != null && value.length() > 0) {
                return Character.valueOf(value.charAt(0));
            }
            return null;
        }
    }),
    BOOLEAN(Boolean.TYPE, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return Boolean.valueOf(value);
        }
    }),
    STRING(String.class, new TypeConvertor(){

        @Override
        public Serializable convertToType(String value) {
            return value;
        }
    });

    private Class m_type;
    private TypeConvertor m_convertor;
    private static final long serialVersionUID = 0L;

    private ArgumentType(Class type, TypeConvertor convertor) {
        this.m_type = type;
        this.m_convertor = convertor;
    }

    public boolean isValidType(Serializable object) {
        return this.m_type.isAssignableFrom(object.getClass());
    }

    public Serializable convertToType(String s) {
        Serializable value = null;
        if (s != null) {
            try {
                value = this.m_convertor.convertToType(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    static interface TypeConvertor {
        public Serializable convertToType(String var1);
    }
}

