/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServletUtils {
    private static final List<String> sHeaderWhiteList = new LinkedList<String>();

    public static String getRequestAsPrettyString(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Request URI:\n  ").append(request.getRequestURI()).append("\n");
        sb.append("Request URL:\n  ").append(request.getRequestURL()).append("\n");
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("Query String:\n  ").append(request.getQueryString()).append("\n");
        } else {
            sb.append("(No Query String)\n");
        }
        List<String> allHeaderNames = ServletUtils.getAllHeaderNames(request);
        if (allHeaderNames.size() == 0) {
            sb.append("(No Headers)\n");
        } else {
            sb.append("All Headers Names:\n  ");
            boolean appendComma = false;
            for (String headerName : allHeaderNames) {
                if (appendComma) {
                    sb.append(", ");
                }
                sb.append(headerName);
                appendComma = true;
            }
            sb.append("\n");
            Map<String, List<String>> whiteListedHeaders = ServletUtils.getHeaders(request, sHeaderWhiteList);
            if (whiteListedHeaders.size() > 0) {
                sb.append("Selected Header Values:\n");
                for (Map.Entry<String, List<String>> entry : whiteListedHeaders.entrySet()) {
                    String headerName = entry.getKey();
                    List<String> headerValues = entry.getValue();
                    if (headerValues.size() == 0) {
                        sb.append("  " + headerName + " : (no values)\n");
                        continue;
                    }
                    if (headerValues.size() == 1) {
                        sb.append("  " + headerName + " : " + headerValues.get(0) + "\n");
                        continue;
                    }
                    sb.append("  " + headerName + " : \n");
                    for (String value : headerValues) {
                        sb.append("    " + value + "\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, List<String>> getHeaders(HttpServletRequest request, List<String> headerNameWhiteList) {
        HashMap<String, List<String>> retVal = new HashMap<String, List<String>>();
        List<String> headerNames = null;
        if (headerNameWhiteList != null) {
            headerNames = new LinkedList<String>();
            for (String s : ServletUtils.getAllHeaderNames(request)) {
                if (!headerNameWhiteList.contains(s)) continue;
                headerNames.add(s);
            }
        } else {
            headerNames = ServletUtils.getAllHeaderNames(request);
        }
        for (String headerName : headerNames) {
            LinkedList hv = new LinkedList();
            retVal.put(headerName, hv);
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                hv.add(headerValues.nextElement());
            }
        }
        return retVal;
    }

    public static List<String> getAllHeaderNames(HttpServletRequest request) {
        LinkedList<String> retVal = new LinkedList<String>();
        Enumeration h = request.getHeaderNames();
        while (h.hasMoreElements()) {
            retVal.add((String)h.nextElement());
        }
        return retVal;
    }

    static {
        sHeaderWhiteList.add("Accept");
        sHeaderWhiteList.add("Accept-Charset");
        sHeaderWhiteList.add("Accept-Encoding");
        sHeaderWhiteList.add("Accept-Language");
        sHeaderWhiteList.add("Connection");
        sHeaderWhiteList.add("Content-Length");
        sHeaderWhiteList.add("Content-Type");
        sHeaderWhiteList.add("ECID-Context");
        sHeaderWhiteList.add("Host");
        sHeaderWhiteList.add("Origin");
        sHeaderWhiteList.add("Referer");
        sHeaderWhiteList.add("TE");
        sHeaderWhiteList.add("User-Agent");
    }
}

