/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.config.parameter.ParameterConfig;

public abstract class DMSProperties {
    public static final String LOGLEVEL_PROPERTY_KEY = "loglevel";
    public static final String LOGWRITER_PROPERTY_KEY = "logwriter";
    private static final String LOGLEVEL_SUFFIX = "LogLevel";
    private static final String LOGWRITER_SUFFIX = "LogWriter";
    private static final String DMS_PREFIX = "oracle.dms.";
    private static final int DMS_PREFIX_LEN = "oracle.dms.".length();
    private static ParameterConfig s_config = null;
    public static final String ORACLE_SERVER_NAME = "oracle.server.name";
    public static final String PROCESS_UID = "oracle.process.uid";
    public static final String CONFIG_DIR = "oracle.server.config.dir";
    public static final String DOMAIN_CONFIG_DIR = "oracle.domain.config.dir";
    public static final String LOG_DIR = "oracle.server.log.dir";
    public static final String ORACLE_CLUSTER_NAME = "oracle.cluster.name";
    public static final String ORACLE_HOME = "oracle.home";
    public static final String ORACLE_INSTANCE = "oracle.instance";
    public static final String DOMAIN_HOME = "domain.home";
    public static final String WEBLOGIC_NAME = "weblogic.Name";
    public static final String ORACLE_COMMON = "common.components.home";
    public static final String PLATFORM = "oracle.dms.platform";
    public static final String JAVA_VM_NAME = "java.vm.name";
    public static final String JAVA_VM_VERSION = "java.vm.version";
    public static final String JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String NODE_MANAGER_PORT = "ListenPort";
    public static final String DMS_CONFIGURATION_FILE = "oracle.dms.config.file";
    public static final String ORACLE_DMS_CONTEXT = "oracle.dms.context";
    public static final String ORACLE_DMS_CLOCK = "oracle.dms.clock";
    public static final String ORACLE_DMS_CLOCK_UNITS = "oracle.dms.clock.units";
    public static final String ORACLE_DMS_SENSORS = "oracle.dms.sensors";
    public static final String ORACLE_DMS_PUBLISHER_CLASSES = "oracle.dms.publisher.classes";
    public static final String ORACLE_DMS_HTTPD_PORT_START = "oracle.dms.httpd.port.start";
    public static final String ORACLE_DMS_SPY_JVM = "oracle.dms.spy.jvm";
    public static final String ORACLE_DMS_SPY_JVM_THREAD_MONITOR_ENABLE = "oracle.dms.spy.jvm.ThreadMonitor.enable";
    public static final String ORACLE_DMS_SPY_JVM_THREAD_MONITOR_THREAD_LIST_REFRESH = "oracle.dms.spy.jvm.ThreadMonitor.threadListRefresh";
    public static final String ENFORCE_NON_DEC_TIME_PROPERTY_NAME = "oracle.dms.time.enforceNonDecreasingTime";
    public static final String INSTRUMENT_LIFECYCLE_NAMES = "oracle.dms.instrument.LifecycleListener.classNames";
    public static final String INSTRUMENT_LIFECYCLE_NOUNS = "oracle.dms.instrument.LifecycleListener.reportNouns";
    public static final String INSTRUMENT_LIFECYCLE_SENSORS = "oracle.dms.instrument.LifecycleListener.reportSensors";
    public static final String INSTRUMENT_LIFECYCLE_STACK = "oracle.dms.instrument.LifecycleListener.stackDecimation";
    @Deprecated
    public static final String DMS_PROPERTIES_FILE = "oracle.dms.property.file";
    private static HashSet<String> s_goodKeys = new HashSet();
    private static ArrayList<String> s_validConfigParams = new ArrayList();
    private static ArrayList<String> s_deprecatedProperties = new ArrayList();
    private static Properties s_fileProperties;
    private static Properties s_paramProperties;
    private static boolean s_inited;
    private static volatile HashMap<String, HashMap<String, Object>> s_nounPropertiesMap;
    private static volatile HashMap<String, HashMap<String, String>> s_sensorPropertiesMap;
    private static volatile HashMap<String, Properties> s_logWriterProperties;
    private static final String CLASS_NAME;
    private static final Logger LOGGER;
    static String[] dummyStringArray;

    @Deprecated
    public static void init() {
        DMSProperties.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void init(Properties props) {
        String METHOD_NAME = "init";
        DMSProperties.append(props);
        Class<DMSProperties> clazz = DMSProperties.class;
        synchronized (DMSProperties.class) {
            if (s_inited) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            s_inited = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String configFile = null;
            try {
                configFile = DMSProperties.getSystemProperty(DMS_PROPERTIES_FILE);
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "init", "Failed to get Java system property: oracle.dms.property.file", e);
                }
                DMSProperties.updateConfiguration(s_paramProperties);
                return;
            }
            if (configFile == null || configFile.trim().length() == 0) {
                DMSProperties.updateConfiguration();
                return;
            }
            Properties properties = new Properties();
            InputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(configFile));
                properties.load(input);
                s_fileProperties = properties;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "init", "unable to load configuration file \"" + configFile + "\"", e);
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "init", "unable to load configuration file \"" + configFile + "\"", e);
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            DMSProperties.updateConfiguration();
            return;
        }
    }

    public static String getProperty(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        String property = DMSProperties.getProperty(key);
        if (property != null) {
            return property;
        }
        return defaultString;
    }

    public static void append(Properties props) {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            DMSProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        s_paramProperties.put(key, value);
        DMSProperties.updateConfiguration(key, value);
    }

    public static void removeProperty(String key) {
        if (key == null) {
            return;
        }
        s_paramProperties.remove(key);
    }

    public static void concatProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        String oldValue = DMSProperties.getProperty(key);
        if (oldValue == null) {
            DMSProperties.setProperty(key, value);
        } else {
            DMSProperties.setProperty(key, oldValue + value);
        }
    }

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String property = null;
        if (s_paramProperties != null && (property = s_paramProperties.getProperty(key)) != null) {
            return property;
        }
        try {
            property = DMSProperties.getSystemProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (property != null) {
            return property;
        }
        if (s_fileProperties != null) {
            return s_fileProperties.getProperty(key);
        }
        if (s_config != null && DMSProperties.isConfigProperty(key)) {
            return DMSProperties.getConfigProperty(key);
        }
        return null;
    }

    public static String[] isAnyPropertyDefined(String[] propertyNames) {
        ArrayList<String> retArrayList = new ArrayList<String>();
        for (String s : propertyNames) {
            if (DMSProperties.getProperty(s) == null) continue;
            retArrayList.add(s);
        }
        return retArrayList.size() < 1 ? null : retArrayList.toArray(dummyStringArray);
    }

    public static int getPropertyInt(String key, int defaultInt) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultInt;
        }
        try {
            return Integer.parseInt(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultInt;
        }
    }

    public static int getPropertyInt(String key, int defaultInt, int minInt) {
        int value = DMSProperties.getPropertyInt(key, defaultInt);
        if (value < minInt) {
            value = defaultInt;
        }
        return value;
    }

    public static long getPropertyLong(String key, long defaultLong) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultLong;
        }
        try {
            return Long.parseLong(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultLong;
        }
    }

    public static double getPropertyDouble(String key, double defaultDouble) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultDouble;
        }
        try {
            return Double.parseDouble(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultDouble;
        }
    }

    public static boolean getPropertyBoolean(String key, boolean defaultBoolean) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultBoolean;
        }
        return Boolean.parseBoolean(property.trim());
    }

    private DMSProperties() {
    }

    public static final boolean hasNounProperties() {
        return s_nounPropertiesMap != null && s_nounPropertiesMap.size() > 0;
    }

    public static final boolean hasSensorProperties() {
        return s_sensorPropertiesMap != null && s_sensorPropertiesMap.size() > 0;
    }

    public static final HashMap<String, Object> getNounProperties(String pathName) {
        if (DMSProperties.hasNounProperties()) {
            return s_nounPropertiesMap.get(pathName);
        }
        return null;
    }

    public static final HashMap<String, String> getSensorProperties(String pathName) {
        if (DMSProperties.hasSensorProperties()) {
            return s_sensorPropertiesMap.get(pathName);
        }
        return null;
    }

    public static Map<String, Properties> getLogWriterProperties() {
        return s_logWriterProperties;
    }

    private static void updateConfiguration(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> iter = props.keys();
        while (iter.hasMoreElements()) {
            String value;
            String key = (String)iter.nextElement();
            if (!key.startsWith(DMS_PREFIX)) continue;
            try {
                value = props.getProperty(key);
            }
            catch (Exception e) {
                return;
            }
            DMSProperties.updateConfiguration(key, value);
        }
    }

    private static final void updateConfiguration(String key, String value) {
        if (!key.startsWith(DMS_PREFIX)) {
            return;
        }
        int typeEnd = key.indexOf(46, DMS_PREFIX_LEN);
        if (typeEnd < 0) {
            return;
        }
        String type = key.substring(DMS_PREFIX_LEN, typeEnd);
        String prop = null;
        if (typeEnd + 1 < key.length()) {
            prop = key.substring(typeEnd + 1);
        }
        if (type.equals(LOGWRITER_SUFFIX)) {
            DMSProperties.updateLogWriters(prop, value);
        } else if (type.equals("Noun")) {
            DMSProperties.updateNounProperties(prop, value);
        } else if (type.equals("Sensor")) {
            DMSProperties.updateSensorProperties(prop, value);
        }
    }

    private static void updateConfiguration() {
        Properties sysProperties;
        DMSProperties.updateConfiguration(s_fileProperties);
        try {
            sysProperties = DMSProperties.getSystemProperties();
        }
        catch (Exception e) {
            sysProperties = null;
        }
        DMSProperties.updateConfiguration(sysProperties);
        DMSProperties.updateConfiguration(s_paramProperties);
    }

    private static void updateLogWriters(String property, String value) {
        Properties props;
        String METHOD_NAME = "updateLogWriters";
        int suffixIndex = property.indexOf(46);
        if (suffixIndex < 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "updateLogWriters", "Log property name should contain '.': name = \"" + property + "\", value = \"" + value + "\": ");
            }
            return;
        }
        String name = property.substring(0, suffixIndex);
        if (name.trim().length() == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "updateLogWriters", "Log property name should not start with '.': name = \"" + property + "\", value = \"" + value + "\": ");
            }
            return;
        }
        String suffix = property.substring(suffixIndex + 1);
        if (s_logWriterProperties == null) {
            s_logWriterProperties = new HashMap();
        }
        if ((props = s_logWriterProperties.get(name)) == null) {
            props = new Properties();
            s_logWriterProperties.put(name, props);
        }
        props.setProperty(suffix, value);
    }

    private static void updateNounProperties(String property, String value) {
        ArrayList<String> list;
        HashMap<String, Object> prop;
        String path;
        String suffix;
        String METHOD_NAME = "updateNounProperties";
        int suffixIndex = property.lastIndexOf(46);
        if (suffixIndex + 1 == property.length()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "updateNounProperties", "Noun property name should not end with '.': name = \"" + property + "\", value = \"" + value + "\": ");
            }
            return;
        }
        if (suffixIndex < 0) {
            suffix = property;
            path = "/";
        } else {
            suffix = property.substring(suffixIndex + 1);
            String name = property.substring(0, suffixIndex);
            path = '/' + name.replace('.', '/');
        }
        if (s_nounPropertiesMap == null) {
            s_nounPropertiesMap = new HashMap();
        }
        if ((prop = s_nounPropertiesMap.get(path)) == null) {
            prop = new HashMap();
            s_nounPropertiesMap.put(path, prop);
        }
        if (suffix.equals(LOGLEVEL_SUFFIX)) {
            prop.put(LOGLEVEL_PROPERTY_KEY, value);
        } else if (suffix.equals(LOGWRITER_SUFFIX) && (list = DMSProperties.parseNameList(value)) != null) {
            prop.put(LOGWRITER_PROPERTY_KEY, list);
        }
    }

    private static void updateSensorProperties(String property, String value) {
        HashMap<String, String> prop;
        String METHOD_NAME = "updateSensorProperties";
        int suffixIndex = property.lastIndexOf(46);
        if (suffixIndex < 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "updateSensorProperties", "Sensor property name should contain '.': name = \"" + property + "\", value = \"" + value + "\": ");
            }
            return;
        }
        if (suffixIndex + 1 == property.length()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "updateSensorProperties", "Sensor property name should not end with '.': name = \"" + property + "\", value = \"" + value + "\": ");
            }
            return;
        }
        String suffix = property.substring(suffixIndex + 1);
        String name = property.substring(0, suffixIndex);
        String path = '/' + name.replace('.', '/');
        if (s_sensorPropertiesMap == null) {
            s_sensorPropertiesMap = new HashMap();
        }
        if ((prop = s_sensorPropertiesMap.get(path)) == null) {
            prop = new HashMap();
            s_sensorPropertiesMap.put(path, prop);
        }
        if (suffix.equals(LOGLEVEL_SUFFIX)) {
            prop.put(LOGLEVEL_PROPERTY_KEY, value);
        }
    }

    private static ArrayList<String> parseNameList(String s) {
        String aux;
        ArrayList<String> ret = new ArrayList<String>();
        int prevIndex = 0;
        int nextIndex = s.indexOf(44, prevIndex);
        while (nextIndex >= 0) {
            aux = s.substring(prevIndex, nextIndex).trim();
            if (aux.trim().length() > 0) {
                ret.add(aux);
            }
            prevIndex = nextIndex + 1;
            nextIndex = s.indexOf(44, prevIndex);
        }
        aux = s.substring(prevIndex, s.length()).trim();
        if (aux.trim().length() > 0) {
            ret.add(aux);
        }
        return ret;
    }

    static String getSystemProperty(final String key) {
        String value = null;
        if (key.startsWith(DMS_PREFIX) || s_goodKeys.contains(key)) {
            value = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        return value;
    }

    private static Properties getSystemProperties() {
        Properties props = null;
        props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        return props;
    }

    public static String deprecatedSystemPropertiesSet() {
        StringBuffer propertyList = new StringBuffer();
        Properties properties = DMSProperties.getSystemProperties();
        String property = null;
        Iterator<String> itr = s_deprecatedProperties.iterator();
        while (itr.hasNext()) {
            property = itr.next().toString();
            if (!properties.containsKey(property)) continue;
            propertyList = propertyList.append(property + " ");
        }
        if (propertyList.length() == 0) {
            return null;
        }
        return propertyList.toString();
    }

    private static boolean isConfigProperty(String key) {
        return s_validConfigParams.contains(key);
    }

    public static Map<String, String> listAllRuntimeDMSConfigParams() {
        HashMap<String, String> retVal = new HashMap<String, String>(s_validConfigParams.size());
        for (String param : s_validConfigParams) {
            retVal.put(param, DMSProperties.getProperty(param));
        }
        return retVal;
    }

    private static String getConfigProperty(String key) {
        String retVal = null;
        if (key != null) {
            if (key.equals(ORACLE_DMS_CONTEXT)) {
                retVal = s_config.isDMSContextEnabled() ? "ON" : "OFF";
            } else if (key.equals(ORACLE_DMS_CLOCK)) {
                retVal = s_config.getDMSClockType().toString();
            } else if (key.equals(ORACLE_DMS_CLOCK_UNITS)) {
                switch (s_config.getDMSClockUnits()) {
                    case MILLISECONDS: {
                        retVal = "MSECS";
                        break;
                    }
                    case MICROSECONDS: {
                        retVal = "USECS";
                        break;
                    }
                    case NANOSECONDS: {
                        retVal = "NSECS";
                    }
                }
            } else if (key.equals(ORACLE_DMS_SENSORS)) {
                retVal = s_config.getSensorActivationLevel().toString().toLowerCase();
            } else if (key.equals(ORACLE_DMS_PUBLISHER_CLASSES)) {
                retVal = s_config.getDMSPublisherClass();
            } else if (key.equals(ORACLE_DMS_HTTPD_PORT_START)) {
                retVal = String.valueOf(s_config.getDMSHTTPPort());
            } else if (key.equals(ORACLE_DMS_SPY_JVM)) {
                retVal = s_config.isJVMMemoryStatsEnabled() ? "true" : "false";
            } else if (key.equals(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_ENABLE)) {
                retVal = s_config.isJVMThreadMonitorEnabled() ? "true" : "false";
            } else if (key.equals(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_THREAD_LIST_REFRESH)) {
                retVal = String.valueOf(s_config.getJVMThreadMonitorRefreshIntervalSeconds());
            } else if (key.equals(ENFORCE_NON_DEC_TIME_PROPERTY_NAME)) {
                retVal = s_config.isNonDecreasingTimeEnabled() ? "true" : "false";
            }
        }
        return retVal;
    }

    public static void setParamConfig(ParameterConfig config) {
        s_config = config;
    }

    public static ParameterConfig getParamConfig() {
        return s_config;
    }

    public static synchronized void exit() {
        s_nounPropertiesMap = null;
        s_sensorPropertiesMap = null;
        s_logWriterProperties = null;
        s_fileProperties = null;
        s_paramProperties.clear();
        s_inited = false;
    }

    static {
        s_goodKeys.add(ORACLE_SERVER_NAME);
        s_goodKeys.add(PROCESS_UID);
        s_goodKeys.add(CONFIG_DIR);
        s_goodKeys.add(DOMAIN_CONFIG_DIR);
        s_goodKeys.add(LOG_DIR);
        s_goodKeys.add(ORACLE_CLUSTER_NAME);
        s_goodKeys.add(ORACLE_HOME);
        s_goodKeys.add(ORACLE_INSTANCE);
        s_goodKeys.add(DOMAIN_HOME);
        s_goodKeys.add(WEBLOGIC_NAME);
        s_goodKeys.add(ORACLE_COMMON);
        s_goodKeys.add("java.io.tmpdir");
        s_goodKeys.add("user.dir");
        s_goodKeys.add("user.home");
        s_goodKeys.add("line.separator");
        s_goodKeys.add(JAVA_VM_NAME);
        s_goodKeys.add(JAVA_VM_VERSION);
        s_goodKeys.add(JAVA_VM_SPECIFICATION_VERSION);
        s_goodKeys.add(NODE_MANAGER_PORT);
        s_deprecatedProperties.add(DMS_PROPERTIES_FILE);
        s_deprecatedProperties.add(ORACLE_DMS_CONTEXT);
        s_deprecatedProperties.add(ORACLE_DMS_PUBLISHER_CLASSES);
        s_deprecatedProperties.add(ORACLE_DMS_HTTPD_PORT_START);
        s_deprecatedProperties.add(ORACLE_DMS_SPY_JVM);
        s_deprecatedProperties.add(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_ENABLE);
        s_deprecatedProperties.add(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_THREAD_LIST_REFRESH);
        s_deprecatedProperties.add(ENFORCE_NON_DEC_TIME_PROPERTY_NAME);
        s_deprecatedProperties.add(ORACLE_DMS_CLOCK);
        s_deprecatedProperties.add(ORACLE_DMS_CLOCK_UNITS);
        s_deprecatedProperties.add(ORACLE_DMS_SENSORS);
        s_deprecatedProperties.add(INSTRUMENT_LIFECYCLE_NAMES);
        s_deprecatedProperties.add(INSTRUMENT_LIFECYCLE_NOUNS);
        s_deprecatedProperties.add(INSTRUMENT_LIFECYCLE_SENSORS);
        s_deprecatedProperties.add(INSTRUMENT_LIFECYCLE_STACK);
        s_validConfigParams.add(ORACLE_DMS_CONTEXT);
        s_validConfigParams.add(ORACLE_DMS_CLOCK);
        s_validConfigParams.add(ORACLE_DMS_CLOCK_UNITS);
        s_validConfigParams.add(ORACLE_DMS_SENSORS);
        s_validConfigParams.add(ORACLE_DMS_PUBLISHER_CLASSES);
        s_validConfigParams.add(ORACLE_DMS_HTTPD_PORT_START);
        s_validConfigParams.add(ORACLE_DMS_SPY_JVM);
        s_validConfigParams.add(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_ENABLE);
        s_validConfigParams.add(ORACLE_DMS_SPY_JVM_THREAD_MONITOR_THREAD_LIST_REFRESH);
        s_validConfigParams.add(ENFORCE_NON_DEC_TIME_PROPERTY_NAME);
        s_fileProperties = null;
        s_paramProperties = new Properties();
        s_inited = false;
        CLASS_NAME = DMSProperties.class.getName();
        LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
        dummyStringArray = new String[0];
    }
}

