/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.io.PrintStream;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockDescription;
import oracle.dms.clock.SimpleClockDescription;
import oracle.dms.clock.SimpleTimestamp;
import oracle.dms.clock.Timestamp;
import oracle.dms.util.Time;

public class SimpleClock
implements Clock {
    protected String _name;
    protected ClockDescription _desc;
    protected String _units;
    protected long _maxFrequency;
    protected long _reportedFrequency;
    private static long sLastTime = Long.MIN_VALUE;

    public SimpleClock() {
        this._name = "default";
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = 1000L;
        this._maxFrequency = 1000L;
        this._units = "msecs";
        this.start();
    }

    SimpleClock(String name) {
        this._name = name;
    }

    final void start() {
        this._desc.discover(this);
        this.reset();
    }

    public void reset() {
    }

    @Override
    public long getTime() {
        return Time.currentTimeMillis();
    }

    @Override
    public Timestamp getTimestamp() {
        return new SimpleTimestamp(this.getTime(), this);
    }

    public String toString() {
        return this.getTimestamp().toString();
    }

    @Override
    public long convertTime(long time, long resolution) {
        if (resolution > this._reportedFrequency) {
            long fact = resolution / this._reportedFrequency;
            return time * fact;
        }
        if (resolution < this._reportedFrequency) {
            long fact = this._reportedFrequency / resolution;
            return time / fact;
        }
        return time;
    }

    @Override
    public long adjustTime(long time) {
        return time;
    }

    @Override
    public ClockDescription getDescription() {
        return this._desc;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getUnits() {
        return this._units;
    }

    @Override
    public long getReportedFrequency() {
        return this._reportedFrequency;
    }

    @Override
    public long getMaxFrequency() {
        return this._maxFrequency;
    }

    @Override
    public long getMeasuredFrequency() {
        return this._desc.getMeasuredFrequency();
    }

    @Override
    public double getOverhead() {
        return this._desc.getOverhead();
    }

    @Override
    public void print(PrintStream out) {
        out.println("Clock: " + this._name);
        out.println("    units: " + this.getUnits());
        out.println("    reportedFrequency: " + this.getReportedFrequency() + " ticks per second");
        out.println("    maxFrequency: " + this.getMaxFrequency() + " ticks per second");
        out.println("    measuredFrequency: " + this.getMeasuredFrequency() + " ticks per second");
        out.println("    measuredResolution: " + this._desc.getResolution() + " " + this.getUnits() + " is the minimum nonzero time between calls");
        out.println("    overhead per call: " + this.getOverhead() + " " + this.getUnits());
    }
}

