/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class CompilerStats
implements GroupRefresh {
    private static CompilerStats s_stats = null;
    private CompilationMXBean m_compiler = null;
    private boolean m_compTimeSupported = false;
    private State m_compilerTime = null;

    private CompilerStats() {
    }

    private CompilerStats(Noun baseNoun) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        this.m_compiler = ManagementFactory.getCompilationMXBean();
        if (this.m_compiler == null) {
            return;
        }
        Noun compilerNoun = Noun.create(baseNoun, "compiler", "JVM_Compiler");
        State compilerName = State.create(compilerNoun, "name", (byte)5, "", "name of the JIT");
        compilerName.update(this.m_compiler.getName());
        State compilerTimeSupported = State.create(compilerNoun, "compilerTimeSupported", (byte)5, "", "whether the JVM supports compilation time monitoring");
        this.m_compTimeSupported = this.m_compiler.isCompilationTimeMonitoringSupported();
        compilerTimeSupported.update(this.m_compTimeSupported ? "TRUE" : "FALSE");
        if (this.m_compTimeSupported) {
            this.m_compilerTime = State.create(compilerNoun, "totalTime", (byte)2, "msecs", "approximate accumulated elapsed time spent in compilation");
            this.m_compilerTime.setRefresh(this);
        }
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new CompilerStats(base);
    }

    @Override
    public void refresh() {
        if (this.m_compTimeSupported) {
            this.m_compilerTime.update(this.m_compiler.getTotalCompilationTime());
        }
    }

    static void exit() {
        s_stats = null;
    }
}

