/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.logging.Level;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.PhaseEventActivationToken;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.internal.ParamScopedMetricsRuntimeManager;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class PhaseEvent
extends Sensor
implements PhaseEventIntf {
    private long _duration = 0L;
    private long _exclTime = 0L;
    private int _active = 0;
    private int _maxActive = 0;
    private int _updateCount = 0;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;
    private boolean _isBucketed = false;
    private static volatile Clock _clock = null;
    private int _derivedMetricsFlags = 0;
    static final int NULL_ACTIVATION_UID = -3;
    private static final String UNKNOWN_ACTIVATION_UID_STRING = "?";
    private static final String ANONYMOUS_ACTIVATION_UID_STRING = "-";
    private static final long NOT_ALIVE_STOP_TOKEN = -1L;
    private static final long NOT_ALIVE_ELAPSED_TOKEN = -2L;
    private static final long NOT_ALIVE_START_TOKEN = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(Noun parent, String name, String desc) {
        EventReportingManager eMgr;
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("DMS-50752", "PhaseEvent.create()", "" + parent + ":" + name + ":" + desc);
        }
        PhaseEvent pe = (PhaseEvent)parent.getSensor(name);
        if (pe != null) {
            return pe;
        }
        String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
        boolean newPhaseEvent = false;
        Noun noun = parent;
        synchronized (noun) {
            pe = (PhaseEvent)parent.getSensor(sanitizedName);
            if (pe == null) {
                pe = new PhaseEvent(false, parent, sanitizedName, desc);
                newPhaseEvent = true;
            }
        }
        if (newPhaseEvent && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(pe, EventSourceType.PHASE_SENSOR, EventActionType.CREATE, pe.mCreateTime, null, null);
        }
        return pe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(String pathname, String desc) {
        EventReportingManager eMgr;
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("DMS-50752", "PhaseEvent.create()", "" + pathname + ":" + desc);
        }
        PhaseEvent pe = (PhaseEvent)Sensor.lookupCache(pathname);
        if (pe != null) {
            return pe;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        boolean newPhaseEvent = false;
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            pe = (PhaseEvent)parent.getSensor(sanitizedName);
            if (pe != null) {
                pe.addToCache(pathname);
            } else {
                pe = new PhaseEvent(false, parent, sanitizedName, desc);
                newPhaseEvent = true;
            }
        }
        if (newPhaseEvent && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(pe, EventSourceType.PHASE_SENSOR, EventActionType.CREATE, pe.mCreateTime, null, null);
        }
        return pe;
    }

    public static PhaseEvent create(String pathname, String desc, int derived) {
        PhaseEvent pe = PhaseEvent.create(pathname, desc);
        pe.deriveMetric(derived);
        return pe;
    }

    @Deprecated
    public PhaseEvent(Noun parent, String name, String desc) {
        this(true, parent, name, desc);
    }

    @Deprecated
    private PhaseEvent(boolean sanitizeName, Noun parent, String name, String desc) {
        super(sanitizeName, parent, name, desc);
        this.setUpdateTime(0L);
        this._isBucketed = Bucket.isBucketed(this);
        if (_clock == null) {
            _clock = DMSConsole.getClock();
        }
        this._metrics[0] = Metric.create(this._name + ".time", this._description, ClockManager.getUnits(DMSConsole.UNITS), this, false, (byte)2, (byte)0);
        this._derivedMetricsFlags = 1;
    }

    public int getDerivedMetrics() {
        return this._derivedMetricsFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deriveMetric(int metric) {
        boolean derived = false;
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            if (!this._alive) {
                return;
            }
            String units = ClockManager.getUnits(DMSConsole.UNITS);
            if ((metric & 2) > 0 && this._metrics[1] == null) {
                this._metrics[1] = Metric.create(this._name + ".completed", this._description, "ops", this, false, (byte)3, (byte)1);
                this._derivedMetricsFlags |= 2;
                derived = true;
            }
            if ((metric & 8) > 0 && this._metrics[3] == null) {
                this._metrics[3] = Metric.create(this._name + ".maxTime", this._description, units, this, false, (byte)2, (byte)3);
                this._derivedMetricsFlags |= 8;
                derived = true;
            }
            if ((metric & 4) > 0 && this._metrics[2] == null) {
                this._metrics[2] = Metric.create(this._name + ".minTime", this._description, units, this, false, (byte)2, (byte)2);
                this._derivedMetricsFlags |= 4;
                derived = true;
            }
            if ((metric & 0x20) > 0 && this._metrics[5] == null) {
                this._metrics[5] = Metric.create(this._name + ".avg", this._description, units, this, false, (byte)1, (byte)5);
                this._derivedMetricsFlags |= 0x20;
                derived = true;
            }
            if ((metric & 0x40) > 0 && this._metrics[6] == null) {
                this._metrics[6] = Metric.create(this._name + ".active", this._description, "threads", this, false, (byte)3, (byte)6);
                this._derivedMetricsFlags |= 0x40;
                derived = true;
            }
            if ((metric & 0x80) > 0 && this._metrics[7] == null) {
                this._metrics[7] = Metric.create(this._name + ".maxActive", this._description, "threads", this, false, (byte)3, (byte)7);
                this._derivedMetricsFlags |= 0x80;
                derived = true;
            }
            if (derived) {
                this.setUpdateTime();
            }
        }
        if (derived) {
            this.setUpdateTime();
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.METRIC_SELECTION_CHANGED)) {
                eMgr.reportEvent(this, EventSourceType.PHASE_SENSOR, EventActionType.METRIC_SELECTION_CHANGED, this._lastUpdate, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Metric m) {
        if (m == null) {
            throw new InstrumentationException("DMS-50750");
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return this._updateCount;
                }
                case 2: {
                    if (this._min == Long.MAX_VALUE) {
                        return 0L;
                    }
                    return _clock.convertTime(this._min, DMSConsole.UNITS);
                }
                case 3: {
                    if (this._max == Long.MIN_VALUE) {
                        return 0L;
                    }
                    return _clock.convertTime(this._max, DMSConsole.UNITS);
                }
                case 0: {
                    return _clock.convertTime(this._duration, DMSConsole.UNITS);
                }
                case 5: {
                    long duration = _clock.convertTime(this._duration, DMSConsole.UNITS);
                    return this._updateCount != 0 && duration != 0L ? (double)duration / (double)this._updateCount : 0.0;
                }
                case 6: {
                    return this._active;
                }
                case 7: {
                    return this._maxActive;
                }
                case 8: {
                    this._exclTime = this._duration;
                    return this._exclTime;
                }
            }
        }
        throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
    }

    public static PhaseEventActivationToken startAnonymousPhase(String nounType, String startOfExpectedSensorsPath, String sensorName, ActivationParameter ... activationParameters) {
        if (nounType == null) {
            throw new IllegalArgumentException("Can not start an anonymous phase without specifying the nounType of the noun to which the phase is expected to belong.");
        }
        long startToken = _clock.getTime();
        PhaseEventActivationToken retVal = new PhaseEventActivationToken(startToken, activationParameters, startOfExpectedSensorsPath, nounType);
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            boolean sendEvent = false;
            NounDescriptor nounDescriptor = Noun.getDescriptorByType(nounType);
            if (nounDescriptor == null) {
                DMSConsole.s_logger.log(Level.WARNING, "Anonymous phase started with unknown noun type.");
            } else {
                sendEvent = nounDescriptor.getEventable(EventActionType.START);
            }
            if (sendEvent) {
                long updateTime = _clock.adjustTime(startToken);
                Object[] subsidiaryObjects = null;
                subsidiaryObjects = activationParameters != null && activationParameters.length > 0 ? new Object[]{startToken, nounType, startOfExpectedSensorsPath, activationParameters} : new Object[]{startToken, nounType, startOfExpectedSensorsPath};
                eMgr.reportEvent(null, EventSourceType.ANONYMOUS_PHASE_SENSOR, EventActionType.START, updateTime, null, subsidiaryObjects);
            }
        }
        return retVal;
    }

    public static void abortAnonymousPhase(PhaseEventActivationToken activationToken) {
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            boolean sendEvent = false;
            NounDescriptor nounDescriptor = Noun.getDescriptorByType(activationToken.getAnonymousNounType());
            if (nounDescriptor == null) {
                sendEvent = true;
                DMSConsole.s_logger.log(Level.WARNING, "DMS-50762");
            } else {
                sendEvent = nounDescriptor.getEventable(EventActionType.START);
            }
            if (sendEvent) {
                long updateTime = Time.currentTimeMillis();
                Object[] subsidiaryObjects = null;
                subsidiaryObjects = activationToken.getActivationParameters() != null && activationToken.getActivationParameters().length > 0 ? new Object[]{activationToken.getStartTimeToken(), activationToken.getAnonymousNounType(), activationToken.getAnonymousStartOfPath(), activationToken.getActivationParameters()} : new Object[]{activationToken.getStartTimeToken(), activationToken.getAnonymousNounType(), activationToken.getAnonymousStartOfPath()};
                eMgr.reportEvent(null, EventSourceType.ANONYMOUS_PHASE_SENSOR, EventActionType.ABORT, updateTime, null, subsidiaryObjects);
            }
        }
    }

    @Override
    public long start() {
        if (!this._alive) {
            return Long.MIN_VALUE;
        }
        long timeAndToken = _clock.getTime();
        long updateTime = _clock.adjustTime(timeAndToken);
        if (updateTime == 0L) {
            updateTime = Time.currentTimeMillis();
        }
        this.startPrivate(updateTime, timeAndToken, false, null);
        return timeAndToken;
    }

    public PhaseEventActivationToken start(ActivationParameter ... activationParameters) {
        PhaseEventActivationToken retVal = null;
        if (!this._alive) {
            retVal = new PhaseEventActivationToken(Long.MIN_VALUE, -3, activationParameters);
        } else {
            long time;
            long updateTime;
            if (this.isLoggable()) {
                this.logActivation("Start");
            }
            if ((updateTime = _clock.adjustTime(time = _clock.getTime())) == 0L) {
                updateTime = Time.currentTimeMillis();
            }
            int activationUID = this.startPrivate(updateTime, time, true, activationParameters);
            retVal = new PhaseEventActivationToken(time, activationUID, activationParameters);
        }
        return retVal;
    }

    public static long start(String pathname) {
        Sensor s = Sensor.get(pathname);
        if (s == null) {
            throw new IllegalArgumentException("Can not start sensor '" + pathname + "', it does not exist.");
        }
        if (!(s instanceof PhaseEvent)) {
            throw new IllegalArgumentException("Can not start sensor '" + pathname + "', it is not a PhaseEvent sensor.");
        }
        PhaseEvent pe = (PhaseEvent)s;
        long retVal = pe.start();
        return retVal;
    }

    @Override
    public void start(long startToken) {
        if (!this._alive || startToken == Long.MIN_VALUE) {
            return;
        }
        long updateTime = Time.currentTimeMillis();
        this.startPrivate(updateTime, startToken, false, null);
    }

    public static void stop(String name, long token) {
        if (token == Long.MIN_VALUE) {
            return;
        }
        Sensor s = Sensor.get(name);
        if (s == null) {
            throw new IllegalArgumentException("Can not stop sensor '" + name + "', it does not exist.");
        }
        if (!(s instanceof PhaseEvent)) {
            throw new IllegalArgumentException("Can not stop sensor '" + name + "', it is not a PhaseEvent sensor.");
        }
        PhaseEvent pe = (PhaseEvent)s;
        pe.stopPrivate(token, -3, null, false);
    }

    @Override
    public void stop(long token) {
        this.stopPrivate(token, -3, null, false);
    }

    public void stop(PhaseEventActivationToken activationToken) {
        if (activationToken == null) {
            throw new IllegalArgumentException("Can not stop a phase with a null activationToken");
        }
        if (activationToken.isAnonymous() && !activationToken.sensorMatchesAnonymousStart(this)) {
            throw new IllegalArgumentException("Can not stop a phase using an anonymous activationToken that was created by starting a phase belonging to a different noun-type or an non-matching noun-path.");
        }
        this.stopPrivate(activationToken.getStartTimeToken(), activationToken.getActivationUID(), activationToken.getActivationParameters(), activationToken.isAnonymous());
    }

    @Override
    public long stop2(long token) {
        return this.stopPrivate(token, -3, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startPrivate(long updateTime, long startToken, boolean useActivationUID, ActivationParameter[] activationParameters) {
        int activationUID = -3;
        if (this.isLoggable()) {
            this.logActivation("Start");
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            ++this._active;
            if (this._active > this._maxActive) {
                this._maxActive = this._active;
            }
            if (this._lastUpdate < updateTime) {
                this._lastUpdate = updateTime;
            }
            if (useActivationUID) {
                activationUID = this._active + this._updateCount;
            }
        }
        if (this._refresh == null) {
            ParamScopedMetricsRuntimeManager psmrm;
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null) {
                Object activationUIDStr = null;
                activationUIDStr = activationUID == -3 ? UNKNOWN_ACTIVATION_UID_STRING : Integer.valueOf(activationUID);
                if (this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.START)) {
                    Object[] subsidiaryObjects = null;
                    subsidiaryObjects = activationParameters != null && activationParameters.length > 0 ? new Object[]{startToken, activationUIDStr, activationParameters} : new Object[]{startToken, activationUIDStr};
                    eMgr.reportEvent(this, EventSourceType.PHASE_SENSOR, EventActionType.START, updateTime, null, subsidiaryObjects);
                }
            }
            if ((psmrm = ParamScopedMetricsSystem.getRuntimeManager()) != null) {
                psmrm.handlePhaseSensorStart(this, updateTime, activationParameters);
            }
        }
        return activationUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long stopPrivate(long startToken, int activationUID, ActivationParameter[] activationParameters, boolean wasStartedAnonymously) {
        int updateCount;
        long duration;
        if (!this._alive || startToken == Long.MIN_VALUE) {
            return -1L;
        }
        long stopToken = _clock.getTime();
        long thisDuration = stopToken - startToken;
        long updateTime = _clock.adjustTime(stopToken);
        if (updateTime == 0L) {
            updateTime = Time.currentTimeMillis();
        }
        if (thisDuration < 0L) {
            thisDuration = 0L;
            stopToken = startToken;
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration += thisDuration;
            duration = this._duration;
            if (this._max < thisDuration) {
                this._max = thisDuration;
            }
            if (this._min > thisDuration) {
                this._min = thisDuration;
            }
            if (!wasStartedAnonymously) {
                --this._active;
            }
            ++this._updateCount;
            updateCount = this._updateCount;
            if (this._lastUpdate < updateTime) {
                this._lastUpdate = updateTime;
            }
        }
        if (this._refresh == null) {
            ParamScopedMetricsRuntimeManager psmrm;
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null) {
                String activationUIDStr = null;
                activationUIDStr = wasStartedAnonymously ? ANONYMOUS_ACTIVATION_UID_STRING : (activationUID == -3 ? UNKNOWN_ACTIVATION_UID_STRING : Integer.toString(activationUID));
                if (this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.STOP)) {
                    Object[] subsidiaryObjects = null;
                    subsidiaryObjects = activationParameters != null && activationParameters.length > 0 ? new Object[]{startToken, stopToken, activationUIDStr, activationParameters} : new Object[]{startToken, stopToken, activationUIDStr};
                    eMgr.reportEvent(this, EventSourceType.PHASE_SENSOR, EventActionType.STOP, updateTime, null, subsidiaryObjects);
                }
            }
            if ((psmrm = ParamScopedMetricsSystem.getRuntimeManager()) != null) {
                psmrm.handlePhaseSensorStop(this, wasStartedAnonymously, updateTime, thisDuration, activationParameters);
            }
        }
        if (this.isLoggable()) {
            StringBuffer sb = new StringBuffer("Stop: [");
            sb.append(startToken);
            sb.append(", ");
            sb.append(stopToken);
            sb.append(", ");
            sb.append(updateCount);
            sb.append(" ops, ");
            sb.append(duration);
            sb.append(" " + _clock.getUnits() + "]");
            this.logActivation(sb.toString());
        }
        if (this._isBucketed) {
            Bucket.drop((Sensor)this, thisDuration, updateTime);
        }
        return stopToken;
    }

    public long stopElapsed(long token) {
        if (!this._alive || token == Long.MIN_VALUE) {
            return -1L;
        }
        long tokenStop = this.stopPrivate(token, -3, null, false);
        long retVal = tokenStop == -1L ? -2L : tokenStop - token;
        return retVal;
    }

    public static void stop(String pathname, long startToken, long stopToken) {
        if (startToken == Long.MIN_VALUE || stopToken == -1L) {
            return;
        }
        Sensor s = Sensor.get(pathname);
        if (s == null) {
            throw new IllegalArgumentException("Can not stop sensor '" + pathname + "', it does not exist.");
        }
        if (!(s instanceof PhaseEvent)) {
            throw new IllegalArgumentException("Can not stop sensor '" + pathname + "', it is not a PhaseEvent sensor.");
        }
        PhaseEvent pe = (PhaseEvent)s;
        pe.stop(startToken, stopToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long startToken, long stopToken) {
        EventReportingManager eMgr;
        int updateCount;
        long duration;
        if (!this._alive || startToken == Long.MIN_VALUE || stopToken == -1L) {
            return;
        }
        long thisDuration = stopToken - startToken;
        if (thisDuration < 0L) {
            thisDuration = 0L;
        }
        long updateTime = Time.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration += thisDuration;
            duration = this._duration;
            if (this._max < thisDuration) {
                this._max = thisDuration;
            }
            if (this._min > thisDuration) {
                this._min = thisDuration;
            }
            --this._active;
            ++this._updateCount;
            updateCount = this._updateCount;
            if (this._lastUpdate < updateTime) {
                this._lastUpdate = updateTime;
            }
        }
        if (this._refresh == null && (eMgr = EventSystem.getEventReportingManager()) != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.STOP)) {
            eMgr.reportEvent(this, EventSourceType.PHASE_SENSOR, EventActionType.STOP, updateTime, null, new Object[]{Long.valueOf(startToken) + "-?", stopToken});
        }
        if (this.isLoggable()) {
            StringBuffer sb = new StringBuffer("Stop: [");
            sb.append(startToken);
            sb.append(", ");
            sb.append(stopToken);
            sb.append(", ");
            sb.append(updateCount);
            sb.append(" ops, ");
            sb.append(duration);
            sb.append(" msecs]");
            this.logActivation(sb.toString());
        }
        if (this._isBucketed) {
            Bucket.drop((Sensor)this, thisDuration, updateTime);
        }
    }

    public static void abort(String name, long token) {
        if (token == Long.MIN_VALUE) {
            return;
        }
        Sensor s = Sensor.get(name);
        if (s == null) {
            throw new IllegalArgumentException("Can not abort sensor '" + name + "', it does not exist.");
        }
        if (!(s instanceof PhaseEvent)) {
            throw new IllegalArgumentException("Can not abort sensor '" + name + "', it is not a PhaseEvent sensor.");
        }
        PhaseEvent pe = (PhaseEvent)s;
        pe.abortPrivate(token, -3, null);
    }

    public void abort(PhaseEventActivationToken activationToken) {
        if (activationToken == null) {
            throw new IllegalArgumentException("Can not abort a phase with a null activationToken.");
        }
        this.abortPrivate(activationToken.getStartTimeToken(), activationToken.getActivationUID(), activationToken.getActivationParameters());
    }

    @Override
    public void abort(long token) {
        this.abortPrivate(token, -3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortPrivate(long startToken, int activationUID, ActivationParameter[] activationParameters) {
        EventReportingManager eMgr;
        if (!this._alive || startToken == Long.MIN_VALUE) {
            return;
        }
        long timeStamp = Time.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            --this._active;
            this.setUpdateTime(timeStamp);
        }
        if (this._refresh == null && (eMgr = EventSystem.getEventReportingManager()) != null) {
            String activationUIDStr = null;
            activationUIDStr = activationUID == -3 ? UNKNOWN_ACTIVATION_UID_STRING : Integer.toString(activationUID);
            if (this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.ABORT)) {
                Object[] subsidiaryObjects = null;
                subsidiaryObjects = activationParameters != null && activationParameters.length > 0 ? new Object[]{startToken, activationUIDStr, activationParameters} : new Object[]{startToken, activationUIDStr};
                eMgr.reportEvent(this, EventSourceType.PHASE_SENSOR, EventActionType.ABORT, timeStamp, null, subsidiaryObjects);
            }
        }
        if (this.isLoggable()) {
            this.logActivation("Abort");
        }
    }

    public static long getToken() {
        if (_clock == null) {
            return Long.MIN_VALUE;
        }
        return _clock.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this._alive) {
            return;
        }
        long timeStamp = Time.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration = 0L;
            this._updateCount = 0;
            this._min = Long.MAX_VALUE;
            this._max = Long.MIN_VALUE;
            this._maxActive = this._active;
            this.setUpdateTime(timeStamp);
            this.setResetTime(timeStamp);
        }
    }

    public PhaseEvent getCousin(Noun pre) {
        if (!this._alive) {
            return null;
        }
        PhaseEvent retval = null;
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = PhaseEvent.create(cousinNoun, this._name, "cousin");
            int derivedBits = 0;
            derivedBits |= 1;
            derivedBits |= 2;
            if (this._metrics[3] != null) {
                derivedBits |= 8;
            }
            if (this._metrics[2] != null) {
                derivedBits |= 4;
            }
            if (this._metrics[8] != null) {
                derivedBits |= 0x100;
            }
            retval.deriveMetric(derivedBits);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExclTime(long time) {
        long timeStamp = Time.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._exclTime += time;
            this.setUpdateTime(timeStamp);
        }
    }

    @Override
    EventSourceType getSourceType() {
        return EventSourceType.PHASE_SENSOR;
    }

    @Override
    public ActivationParameter[] getActivationParametersFromEvent(Event event) {
        ActivationParameter[] retVal = null;
        if (event != null) {
            if (event.getActionType() == EventActionType.START || event.getActionType() == EventActionType.ABORT) {
                retVal = (ActivationParameter[])event.getSubsidiaryObject(2);
            } else if (event.getActionType() == EventActionType.STOP) {
                retVal = (ActivationParameter[])event.getSubsidiaryObject(3);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            if (this._updateCount > 0 || this._active > 0) {
                return true;
            }
        }
        return false;
    }

    static synchronized void shutdown() {
        if (DMSConsole.s_logger.isLoggable(Level.FINE)) {
            DMSConsole.s_logger.log(Level.FINE, "Phase Event class is being shutdown {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
    }

    static synchronized void init(Clock clock) {
        _clock = clock;
    }
}

