/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogFloodController {
    private Logger mLogger;
    private Map<PolicyMapKey, PolicyMapValue> mPolicyMap = new ConcurrentHashMap<PolicyMapKey, PolicyMapValue>();

    public LogFloodController(Logger logger) {
        this.mLogger = logger;
    }

    public void addSimpleDecimationPolicy(String sourceClass, String sourceMethod, String msgKey, int decimationFactor) {
        PolicyMapKey pmk = new PolicyMapKey(sourceClass, sourceMethod, msgKey);
        SimpleDecimatorValue pmv = new SimpleDecimatorValue(decimationFactor);
        this.mPolicyMap.put(pmk, pmv);
    }

    public void addMaxMsgsTimeWindowPolicy(String sourceClass, String sourceMethod, String msgKey, long timeWIndowInMillis, int messagesPerWindow) {
        PolicyMapKey pmk = new PolicyMapKey(sourceClass, sourceMethod, msgKey);
        TimeControlledValue pmv = new TimeControlledValue(timeWIndowInMillis, messagesPerWindow);
        this.mPolicyMap.put(pmk, pmv);
    }

    public void log(LogRecord lr) {
        PolicyMapKey pmk = new PolicyMapKey(lr.getSourceClassName(), lr.getSourceMethodName(), lr.getMessage());
        PolicyMapValue pmv = this.mPolicyMap.get(pmk);
        if (pmv == null) {
            this.mLogger.log(lr);
        } else if (!pmv.isFloodControlled(lr.getMillis())) {
            this.mLogger.log(lr);
        }
    }

    private static class TimeControlledValue
    implements PolicyMapValue {
        AtomicLong mLastDisabledTime = new AtomicLong();
        AtomicLong mLastPermittedTime = new AtomicLong();
        AtomicInteger mMsgLogdInWinCnt = new AtomicInteger();
        final long mTimeWindowInMillis;
        final int mNumMessagesPerWindow;

        private TimeControlledValue(long timeWindowInMillis, int numMessagesPerWindow) {
            this.mTimeWindowInMillis = timeWindowInMillis;
            this.mNumMessagesPerWindow = numMessagesPerWindow;
        }

        @Override
        public boolean isFloodControlled(long eventTimeMillis) {
            boolean retVal = true;
            long timeNow = eventTimeMillis;
            if (timeNow <= 0L) {
                timeNow = System.currentTimeMillis();
            }
            if (timeNow > this.mLastPermittedTime.get() + this.mTimeWindowInMillis) {
                retVal = false;
            } else if (timeNow > this.mLastDisabledTime.get() + this.mTimeWindowInMillis) {
                int msgLogdInWinCnt = this.mMsgLogdInWinCnt.incrementAndGet();
                if (msgLogdInWinCnt < this.mNumMessagesPerWindow) {
                    retVal = false;
                } else {
                    this.mMsgLogdInWinCnt.set(0);
                    this.mLastDisabledTime.set(timeNow);
                }
            }
            if (!retVal) {
                this.mLastPermittedTime.set(timeNow);
            }
            return retVal;
        }
    }

    private static class SimpleDecimatorValue
    implements PolicyMapValue {
        AtomicInteger mMessageLoggedCount = new AtomicInteger();
        final int mDecimationFactor;

        private SimpleDecimatorValue(int decimationFactor) {
            this.mDecimationFactor = decimationFactor;
        }

        @Override
        public boolean isFloodControlled(long eventTimeMillis) {
            boolean retVal = true;
            int oldValue = this.mMessageLoggedCount.incrementAndGet();
            if (oldValue >= this.mDecimationFactor) {
                this.mMessageLoggedCount.set(0);
                retVal = false;
            }
            return retVal;
        }
    }

    private static interface PolicyMapValue {
        public boolean isFloodControlled(long var1);
    }

    private static class PolicyMapKey {
        final String mSourceClass;
        final String mSourceMethod;
        final String mMessageKey;
        int mHashCode;

        private PolicyMapKey(String sourceClass, String sourceMethod, String msgKey) {
            this.mSourceClass = sourceClass;
            this.mSourceMethod = sourceMethod;
            this.mMessageKey = msgKey;
            this.mHashCode = (sourceClass == null ? 0 : sourceClass.hashCode()) | (sourceMethod == null ? 0 : sourceMethod.hashCode()) | (msgKey == null ? 0 : msgKey.hashCode());
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o != null && o instanceof PolicyMapKey) {
                PolicyMapKey that = (PolicyMapKey)o;
                retVal = (this.mSourceClass == null ? that.mSourceClass == null : this.mSourceClass.equals(that.mSourceClass)) && (this.mSourceMethod == null ? that.mSourceMethod == null : this.mSourceMethod.equals(that.mSourceMethod)) && (this.mMessageKey == null ? that.mMessageKey == null : this.mMessageKey.equals(that.mMessageKey));
            }
            return retVal;
        }
    }
}

