/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventFactory;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventType;
import oracle.dms.event.Filter;
import oracle.dms.event.RequiresEventsOnInitialization;
import oracle.dms.event.RequiresReinitializationOnFilterChange;
import oracle.dms.event.config.EventConfig;
import oracle.dms.event.impl.EventFactoryImpl;
import oracle.dms.event.impl.EventImpl;
import oracle.dms.instrument.InstrumentationNodeWalker;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.util.Identifiable;
import oracle.dms.util.JSONUtils;

public class EventManagerImpl
implements EventConfigManager,
EventReportingManager {
    private static final String CLASS_NAME = EventManagerImpl.class.getName();
    private static String LOGGER_NAME = "oracle.dms.event";
    private AssociationsTable mAssociationsTable = new AssociationsTable();
    private EventFactoryImpl mEventFactory = new EventFactoryImpl(this);
    private Map<String, EventConfigManager.DestinationConfigRuntimePair> mActiveDestinationMapX = new ConcurrentHashMap<String, EventConfigManager.DestinationConfigRuntimePair>();
    private Map<String, EventConfigManager.FilterConfigRuntimePair> mActiveFilterMapX = new ConcurrentHashMap<String, EventConfigManager.FilterConfigRuntimePair>();
    private long mUpdateCount = 0L;
    private ODLLogger mLogger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());

    @Override
    public EventFactory getEventFactory() {
        return this.mEventFactory;
    }

    @Override
    public void reportEvent(Object source, EventSourceType sourceType, EventActionType actionType, long timeOfEvent, ExecutionContext ctx, Object[] subsidiaryObjects) {
        int actionTypeIndex;
        int sourceTypeIndex = sourceType.ordinal();
        List<DestinationFiltersEntry> dfeList = this.mAssociationsTable.mCells[sourceTypeIndex][actionTypeIndex = actionType.ordinal()];
        if (dfeList != null && !dfeList.isEmpty()) {
            Event event = this.mEventFactory.createEvent(source, sourceType, actionType, timeOfEvent, ctx, subsidiaryObjects);
            this.reportEventToDestinations(event, dfeList);
        }
    }

    @Override
    public void reportEvent(Event event) {
        int actionTypeIndex;
        int sourceTypeIndex;
        List<DestinationFiltersEntry> dfeList;
        if (event != null && (dfeList = this.mAssociationsTable.mCells[sourceTypeIndex = event.getSourceType().ordinal()][actionTypeIndex = event.getActionType().ordinal()]) != null && !dfeList.isEmpty()) {
            this.reportEventToDestinations(event, dfeList);
        }
    }

    private void reportEventToDestinations(Event event, List<DestinationFiltersEntry> dfeList) {
        String METHOD_NAME = "reportEventToDestinations";
        boolean eventKnownToHaveContext = false;
        for (DestinationFiltersEntry dfe : dfeList) {
            boolean passFilters = false;
            for (int filterIndex = 0; filterIndex < dfe.mFilterCount && !passFilters; ++filterIndex) {
                try {
                    if (!eventKnownToHaveContext && dfe.mFilters[filterIndex].needsContext()) {
                        if (event.getExecutionContext() == null) {
                            event.setExecutionContext(DMSContextManager.getActiveContext());
                        }
                        eventKnownToHaveContext = true;
                    }
                    passFilters = dfe.mFilters[filterIndex].applyFilter(event);
                    continue;
                }
                catch (Throwable t) {
                    LogRecord lr = new LogRecord(Level.WARNING, "DMS-58027");
                    lr.setResourceBundle(this.mLogger.getResourceBundle());
                    lr.setSourceClassName(CLASS_NAME);
                    lr.setSourceMethodName("reportEventToDestinations");
                    lr.setParameters(new Object[]{(Object)((Object)event.getSourceType()) + ":" + (Object)((Object)event.getActionType()), "filterId:" + dfe.mFilters[filterIndex].getId()});
                    lr.setThrown(t);
                    this.mLogger.log(lr);
                }
            }
            if (!passFilters) continue;
            try {
                if (!eventKnownToHaveContext && dfe.mDestination.needsContext()) {
                    event.setExecutionContext(DMSContextManager.getActiveContext());
                    eventKnownToHaveContext = true;
                }
                dfe.mDestination.handleEvent(event);
            }
            catch (Throwable t) {
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58027");
                lr.setResourceBundle(this.mLogger.getResourceBundle());
                lr.setSourceClassName(CLASS_NAME);
                lr.setSourceMethodName("reportEventToDestinations");
                lr.setParameters(new Object[]{(Object)((Object)event.getSourceType()) + ":" + (Object)((Object)event.getActionType()), "destinationId:" + dfe.mDestination.getId()});
                lr.setThrown(t);
                this.mLogger.log(lr);
            }
        }
    }

    @Override
    public synchronized boolean associateInternalFilterWithDestination(Filter inFilter, Destination inDestination) {
        boolean retVal = this.associateFilterWithDestination(new EventConfigManager.FilterConfigRuntimePair(null, inFilter), new EventConfigManager.DestinationConfigRuntimePair(null, inDestination));
        return retVal;
    }

    @Override
    public synchronized boolean associateFilterWithDestination(EventConfigManager.FilterConfigRuntimePair inFilterX, EventConfigManager.DestinationConfigRuntimePair inDestinationX) {
        String METHOD_NAME = "associateFilterWithDestination";
        boolean retVal = false;
        if (inDestinationX == null || inFilterX == null || inDestinationX.getId() == null || inFilterX.getId() == null) {
            this.mLogger.logp(Level.WARNING, CLASS_NAME, "associateFilterWithDestination", "DMS-58028", new Object[]{inFilterX, inDestinationX});
            throw new IllegalArgumentException("Can not associate filter and destination if one or both are null or have null IDs: filter = " + inFilterX + ", destination = " + inDestinationX);
        }
        if (inFilterX.getRuntimeFilter().getEventTypesOfInterest() == null || inFilterX.getRuntimeFilter().getEventTypesOfInterest().length == 0) {
            this.mLogger.logp(Level.WARNING, CLASS_NAME, "associateFilterWithDestination", "DMS-58033", new Object[]{inFilterX, inDestinationX});
            throw new IllegalArgumentException("Can not associate filter and destination if the filter is not interested in any event types: filter = " + inFilterX + ", destination = " + inDestinationX);
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "Called to associate filter: " + inFilterX.getId() + " with destination:" + inDestinationX.getId());
        }
        EventConfigManager.FilterConfigRuntimePair incumbantFilterX = this.mActiveFilterMapX.get(inFilterX.getId());
        EventConfigManager.DestinationConfigRuntimePair incumbantDestinationX = this.mActiveDestinationMapX.get(inDestinationX.getId());
        if (incumbantFilterX == null && incumbantDestinationX == null) {
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "EventManagerImpl has no current knowledge of filter: " + inFilterX.getId() + " or destination:" + inDestinationX.getId());
            }
            try {
                HashSet<Filter> filters = new HashSet<Filter>(1);
                filters.add(inFilterX.getRuntimeFilter());
                EventManagerImpl.initializeDestination(inDestinationX.getRuntimeDestination(), filters);
                this.mActiveDestinationMapX.put(inDestinationX.getId(), inDestinationX);
                this.mActiveFilterMapX.put(inFilterX.getId(), inFilterX);
                this.updateAssociations(inFilterX.getRuntimeFilter(), inDestinationX.getRuntimeDestination());
                retVal = true;
            }
            catch (Exception e) {
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58043");
                lr.setResourceBundle(this.mLogger.getResourceBundle());
                lr.setSourceClassName(CLASS_NAME);
                lr.setSourceMethodName("associateFilterWithDestination");
                lr.setParameters(new Object[]{inDestinationX.getId(), inFilterX.getId()});
                lr.setThrown(e);
                this.mLogger.log(lr);
            }
        } else if (incumbantFilterX != null && incumbantDestinationX == null) {
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "EventManagerImpl has knowledge of filter: " + inFilterX.getId() + " but not of destination:" + inDestinationX.getId());
            }
            try {
                HashSet<Filter> filters = new HashSet<Filter>(1);
                filters.add(inFilterX.getRuntimeFilter());
                EventManagerImpl.initializeDestination(inDestinationX.getRuntimeDestination(), filters);
                this.replaceFilter(inFilterX);
                this.mActiveDestinationMapX.put(inDestinationX.getId(), inDestinationX);
                this.updateAssociations(inFilterX.getRuntimeFilter(), inDestinationX.getRuntimeDestination());
                retVal = true;
            }
            catch (Exception e) {
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58043");
                lr.setResourceBundle(this.mLogger.getResourceBundle());
                lr.setSourceClassName(CLASS_NAME);
                lr.setSourceMethodName("associateFilterWithDestination");
                lr.setParameters(new Object[]{inDestinationX.getId(), inFilterX.getId()});
                lr.setThrown(e);
                this.mLogger.log(lr);
            }
        } else if (incumbantFilterX == null && incumbantDestinationX != null) {
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "EventManagerImpl has no current knowledge of filter: " + inFilterX.getId() + " but has knowledge of destination:" + inDestinationX.getId());
            }
            if (incumbantDestinationX.getRuntimeDestination().equals(inDestinationX.getRuntimeDestination())) {
                if (incumbantDestinationX.getRuntimeDestination().getClass().isAnnotationPresent(RequiresReinitializationOnFilterChange.class)) {
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "In order to complete the association of filter: " + inFilterX.getId() + " destination:" + inDestinationX.getId() + " needs to be re-initialized.");
                    }
                    retVal = this.reInitializeDestinationWithAdditionalFilter(incumbantDestinationX.getId(), inFilterX);
                } else {
                    this.mActiveFilterMapX.put(inFilterX.getId(), inFilterX);
                    this.updateAssociations(inFilterX.getRuntimeFilter(), incumbantDestinationX.getRuntimeDestination());
                    retVal = true;
                }
            } else {
                retVal = this.replaceDestinationSpecial(inDestinationX, inFilterX);
            }
        } else if (incumbantFilterX != null && incumbantDestinationX != null) {
            boolean filterNeedsReplacing = !incumbantFilterX.getRuntimeFilter().equals(inFilterX.getRuntimeFilter());
            boolean destinationNeedsReplacing = !incumbantDestinationX.getRuntimeDestination().equals(inDestinationX.getRuntimeDestination());
            boolean associationAlreadyExists = this.hasFilterDestinationAssociation(incumbantFilterX.getRuntimeFilter(), incumbantDestinationX.getRuntimeDestination());
            if (associationAlreadyExists) {
                if (destinationNeedsReplacing) {
                    if (filterNeedsReplacing) {
                        if (inDestinationX.getRuntimeDestination().getClass().isAnnotationPresent(RequiresReinitializationOnFilterChange.class)) {
                            if (this.mLogger.isLoggable(Level.FINE)) {
                                this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An existing association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being updated - both filter and destination are being replaced " + "(the new destination needs to be initialized using the new filter).");
                            }
                            retVal = this.replaceFilterAndDestinationRequiringEventsOnFilterChange(incumbantFilterX, inFilterX, incumbantDestinationX, inDestinationX);
                        } else {
                            if (this.mLogger.isLoggable(Level.FINE)) {
                                this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An existing association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being updated - both filter and destination are being replaced." + "(the new destination does not need initialization using the new filter).");
                            }
                            this.replaceDestination(inDestinationX);
                            this.replaceFilter(inFilterX);
                            retVal = true;
                        }
                    } else {
                        if (this.mLogger.isLoggable(Level.FINE)) {
                            this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An existing association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being updated - but only the destination needs to be replaced.");
                        }
                        this.replaceDestination(inDestinationX);
                        retVal = true;
                    }
                } else if (filterNeedsReplacing) {
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An existing association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being updated - but only the filter needs to be replaced.");
                    }
                    this.replaceFilter(inFilterX);
                    retVal = true;
                } else {
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An existing association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " was to be updated - but it transpires that neither" + " destination nor filter need to be updated.");
                    }
                    retVal = false;
                }
            } else {
                String filterMessage = null;
                EventConfigManager.FilterConfigRuntimePair filterToUseX = null;
                if (filterNeedsReplacing) {
                    filterMessage = "The new filter will replace the incumbant fiter.";
                    this.replaceFilter(inFilterX);
                    filterToUseX = inFilterX;
                } else {
                    filterMessage = "The new filter is no different from the incumbant fiter.";
                    filterToUseX = incumbantFilterX;
                }
                if (destinationNeedsReplacing) {
                    this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An new association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being created and involves the replacement of an incumbant destination." + filterMessage);
                    retVal = this.replaceDestinationSpecial(inDestinationX, filterToUseX);
                } else if (incumbantDestinationX.getRuntimeDestination().getClass().isAnnotationPresent(RequiresReinitializationOnFilterChange.class)) {
                    this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An new association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being created. The incumbant destination does not need replacing but it does require re-initialization." + filterMessage);
                    retVal = this.reInitializeDestinationWithAdditionalFilter(incumbantDestinationX.getId(), filterToUseX);
                } else {
                    this.mLogger.logp(Level.FINE, CLASS_NAME, "associateFilterWithDestination", "An new association between filter : " + inFilterX.getId() + " and destination:" + inDestinationX.getId() + " is being created. The incumbant destination does not need replacing. " + filterMessage);
                    this.updateAssociations(filterToUseX.getRuntimeFilter(), incumbantDestinationX.getRuntimeDestination());
                    retVal = true;
                }
            }
        }
        if (retVal) {
            this.updateOtherSystems();
        }
        return retVal;
    }

    @Override
    public synchronized void disassociateFilterAndDestination(String filterId, String destinationId) {
        String METHOD_NAME = "disassociateFilterAndDestination";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "disassociateFilterAndDestination", "Called to disassociate filter " + filterId + " and destination " + destinationId + ".");
        }
        if (destinationId != null || filterId != null) {
            Set<FilterDestinationPair> removedPairs = this.mAssociationsTable.findFilterDestinationPairsById(filterId, destinationId, true);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "disassociateFilterAndDestination", "Removed " + removedPairs.size() + " filter destination pairs for the pair (" + filterId + ", " + destinationId + ").");
            }
            if (removedPairs.size() > 0) {
                if (destinationId != null) {
                    this.clearDestinationIfUnused(destinationId);
                }
                if (filterId != null) {
                    this.clearFilterIfUnused(filterId);
                }
                this.updateOtherSystems();
            }
        } else {
            this.mLogger.logp(Level.WARNING, CLASS_NAME, "disassociateFilterAndDestination", "DMS-58030", new Object[]{filterId, destinationId});
        }
    }

    private void clearDestinationIfUnused(String destinationId) {
        String METHOD_NAME = "clearDestinationIfUnused";
        Set<FilterDestinationPair> remainingPairsForThisDestination = this.mAssociationsTable.findFilterDestinationPairsById(null, destinationId, false);
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "clearDestinationIfUnused", "Found " + remainingPairsForThisDestination.size() + " pairs for destination " + destinationId + ".");
        }
        if (remainingPairsForThisDestination.size() == 0) {
            EventConfigManager.DestinationConfigRuntimePair oldDestinationX = this.mActiveDestinationMapX.remove(destinationId);
            this.mLogger.logp(Level.FINE, CLASS_NAME, "clearDestinationIfUnused", "Calling shutdown on destination " + oldDestinationX.getId());
            try {
                oldDestinationX.getRuntimeDestination().shutdownDestination();
            }
            catch (Throwable t) {
                this.mLogger.logp(Level.WARNING, CLASS_NAME, "clearDestinationIfUnused", "DMS-58031", new Object[]{oldDestinationX.getId()}, t);
            }
        }
    }

    private void clearFilterIfUnused(String filterId) {
        String METHOD_NAME = "clearFilterIfUnused";
        Set<FilterDestinationPair> remainingPairsForThisFilter = this.mAssociationsTable.findFilterDestinationPairsById(filterId, null, false);
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "clearFilterIfUnused", "Found " + remainingPairsForThisFilter.size() + " pairs for destination " + filterId + ".");
        }
        if (remainingPairsForThisFilter.size() == 0) {
            EventConfigManager.FilterConfigRuntimePair oldFilterX = this.mActiveFilterMapX.remove(filterId);
        }
    }

    private void updateOtherSystems() {
        String METHOD_NAME = "updateOtherSystems";
        ++this.mUpdateCount;
        if (this.mAssociationsTable.isEmpty()) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "updateOtherSystems", "Removing self as EventRuntimeManager from EventSystem.");
            EventSystem.setEventManagers(this, null);
        } else {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "updateOtherSystems", "Setting self as EventRuntimeManager in EventSystem.");
            EventSystem.setEventManagers(this, this);
        }
        String[] allNounTypes = Noun.getAllTypes();
        if (allNounTypes != null) {
            for (String nounType : allNounTypes) {
                NounDescriptor nd = Noun.getDescriptorByType(nounType);
                nd.setEventable(this);
            }
        }
    }

    @Override
    public synchronized boolean hasFilter(String filterId) {
        return this.findFilter(filterId) != null;
    }

    @Deprecated
    public Filter findFilter(String filterId) {
        Filter retVal = null;
        EventConfigManager.FilterConfigRuntimePair filterFromMapX = this.mActiveFilterMapX.get(filterId);
        Set<FilterDestinationPair> pairsWithFilter = this.mAssociationsTable.findFilterDestinationPairsById(filterId, null, false);
        Set<Filter> filtersInUse = this.mAssociationsTable.findFilters(filterId);
        if (filtersInUse.size() > 1) {
            throw new IllegalStateException("More than one disctinct filter object instances have been found active in the EventManagerImpl: " + filterId);
        }
        if (filterFromMapX != null || pairsWithFilter.size() != 0 || filtersInUse.size() != 0) {
            if (filterFromMapX != null && pairsWithFilter.size() != 0 && filtersInUse.size() == 1) {
                retVal = filterFromMapX.getRuntimeFilter();
                for (FilterDestinationPair pair : pairsWithFilter) {
                    if (filterFromMapX.getRuntimeFilter() == pair.mFilter) continue;
                    retVal = null;
                    throw new IllegalStateException("Filter from mActiveFilterMap and Filter from mAssociationsTable are not the same instance.");
                }
            } else {
                throw new IllegalStateException("Uses of filterId from mActiveFilterMap and mAssociationsTable do not match.");
            }
        }
        return retVal;
    }

    @Override
    public synchronized boolean hasDestination(String destinationId) {
        return this.findDestination(destinationId) != null;
    }

    @Deprecated
    public Destination findDestination(String destinationId) {
        Destination retVal = null;
        EventConfigManager.DestinationConfigRuntimePair destinationFromMapX = this.mActiveDestinationMapX.get(destinationId);
        Set<FilterDestinationPair> pairsWithDestination = this.mAssociationsTable.findFilterDestinationPairsById(null, destinationId, false);
        Set<Destination> destinationsInUse = this.mAssociationsTable.findDestinations(destinationId);
        if (destinationsInUse.size() > 1) {
            throw new IllegalArgumentException("More than one disctinct destination object instances have been found active in the EventManagerImpl: " + destinationId);
        }
        if (destinationFromMapX != null || pairsWithDestination.size() != 0 || destinationsInUse.size() != 0) {
            if (destinationFromMapX != null && pairsWithDestination.size() != 0 && destinationsInUse.size() == 1) {
                retVal = destinationFromMapX.getRuntimeDestination();
                for (FilterDestinationPair pair : pairsWithDestination) {
                    if (destinationFromMapX.getRuntimeDestination() == pair.mDestination) continue;
                    retVal = null;
                    throw new IllegalStateException("Destination from mActiveDestinationMap and Destination from mAssociationsTable are not the same instance.");
                }
            } else {
                throw new IllegalStateException("Uses of destinationId from mActiveDestinationMap and mAssociationsTable do not match.");
            }
        }
        return retVal;
    }

    @Deprecated
    public synchronized boolean hasFilterDestinationAssociation(Filter f, Destination d) {
        boolean filterIsOK = false;
        boolean destinationIsOK = false;
        Set<FilterDestinationPair> fdpSet = this.mAssociationsTable.findFilterDestinationPairsById(f.getId(), d.getId(), false);
        if (fdpSet.size() > 1) {
            throw new IllegalStateException("More than one filter-destination is currently in use: filterId=" + f.getId() + ", destinationId=" + d.getId());
        }
        if (fdpSet.size() == 1) {
            Set<Destination> destinationSet;
            Set<Filter> filterSet = this.mAssociationsTable.findFilters(f.getId());
            if (filterSet.size() == 0) {
                throw new IllegalStateException("A filter-destination pair is active in the system, but there is no record of the filter being active: " + f.getId());
            }
            if (filterSet.size() > 1) {
                throw new IllegalArgumentException("More than one disctinct filter object instances have been found active in the EventManagerImpl: " + f.getId());
            }
            Filter filterFromSet = filterSet.iterator().next();
            if (filterFromSet == f) {
                filterIsOK = true;
            }
            if ((destinationSet = this.mAssociationsTable.findDestinations(d.getId())).size() == 0) {
                throw new IllegalStateException("A filter-destination pair is active in the system, but there is no record of the destination being active: " + d.getId());
            }
            if (destinationSet.size() > 1) {
                throw new IllegalArgumentException("More than one disctinct destination object instances have been found active in the EventManagerImpl: " + d.getId());
            }
            Destination destinationFromSet = destinationSet.iterator().next();
            if (destinationFromSet == d) {
                destinationIsOK = true;
            }
        }
        return filterIsOK && destinationIsOK;
    }

    @Override
    public synchronized void removeFilter(String filterId) {
        String METHOD_NAME = "removeFilter";
        this.mLogger.logp(Level.FINE, CLASS_NAME, "removeFilter", "Called to remove filter " + filterId);
        if (filterId != null) {
            EventConfigManager.FilterConfigRuntimePair oldFilterX = this.mActiveFilterMapX.remove(filterId);
            if (oldFilterX != null) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "removeFilter", "Found filter " + filterId + " - will proceeding to remove it.", (Object)oldFilterX);
                Set<FilterDestinationPair> removedPairs = this.mAssociationsTable.findFilterDestinationPairsById(filterId, null, true);
                if (removedPairs.size() > 0) {
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.logp(Level.FINE, CLASS_NAME, "removeFilter", "Removed " + removedPairs.size() + " filter-destinations as a result of removing filter " + filterId);
                    }
                    HashSet<String> destinationIds = new HashSet<String>();
                    for (FilterDestinationPair pair : removedPairs) {
                        destinationIds.add(pair.mDestination.getId());
                    }
                    for (String destinationId : destinationIds) {
                        this.clearDestinationIfUnused(destinationId);
                    }
                    this.updateOtherSystems();
                }
            }
        } else {
            this.mLogger.logp(Level.WARNING, CLASS_NAME, "removeFilter", "DMS-58032");
        }
    }

    @Override
    public synchronized void removeDestination(String destinationId) {
        EventConfigManager.DestinationConfigRuntimePair oldDestinationX;
        String METHOD_NAME = "removeDestination";
        this.mLogger.logp(Level.FINE, CLASS_NAME, "removeDestination", "Called to remove destination " + destinationId);
        if (destinationId != null && (oldDestinationX = this.mActiveDestinationMapX.remove(destinationId)) != null) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "removeDestination", "Found destination " + destinationId + " - will proceeding to remove it.", (Object)oldDestinationX);
            Set<FilterDestinationPair> removedPairs = this.mAssociationsTable.findFilterDestinationPairsById(null, destinationId, true);
            if (removedPairs.size() > 0) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "removeDestination", "Removed " + removedPairs.size() + " filter-destinations as a result of removing destination " + destinationId);
                this.mLogger.logp(Level.FINE, CLASS_NAME, "removeDestination", "Calling shutdown on old destination " + destinationId);
                try {
                    oldDestinationX.getRuntimeDestination().shutdownDestination();
                }
                catch (Throwable t) {
                    this.mLogger.logp(Level.WARNING, CLASS_NAME, "removeDestination", "DMS-58031", new Object[]{oldDestinationX.getId()}, t);
                }
                HashSet<String> filterIds = new HashSet<String>();
                for (FilterDestinationPair pair : removedPairs) {
                    filterIds.add(pair.mFilter.getId());
                }
                for (String filterId : filterIds) {
                    this.clearFilterIfUnused(filterId);
                }
                this.updateOtherSystems();
            }
        }
    }

    @Override
    public boolean[] isNounTypeOfPossibleInterest(String nounType) {
        boolean[] retVal = new boolean[EventActionType.values().length];
        for (EventActionType actionType : EventActionType.values()) {
            retVal[actionType.ordinal()] = this.isNounTypeOfPossibleInterest(nounType, actionType);
        }
        return retVal;
    }

    private boolean isNounTypeOfPossibleInterest(String nounType, EventActionType actionType) {
        boolean retVal = false;
        for (EventConfigManager.FilterConfigRuntimePair filterX : this.mActiveFilterMapX.values()) {
            if (!EventType.eventTypeArrayContains(filterX.getRuntimeFilter().getEventTypesOfInterest(), EventSourceType.INSTRUMENTATION_NODE, actionType) || filterX.getRuntimeFilter().willDiscriminateAgainstNounType(nounType)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    int getNumberOfInterestParties(EventSourceType sourceType, EventActionType actionType) {
        return this.mAssociationsTable.mCells[sourceType.ordinal()][actionType.ordinal()].size();
    }

    private void updateAssociations(Filter newFilter, Destination newDestination) {
        block7: {
            block8: {
                block6: {
                    String METHOD_NAME = "updateAssociations";
                    if (newFilter == null && newDestination == null) {
                        throw new IllegalArgumentException("At least one of changedFilter or changedDestination must be non-null.");
                    }
                    if (newFilter == null || newDestination == null) break block6;
                    Set<FilterDestinationPair> oldPair = this.mAssociationsTable.findFilterDestinationPairsById(newFilter.getId(), newDestination.getId(), true);
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.logp(Level.FINE, CLASS_NAME, "updateAssociations", "Updating " + oldPair.size() + " associations for filter: " + newFilter.getId() + ", destination: " + newDestination.getId());
                    }
                    FilterDestinationPair replacementFDP = new FilterDestinationPair(newFilter, newDestination);
                    this.mAssociationsTable.addFilterDestinationPair(replacementFDP);
                    break block7;
                }
                if (newFilter == null || newDestination != null) break block8;
                Set<FilterDestinationPair> oldPairs = this.mAssociationsTable.findFilterDestinationPairsById(newFilter.getId(), null, true);
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.logp(Level.FINE, CLASS_NAME, "updateAssociations", "Updating " + oldPairs.size() + " associations for filter: " + newFilter.getId());
                }
                for (FilterDestinationPair oldFDP : oldPairs) {
                    FilterDestinationPair replacementFDP = new FilterDestinationPair(newFilter, oldFDP.mDestination);
                    this.mAssociationsTable.addFilterDestinationPair(replacementFDP);
                }
                break block7;
            }
            if (newFilter != null || newDestination == null) break block7;
            Set<FilterDestinationPair> oldPairs = this.mAssociationsTable.findFilterDestinationPairsById(null, newDestination.getId(), true);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "updateAssociations", "Updating " + oldPairs.size() + " associations for destination: " + newDestination.getId());
            }
            for (FilterDestinationPair oldFDP : oldPairs) {
                FilterDestinationPair replacementFDP = new FilterDestinationPair(oldFDP.mFilter, newDestination);
                this.mAssociationsTable.addFilterDestinationPair(replacementFDP);
            }
        }
    }

    @Deprecated
    public static void initializeDestination(Destination inDestination) throws Exception {
        EventManagerImpl.initializeDestination(inDestination, null);
    }

    private static void initializeDestination(Destination inDestination, Set<Filter> inFilterSet) throws Exception {
        String eventTypes;
        inDestination.initDestination();
        if (inDestination.getClass().isAnnotationPresent(RequiresEventsOnInitialization.class) && (eventTypes = inDestination.getClass().getAnnotation(RequiresEventsOnInitialization.class).eventTypes()).contains("NOUN:CREATE")) {
            Filter[] activeFilterArray = inFilterSet != null ? inFilterSet.toArray(new Filter[inFilterSet.size()]) : new Filter[]{};
            NodeListener inwListener = new NodeListener(inDestination, activeFilterArray);
            InstrumentationNodeWalker inw = new InstrumentationNodeWalker(inwListener);
            inw.walk(Noun.getRoot());
        }
    }

    @Override
    public synchronized void shutdown() {
        String METHOD_NAME = "shutdown";
        this.mAssociationsTable.clear();
        for (EventConfigManager.DestinationConfigRuntimePair destination : this.mActiveDestinationMapX.values()) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "shutdown", "Calling shutdown on destination " + destination.getId());
            try {
                destination.getRuntimeDestination().shutdownDestination();
            }
            catch (Throwable t) {
                this.mLogger.logp(Level.WARNING, CLASS_NAME, "shutdown", "DMS-58031", new Object[]{destination.getId()}, t);
            }
        }
        this.mActiveDestinationMapX.clear();
        this.mActiveFilterMapX.clear();
    }

    @Override
    public synchronized boolean replaceFilter(EventConfigManager.FilterConfigRuntimePair replacementFilterX) {
        EventConfigManager.FilterConfigRuntimePair oldFilterX;
        String METHOD_NAME = "replaceFilter";
        this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceFilter", "Called to replace filter " + replacementFilterX.getId());
        boolean retVal = false;
        if (replacementFilterX != null && (oldFilterX = this.mActiveFilterMapX.get(replacementFilterX.getId())) != null) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceFilter", "Found an incumbant filter with an ID that matches the new filter " + replacementFilterX.getId());
            if (!oldFilterX.getRuntimeFilter().equals(replacementFilterX.getRuntimeFilter())) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceFilter", "The incumbant filter does not equal the new filter and thus the incumbant filter will be replaced with the new filter " + replacementFilterX.getId());
                Set<FilterDestinationPair> fdpsInvolvingReplacementFilter = this.mAssociationsTable.findFilterDestinationPairsById(replacementFilterX.getId(), null, false);
                HashSet<Destination> destinationsNeedingReinitialization = new HashSet<Destination>(8);
                for (FilterDestinationPair fdp : fdpsInvolvingReplacementFilter) {
                    if (!fdp.mDestination.getClass().isAnnotationPresent(RequiresReinitializationOnFilterChange.class)) continue;
                    destinationsNeedingReinitialization.add(fdp.mDestination);
                }
                if (destinationsNeedingReinitialization.size() > 0) {
                    for (Destination d : destinationsNeedingReinitialization) {
                        this.reInitializeDestinationWithAdditionalFilter(d.getId(), replacementFilterX);
                    }
                }
                this.mActiveFilterMapX.put(replacementFilterX.getId(), replacementFilterX);
                this.updateAssociations(replacementFilterX.getRuntimeFilter(), null);
                retVal = true;
                this.updateOtherSystems();
            }
        }
        return retVal;
    }

    @Override
    public synchronized boolean replaceDestination(EventConfigManager.DestinationConfigRuntimePair newDestinationX) {
        boolean retVal = this.replaceDestinationSpecial(newDestinationX, null);
        if (retVal) {
            this.updateOtherSystems();
        }
        return retVal;
    }

    private boolean replaceDestinationSpecial(EventConfigManager.DestinationConfigRuntimePair newDestinationX, EventConfigManager.FilterConfigRuntimePair additionalFilterX) {
        EventConfigManager.DestinationConfigRuntimePair oldDestination;
        String METHOD_NAME = "replaceDestination";
        this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceDestination", "Called to replace destination " + newDestinationX.getId());
        boolean retVal = false;
        if (newDestinationX != null && (oldDestination = this.mActiveDestinationMapX.get(newDestinationX.getId())) != null) {
            this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceDestination", "Found an incumbant destination with an ID that matches the new destination " + newDestinationX.getId());
            if (!oldDestination.getRuntimeDestination().equals(newDestinationX.getRuntimeDestination())) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceDestination", "The incumbant destination does not equal the new destination and thus the incumbant destination will be replaced with the new destination " + newDestinationX.getId());
                this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceDestination", "Calling init on destination " + newDestinationX.getId());
                Set<FilterDestinationPair> fdps = this.mAssociationsTable.findFilterDestinationPairsById(null, oldDestination.getId(), true);
                HashSet<Filter> filters = new HashSet<Filter>();
                if (additionalFilterX != null) {
                    filters.add(additionalFilterX.getRuntimeFilter());
                }
                for (FilterDestinationPair fdp : fdps) {
                    if (additionalFilterX != null && additionalFilterX.getId().equals(fdp.mFilter.getId())) continue;
                    filters.add(fdp.mFilter);
                }
                try {
                    oldDestination.getRuntimeDestination().shutdownDestination();
                    EventManagerImpl.initializeDestination(newDestinationX.getRuntimeDestination(), filters);
                    this.mActiveDestinationMapX.put(newDestinationX.getId(), newDestinationX);
                    if (additionalFilterX != null) {
                        this.mActiveFilterMapX.put(additionalFilterX.getId(), additionalFilterX);
                    }
                    for (Filter f : filters) {
                        this.updateAssociations(f, newDestinationX.getRuntimeDestination());
                    }
                    this.mLogger.logp(Level.FINE, CLASS_NAME, "replaceDestination", "Calling shutdown on destination " + oldDestination.getId());
                    retVal = true;
                }
                catch (Exception e) {
                    this.mLogger.logp(Level.WARNING, CLASS_NAME, "replaceDestination", "DMS-58029", new Object[]{newDestinationX.getId()}, (Throwable)e);
                    this.mActiveDestinationMapX.remove(newDestinationX.getId());
                    for (Filter f : filters) {
                        this.clearFilterIfUnused(f.getId());
                    }
                }
            }
        }
        return retVal;
    }

    private boolean replaceFilterAndDestinationRequiringEventsOnFilterChange(EventConfigManager.FilterConfigRuntimePair incumbantFilterX, EventConfigManager.FilterConfigRuntimePair newFilterX, EventConfigManager.DestinationConfigRuntimePair incumbantDestinationX, EventConfigManager.DestinationConfigRuntimePair newDestinationX) {
        String METHOD_NAME = "replaceFilterAndDestinationRequiringEventsOnFilterChange";
        boolean retVal = false;
        Set<FilterDestinationPair> fdps = this.mAssociationsTable.findFilterDestinationPairsById(null, newDestinationX.getId(), true);
        for (FilterDestinationPair fdp : fdps) {
            if (fdp.mDestination != incumbantDestinationX.getRuntimeDestination()) {
                throw new IllegalStateException("FilterDestinationPairs found that do not match asserted incumbantDestination.");
            }
            if (fdp.mFilter == incumbantFilterX.getRuntimeFilter()) continue;
            throw new IllegalStateException("FilterDestinationPairs found that do not match asserted incumbantFilter.");
        }
        incumbantDestinationX.getRuntimeDestination().shutdownDestination();
        HashSet<Filter> filters = new HashSet<Filter>();
        filters.add(newFilterX.getRuntimeFilter());
        for (FilterDestinationPair fdp : fdps) {
            if (fdp.mFilter.getId().equals(newFilterX.getId())) continue;
            filters.add(fdp.mFilter);
        }
        try {
            EventManagerImpl.initializeDestination(newDestinationX.getRuntimeDestination(), filters);
            this.replaceFilter(newFilterX);
            for (Filter f : filters) {
                this.updateAssociations(f, newDestinationX.getRuntimeDestination());
            }
            this.mActiveDestinationMapX.put(newDestinationX.getId(), newDestinationX);
            this.mActiveFilterMapX.put(newFilterX.getId(), newFilterX);
            retVal = true;
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.WARNING, "DMS-58043");
            lr.setResourceBundle(this.mLogger.getResourceBundle());
            lr.setSourceClassName(CLASS_NAME);
            lr.setSourceMethodName("replaceFilterAndDestinationRequiringEventsOnFilterChange");
            lr.setParameters(new Object[]{newDestinationX.getId(), newFilterX.getId()});
            lr.setThrown(e);
            this.mLogger.log(lr);
        }
        return retVal;
    }

    private boolean reInitializeDestinationWithAdditionalFilter(String inumbantDestinationId, EventConfigManager.FilterConfigRuntimePair inFilterX) {
        String METHOD_NAME = "reInitializeDestinationWithAdditionalFilter";
        boolean retVal = false;
        EventConfigManager.DestinationConfigRuntimePair inumbantDestinationX = this.mActiveDestinationMapX.get(inumbantDestinationId);
        Set<FilterDestinationPair> fdps = this.mAssociationsTable.findFilterDestinationPairsById(null, inumbantDestinationX.getId(), true);
        for (FilterDestinationPair fdp : fdps) {
            if (fdp.mDestination == inumbantDestinationX.getRuntimeDestination()) continue;
            throw new IllegalStateException("FilterDestinationPairs found that do not match asserted incumbantDestination.");
        }
        HashSet<Filter> filters = new HashSet<Filter>();
        if (inFilterX != null) {
            filters.add(inFilterX.getRuntimeFilter());
            for (FilterDestinationPair fdp : fdps) {
                if (fdp.mFilter.getId().equals(inFilterX.getRuntimeFilter().getId())) continue;
                filters.add(fdp.mFilter);
            }
        } else {
            for (FilterDestinationPair fdp : fdps) {
                filters.add(fdp.mFilter);
            }
        }
        try {
            inumbantDestinationX.getRuntimeDestination().shutdownDestination();
            EventManagerImpl.initializeDestination(inumbantDestinationX.getRuntimeDestination(), filters);
            for (Filter f : filters) {
                this.updateAssociations(f, inumbantDestinationX.getRuntimeDestination());
            }
            if (inFilterX != null) {
                this.mActiveFilterMapX.put(inFilterX.getId(), inFilterX);
            }
            retVal = true;
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.WARNING, "DMS-58043");
            lr.setResourceBundle(this.mLogger.getResourceBundle());
            lr.setSourceClassName(CLASS_NAME);
            lr.setSourceMethodName("reInitializeDestinationWithAdditionalFilter");
            lr.setParameters(new Object[]{inumbantDestinationId, inFilterX.getId()});
            lr.setThrown(e);
            this.mLogger.log(lr);
            for (Filter f : filters) {
                this.clearFilterIfUnused(f.getId());
            }
        }
        return retVal;
    }

    @Override
    public synchronized Map<String, oracle.dms.event.config.Filter> getAllFilterConfigs() {
        HashMap<String, oracle.dms.event.config.Filter> retVal = new HashMap<String, oracle.dms.event.config.Filter>(this.mActiveFilterMapX.size());
        for (Map.Entry<String, EventConfigManager.FilterConfigRuntimePair> entry : this.mActiveFilterMapX.entrySet()) {
            if (entry.getValue().getConfigFilter() == null) continue;
            retVal.put(entry.getKey(), entry.getValue().getConfigFilter());
        }
        return retVal;
    }

    @Override
    public synchronized Map<String, oracle.dms.event.config.Destination> getAllDestinationConfigs() {
        HashMap<String, oracle.dms.event.config.Destination> retVal = new HashMap<String, oracle.dms.event.config.Destination>(this.mActiveDestinationMapX.size());
        for (Map.Entry<String, EventConfigManager.DestinationConfigRuntimePair> entry : this.mActiveDestinationMapX.entrySet()) {
            if (entry.getValue().getConfigDestination() == null) continue;
            retVal.put(entry.getKey(), entry.getValue().getConfigDestination());
        }
        return retVal;
    }

    @Override
    public EventConfigManager.DestinationConfigRuntimePair findDestination(oracle.dms.event.config.Destination destinationConfig) {
        EventConfigManager.DestinationConfigRuntimePair dcrp;
        EventConfigManager.DestinationConfigRuntimePair retVal = null;
        if (destinationConfig != null && (dcrp = this.mActiveDestinationMapX.get(destinationConfig.getDestinationId())) != null && destinationConfig.equals(dcrp.getConfigDestination())) {
            retVal = dcrp;
        }
        return retVal;
    }

    @Override
    public synchronized Set<EventConfig.EventRouteTuple> getAllEventRouteTuples(boolean ignoreNullConfig) {
        Set<FilterDestinationPair> fdpPairs = this.mAssociationsTable.findFilterDestinationPairsById(null, null, false);
        HashSet<EventConfig.EventRouteTuple> retVal = new HashSet<EventConfig.EventRouteTuple>(fdpPairs.size());
        for (FilterDestinationPair fdp : fdpPairs) {
            EventConfig.EventRouteTuple tuple = new EventConfig.EventRouteTuple(fdp.mFilter.getId(), fdp.mDestination.getId(), true);
            if (ignoreNullConfig) {
                EventConfigManager.DestinationConfigRuntimePair dcrp = this.mActiveDestinationMapX.get(fdp.mDestination.getId());
                EventConfigManager.FilterConfigRuntimePair fcrp = this.mActiveFilterMapX.get(fdp.mFilter.getId());
                if (fcrp == null) {
                    this.mLogger.log(Level.WARNING, "Questionable internal state detected: no active filter found for active event-route " + fdp);
                    continue;
                }
                if (dcrp == null) {
                    this.mLogger.log(Level.WARNING, "Questionable internal state detected: no active destination found for active event-route" + fdp);
                    continue;
                }
                if (dcrp.getConfigDestination() == null || fcrp.getConfigFilter() == null) continue;
                retVal.add(tuple);
                continue;
            }
            retVal.add(tuple);
        }
        return retVal;
    }

    public String toString() {
        Map<String, oracle.dms.event.config.Destination> dMap = this.getAllDestinationConfigs();
        Map<String, oracle.dms.event.config.Filter> fMap = this.getAllFilterConfigs();
        Set<EventConfig.EventRouteTuple> eventRoutes = this.getAllEventRouteTuples(false);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        JSONUtils.appendNameValuePair(sb, "numberOfUpdates", this.mUpdateCount);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "ConfiguredDestinations", dMap.values());
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "ConfiguredFilters", fMap.values());
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "ConfiguredEventRoutes", eventRoutes);
        sb.append(',');
        JSONUtils.appendName(sb, "ExecutingEventRoutes");
        sb.append(':');
        sb.append('[');
        int listCount = 0;
        for (String destinationId : this.mActiveDestinationMapX.keySet()) {
            for (String filterId : this.mActiveFilterMapX.keySet()) {
                Set<FilterDestinationPair> fdps = this.mAssociationsTable.findFilterDestinationPairsById(filterId, destinationId, false);
                if (fdps.size() <= 0) continue;
                if (++listCount > 1) {
                    sb.append(',');
                }
                sb.append('{');
                JSONUtils.appendNameValuePair(sb, "filterId", filterId);
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "destinationId", destinationId);
                sb.append('}');
            }
        }
        sb.append(']');
        sb.append('}');
        String retVal = sb.toString();
        return retVal;
    }

    @InstrumentationNodeWalker.ReportNouns
    static class NodeListener
    implements InstrumentationNodeWalker.Listener {
        Destination mDestination;
        Filter[] mFilters;

        NodeListener(Destination d, Filter[] fs) {
            this.mDestination = d;
            this.mFilters = fs;
        }

        @Override
        public void processNode(Object o) {
            if (o instanceof Noun) {
                EventImpl event = new EventImpl(o, EventSourceType.NOUN, EventActionType.CREATE, -121L, null, null, null);
                boolean eventPassed = false;
                if (this.mFilters.length > 0) {
                    for (int i = 0; i < this.mFilters.length; ++i) {
                        if (!this.mFilters[i].applyFilter(event)) continue;
                        eventPassed = true;
                        break;
                    }
                } else {
                    eventPassed = true;
                }
                if (eventPassed) {
                    this.mDestination.handleEvent(event);
                }
            }
        }
    }

    private static class AssociationsTable {
        List<DestinationFiltersEntry>[][] mCells = new List[sNumOfSourceTypes][sNumOfActionTypes];
        static int sNumOfSourceTypes = EventSourceType.values().length;
        static int sNumOfActionTypes = EventActionType.values().length;

        AssociationsTable() {
            for (int i = 0; i < sNumOfSourceTypes; ++i) {
                for (int j = 0; j < sNumOfActionTypes; ++j) {
                    this.mCells[i][j] = new CopyOnWriteArrayList<DestinationFiltersEntry>();
                }
            }
        }

        boolean isEmpty() {
            boolean retVal = true;
            for (int i = 0; i < sNumOfSourceTypes; ++i) {
                for (int j = 0; j < sNumOfActionTypes; ++j) {
                    retVal &= this.mCells[i][j].isEmpty();
                }
            }
            return retVal;
        }

        void clear() {
            for (int i = 0; i < sNumOfSourceTypes; ++i) {
                for (int j = 0; j < sNumOfActionTypes; ++j) {
                    this.mCells[i][j].clear();
                }
            }
        }

        void addFilterDestinationPair(FilterDestinationPair fdp) {
            EventType[] eventTypes;
            for (EventType eventType : eventTypes = fdp.mFilter.getEventTypesOfInterest()) {
                if (eventType == null) continue;
                List<DestinationFiltersEntry> dfeList = this.mCells[eventType.getSourceType().ordinal()][eventType.getActionType().ordinal()];
                int foundDFEIndex = AssociationsTable.findDFEByDestinationId(dfeList, fdp.mDestination.getId());
                if (foundDFEIndex < 0) {
                    DestinationFiltersEntry newDFE = new DestinationFiltersEntry(fdp.mDestination, fdp.mFilter);
                    dfeList.add(newDFE);
                    continue;
                }
                DestinationFiltersEntry replacementDFE = dfeList.get(foundDFEIndex).addFilter(fdp.mFilter);
                if (replacementDFE == null) continue;
                dfeList.set(foundDFEIndex, replacementDFE);
            }
        }

        static int findDFEByDestinationId(List<DestinationFiltersEntry> dfeList, String destinationId) {
            int retVal = -1;
            int listSize = dfeList.size();
            for (int dfeIndex = 0; dfeIndex < listSize; ++dfeIndex) {
                DestinationFiltersEntry dfe = dfeList.get(dfeIndex);
                if (!dfe.mDestination.getId().equals(destinationId)) continue;
                retVal = dfeIndex;
                break;
            }
            return retVal;
        }

        private static void findDestinationFDPWithinCell(String destinationId, List<DestinationFiltersEntry> dfeList, Set<FilterDestinationPair> foundSet, boolean delete) {
            int foundDFEIndex = AssociationsTable.findDFEByDestinationId(dfeList, destinationId);
            if (foundDFEIndex != -1) {
                DestinationFiltersEntry dfe = dfeList.get(foundDFEIndex);
                for (Filter f : dfe.mFilters) {
                    foundSet.add(new FilterDestinationPair(f, dfe.mDestination));
                }
                if (delete) {
                    DestinationFiltersEntry removedDFE = dfeList.remove(foundDFEIndex);
                }
            }
        }

        private static void findFilterDFPWithinCell(String filterId, List<DestinationFiltersEntry> dfeList, Set<FilterDestinationPair> foundSet, boolean delete) {
            ArrayList<DestinationFiltersEntry> removalList = new ArrayList<DestinationFiltersEntry>();
            int listSize = dfeList.size();
            for (int dfeIndex = 0; dfeIndex < listSize; ++dfeIndex) {
                DestinationFiltersEntry dfe = dfeList.get(dfeIndex);
                Filter foundFilter = dfe.findFilterById(filterId);
                if (foundFilter == null) continue;
                foundSet.add(new FilterDestinationPair(foundFilter, dfe.mDestination));
                if (!delete) continue;
                if (dfe.mFilterCount == 1) {
                    removalList.add(dfe);
                    continue;
                }
                DestinationFiltersEntry replacementDFE = dfe.removeFilterById(filterId);
                dfeList.set(dfeIndex, replacementDFE);
            }
            if (delete) {
                dfeList.removeAll(removalList);
            }
        }

        private static void findDFPFWithinCell(String filterId, String destinationId, List<DestinationFiltersEntry> dfeList, Set<FilterDestinationPair> foundSet, boolean delete) {
            DestinationFiltersEntry dfe;
            Filter matchedFilter;
            int dfeIndex = AssociationsTable.findDFEByDestinationId(dfeList, destinationId);
            if (dfeIndex != -1 && (matchedFilter = (dfe = dfeList.get(dfeIndex)).findFilterById(filterId)) != null) {
                foundSet.add(new FilterDestinationPair(matchedFilter, dfe.mDestination));
                if (delete) {
                    if (dfe.mFilterCount == 1) {
                        dfeList.remove(dfe);
                    } else {
                        DestinationFiltersEntry replacementDFE = dfe.removeFilterById(filterId);
                        dfeList.set(dfeIndex, replacementDFE);
                    }
                }
            }
        }

        Set<FilterDestinationPair> findFilterDestinationPairsById(String filterId, String destinationId, boolean remove) {
            HashSet<FilterDestinationPair> retVal = new HashSet<FilterDestinationPair>();
            for (int i = 0; i < sNumOfSourceTypes; ++i) {
                for (int j = 0; j < sNumOfActionTypes; ++j) {
                    if (filterId != null && destinationId != null) {
                        AssociationsTable.findDFPFWithinCell(filterId, destinationId, this.mCells[i][j], retVal, remove);
                        continue;
                    }
                    if (filterId == null && destinationId != null) {
                        AssociationsTable.findDestinationFDPWithinCell(destinationId, this.mCells[i][j], retVal, remove);
                        continue;
                    }
                    if (filterId != null && destinationId == null) {
                        AssociationsTable.findFilterDFPWithinCell(filterId, this.mCells[i][j], retVal, remove);
                        continue;
                    }
                    if (remove) {
                        throw new RuntimeException("Remove is not yet supported for null filterId and destinationId.");
                    }
                    if (this.mCells[i][j] == null) continue;
                    for (DestinationFiltersEntry dfe : this.mCells[i][j]) {
                        for (Filter filter : dfe.mFilters) {
                            retVal.add(new FilterDestinationPair(filter, dfe.mDestination));
                        }
                    }
                }
            }
            return retVal;
        }

        Set<Filter> findFilters(String filterId) {
            HashSet<Filter> retVal = new HashSet<Filter>();
            if (filterId != null) {
                for (int i = 0; i < sNumOfSourceTypes; ++i) {
                    for (int j = 0; j < sNumOfActionTypes; ++j) {
                        for (DestinationFiltersEntry fde : this.mCells[i][j]) {
                            for (Filter f : fde.mFilters) {
                                if (!f.getId().equals(filterId)) continue;
                                retVal.add(f);
                            }
                        }
                    }
                }
            }
            return retVal;
        }

        Set<Destination> findDestinations(String destinationId) {
            HashSet<Destination> retVal = new HashSet<Destination>();
            if (destinationId != null) {
                for (int i = 0; i < sNumOfSourceTypes; ++i) {
                    for (int j = 0; j < sNumOfActionTypes; ++j) {
                        for (DestinationFiltersEntry fde : this.mCells[i][j]) {
                            if (!fde.mDestination.getId().equals(destinationId)) continue;
                            retVal.add(fde.mDestination);
                        }
                    }
                }
            }
            return retVal;
        }
    }

    private static class DestinationFiltersEntry {
        Destination mDestination;
        Filter[] mFilters;
        int mFilterCount;

        DestinationFiltersEntry(Destination d, Filter[] filters) {
            this.mFilters = filters;
            this.mDestination = d;
            this.mFilterCount = this.mFilters.length;
        }

        DestinationFiltersEntry(Destination d, Filter f) {
            this(d, new Filter[]{f});
        }

        DestinationFiltersEntry addFilter(Filter f) {
            DestinationFiltersEntry retVal = null;
            if (this.findFilterById(f.getId()) == null) {
                Filter[] newFilterArray = new Filter[this.mFilterCount + 1];
                System.arraycopy(this.mFilters, 0, newFilterArray, 0, this.mFilterCount);
                newFilterArray[this.mFilterCount] = f;
                retVal = new DestinationFiltersEntry(this.mDestination, newFilterArray);
            }
            return retVal;
        }

        DestinationFiltersEntry removeFilterById(String filterId) {
            DestinationFiltersEntry retVal = null;
            Filter foundFilter = this.findFilterById(filterId);
            if (foundFilter != null) {
                Filter[] newFilterArray = new Filter[this.mFilterCount - 1];
                int toIndex = 0;
                for (int fromIndex = 0; fromIndex < this.mFilterCount; ++fromIndex) {
                    if (this.mFilters[fromIndex] == foundFilter) continue;
                    newFilterArray[toIndex] = this.mFilters[fromIndex];
                    ++toIndex;
                }
                retVal = new DestinationFiltersEntry(this.mDestination, newFilterArray);
            }
            return retVal;
        }

        Filter findFilterById(String filterId) {
            Filter retVal = null;
            for (int i = 0; i < this.mFilterCount; ++i) {
                if (!this.mFilters[i].getId().equals(filterId)) continue;
                retVal = this.mFilters[i];
                break;
            }
            return retVal;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o == this) {
                retVal = true;
            } else if (o instanceof DestinationFiltersEntry) {
                DestinationFiltersEntry dfe = (DestinationFiltersEntry)o;
                if (this.mFilterCount == dfe.mFilterCount && this.mDestination.getId().equals(dfe.mDestination.getId())) {
                    int matchedFilterCount = 0;
                    for (int filterIndex = 0; filterIndex < dfe.mFilterCount; ++filterIndex) {
                        if (this.findFilterById(dfe.mFilters[filterIndex].getId()) == null) continue;
                        ++matchedFilterCount;
                    }
                    if (matchedFilterCount == this.mFilterCount) {
                        retVal = true;
                    }
                }
            }
            return retVal;
        }

        public int hashCode() {
            int retVal = this.mDestination.getId().hashCode();
            for (int i = 0; i < this.mFilterCount; ++i) {
                retVal ^= this.mFilters[i].getId().hashCode();
            }
            return retVal;
        }
    }

    private static class FilterDestinationPair {
        final int mHashCode;
        final Filter mFilter;
        final Destination mDestination;

        FilterDestinationPair(Filter filter, Destination destination) {
            if (filter == null || destination == null) {
                throw new IllegalArgumentException("Both filter and destination must be non-null.");
            }
            this.mFilter = filter;
            this.mDestination = destination;
            this.mHashCode = (this.mFilter == null ? 0 : this.mFilter.getId().hashCode()) ^ (this.mDestination == null ? 0 : this.mDestination.getId().hashCode());
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof FilterDestinationPair) {
                FilterDestinationPair p = (FilterDestinationPair)o;
                boolean mFilterMatches = FilterDestinationPair.doIdentifiablesMatch(p.mFilter, this.mFilter);
                boolean mDestinationMatches = FilterDestinationPair.doIdentifiablesMatch(p.mDestination, this.mDestination);
                retVal = mFilterMatches && mDestinationMatches;
            }
            return retVal;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        static boolean doIdentifiablesMatch(Identifiable i1, Identifiable i2) {
            boolean retVal = false;
            retVal = i1 == null ? i2 == null : (i2 == null ? false : i1.getId().equals(i2.getId()));
            return retVal;
        }

        public String toString() {
            return this.mFilter.getId() + "->" + this.mDestination.getId();
        }
    }
}

