/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.query;

import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.impl.query.AndCondition;
import oracle.dfw.impl.query.Condition;
import oracle.dfw.impl.query.OrCondition;
import oracle.dfw.impl.query.SimpleCondition;

public class QueryParser {
    private Tokenizer m_tokenizer;

    public Condition parse(String query) throws DiagnosticsException {
        Condition con = null;
        try {
            this.m_tokenizer = new Tokenizer(query);
            this.advance();
            con = this.Q();
        }
        catch (Exception e) {
            throw new DiagnosticsException("DFW-40129", query, e);
        }
        return con;
    }

    private Condition Q() throws IllegalArgumentException {
        Condition c = this.E();
        if (this.hasMoreTokens()) {
            throw new IllegalArgumentException("Unrecognized tokens at end of expression");
        }
        return c;
    }

    private Condition E() throws IllegalArgumentException {
        return this.E1(this.T());
    }

    private Condition E1(Condition op1) throws IllegalArgumentException {
        String t = this.peek();
        if (t == null) {
            return op1;
        }
        if (t.equalsIgnoreCase("and")) {
            this.advance();
            return this.E1(new AndCondition(op1, this.T()));
        }
        if (t.equalsIgnoreCase("or")) {
            this.advance();
            return this.E1(new OrCondition(op1, this.T()));
        }
        return op1;
    }

    private Condition T() throws IllegalArgumentException {
        String t = this.nextToken();
        if (t.equals("(")) {
            Condition c = this.E();
            t = this.nextToken();
            if (!t.equals(")")) {
                throw new IllegalArgumentException("Invalid query expression: execting ')', found '" + t + "'");
            }
            return c;
        }
        return this.F(t);
    }

    private Condition F(String op1) throws IllegalArgumentException {
        String field = op1;
        String opToken = this.nextToken();
        SimpleCondition.Operator operator = SimpleCondition.Operator.getOperator(opToken);
        if (operator == null) {
            throw new IllegalArgumentException("Invalid query expression: invalid operator '" + opToken + "'");
        }
        if (operator == SimpleCondition.Operator.ISNULL || operator == SimpleCondition.Operator.NOTNULL) {
            return new SimpleCondition(field, null, operator);
        }
        String value = this.nextToken();
        return new SimpleCondition(field, value, operator);
    }

    private boolean hasMoreTokens() {
        return this.m_tokenizer.ttype != -1;
    }

    private String nextToken() throws IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            throw new IllegalArgumentException("Unexpected end of expression");
        }
        return this.getToken(true);
    }

    private String peek() throws IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            return null;
        }
        return this.getToken(false);
    }

    private void advance() {
        this.m_tokenizer.nextToken();
    }

    private String getToken(boolean advance) throws IllegalArgumentException {
        String tok = null;
        switch (this.m_tokenizer.ttype) {
            case -2: {
                tok = this.m_tokenizer.sval;
                break;
            }
            case 40: {
                tok = "(";
                break;
            }
            case 41: {
                tok = ")";
                break;
            }
            default: {
                if (this.m_tokenizer.ttype > 32) {
                    throw new IllegalArgumentException("invalid character '" + (char)this.m_tokenizer.ttype + "' in query expression.");
                }
                throw new IllegalArgumentException("invalid characters in query expression.");
            }
        }
        if (advance) {
            this.advance();
        }
        return tok;
    }

    private static class Tokenizer {
        public static final int TT_EOF = -1;
        public static final int TT_WORD = -2;
        public int ttype = 0;
        public String sval = null;
        private CharSequence cs;
        private int pos = 0;

        public Tokenizer(CharSequence cs) {
            this.cs = cs;
        }

        public int nextToken() {
            char ch;
            do {
                if (this.pos != this.cs.length()) continue;
                this.ttype = -1;
                return this.ttype;
            } while (Character.isWhitespace((int)(ch = this.cs.charAt(this.pos++))));
            if (ch == '(' || ch == ')') {
                this.sval = Character.toString(ch);
                this.ttype = ch;
                return this.ttype;
            }
            if (ch == '\'' || ch == '\"') {
                this.sval = this.readQuotedString(ch);
                this.ttype = -2;
                return this.ttype;
            }
            this.sval = this.readWord(ch);
            this.ttype = -2;
            return this.ttype;
        }

        private String readWord(int ch) {
            StringBuilder sb = new StringBuilder();
            while (true) {
                sb.append((char)ch);
                if (this.pos == this.cs.length() || Character.isWhitespace(ch = (int)this.cs.charAt(this.pos)) || ch == 40 || ch == 41 || ch == 39 || ch == 34) break;
                ++this.pos;
            }
            return sb.toString();
        }

        private String readQuotedString(int q) {
            StringBuilder sb = new StringBuilder();
            while (true) {
                int ch;
                if ((ch = this.getChar()) == q) {
                    if (this.pos < this.cs.length() && this.cs.charAt(this.pos) == q) {
                        ch = q;
                        ++this.pos;
                    } else {
                        return sb.toString();
                    }
                }
                sb.append((char)ch);
            }
        }

        private int getChar() {
            if (this.pos == this.cs.length()) {
                throw new RuntimeException("Unexpected end of data");
            }
            return this.cs.charAt(this.pos++);
        }
    }
}

