/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.jmx;

import java.util.List;
import java.util.Map;
import oracle.as.jmx.framework.annotations.AttributeGetterRequiredGlobalSecurityRoles;
import oracle.as.jmx.framework.annotations.Description;
import oracle.as.jmx.framework.annotations.GlobalSecurityRole;
import oracle.as.jmx.framework.annotations.OperationRequiredGlobalSecurityRoles;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.Problem;

@Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_DESCRIPTION", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
public interface IncidentManagerProxyMXBean {
    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_ADR_HOMES", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, List<String>> getADRHomes() throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEMS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, List<Problem>> getProblems() throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEMS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, List<Problem>> getProblemsInADRHome(String var1) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEMS_SERVER", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Problem> getProblems(String var1) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEMS_SERVER_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Problem> getProblems(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEM", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Problem getProblem(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_PROBLEM_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Problem getProblem(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INCIDENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Incident> getIncidents(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INCIDENTS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Incident> getIncidents(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INCIDENT", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident getIncident(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INCIDENT_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident getIncident(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_ADD_INC_FILE", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String addIncidentFile(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_ADD_INC_FILE_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String addIncidentFile(String var1, String var2, String var3, String var4) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INC_FILE_CONTENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String getIncidentFileContents(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_GET_INC_FILE_CONTENTS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String getIncidentFileContents(String var1, String var2, String var3, String var4) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_CREATE_INCIDENT", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident createIncident(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_CREATE_INCIDENT_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident createIncident(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_QUERY_INCIDENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, Map<String, List<Incident>>> queryIncidents(String var1, List<String> var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTPROXYMXBEAN_AGGREGATE_INCIDENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<Incident, Map<String, Map<String, List<Incident>>>> createAggregatedIncident(String var1, List<String> var2) throws Exception;
}

