/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.producer;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import oracle.dms.producer.RowInfo;
import oracle.dms.table.TableSupport;

public class MetricInfo {
    private TableSupport m_table;
    private Map<ObjectName, RowInfo> m_rowInfos = new ConcurrentHashMap<ObjectName, RowInfo>();

    public MetricInfo(TableSupport table) {
        if (table == null) {
            throw new IllegalArgumentException("table=" + table);
        }
        this.m_table = table;
    }

    public TableSupport getTable() {
        return this.m_table;
    }

    public void addRowInfo(RowInfo rowInfo) {
        if (rowInfo == null) {
            return;
        }
        ObjectName objName = rowInfo.getObjectName();
        this.m_rowInfos.put(objName, rowInfo);
    }

    public void removeRowInfo(RowInfo rowInfo) {
        if (rowInfo != null) {
            ObjectName objName = rowInfo.getObjectName();
            this.m_rowInfos.remove(objName);
        }
    }

    public Collection<RowInfo> getRowInfos() {
        return this.m_rowInfos.values();
    }

    public Set<ObjectName> getObjectNames() {
        return this.m_rowInfos.keySet();
    }

    public int rowInfoCount() {
        return this.m_rowInfos.size();
    }
}

