/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.dms.http.Request;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.table.Table;
import oracle.dms.table.TableName;
import oracle.dms.table.TableSource;
import oracle.dms.util.QueryOptions;

public abstract class TableReporter
extends TableBaseReporter {
    TableSource m_source = null;
    Collection<Table> m_tables = null;

    protected TableReporter(TableSource source, Request request) {
        super(request);
        if (source == null) {
            throw new IllegalArgumentException("source=" + source);
        }
        this.m_source = source;
    }

    @Override
    public final void printResponse(PrintWriter out) {
        String METHOD_NAME = "printResponse";
        HashSet<String> badTables = new HashSet<String>();
        String[] rawTableNames = this.m_request.getTables();
        String[] tableNames = null;
        if (rawTableNames != null) {
            tableNames = new String[rawTableNames.length];
            for (int i = 0; i < rawTableNames.length; ++i) {
                TableName tn = TableName.parseName(rawTableNames[i]);
                tableNames[i] = tn.getNormalName();
            }
        }
        this.m_tables = this._getTables(tableNames, badTables);
        this.printHeading(out);
        if (this.m_tables != null) {
            for (Table table : this.m_tables) {
                this.printTable(table, out);
                out.flush();
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, this.getClass().getName(), "printResponse", "no tables to be printed");
        }
        this.printBadParams(null, badTables, out);
        this.printEnding(out);
        badTables.clear();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.m_tables != null) {
            for (Table table : this.m_tables) {
                table.close();
            }
            this.m_tables.clear();
        }
    }

    private Collection<Table> _getTables(String[] tables, Collection<String> badTables) {
        if (tables == null || tables.length == 0) {
            tables = this.m_source.getTableNames(this.m_options);
        }
        QueryOptions options = (QueryOptions)this.m_options.clone();
        Table[] tableObjs = this.m_source.getTables(tables, options);
        HashSet<Table> retval = new HashSet<Table>();
        for (int i = tables.length - 1; i >= 0; --i) {
            if (tableObjs[i] == null) {
                if (badTables == null) continue;
                badTables.add(tables[i]);
                continue;
            }
            retval.add(tableObjs[i]);
        }
        return retval;
    }

    protected abstract void printTable(Table var1, PrintWriter var2);

    protected abstract void printHeading(PrintWriter var1);

    protected abstract void printEnding(PrintWriter var1);
}

