/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupportFactory;

public class MBeanServerSupport {
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.util", "oracle.dms.util.dms");
    private static final String CLASS_NAME = MBeanServerSupport.class.getName();
    private static final String JNDI_RUNTIME = "java:comp/jmx/runtime";

    private static MBeanServer getPlatformMBeanServer() {
        MBeanServer value = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

            @Override
            public MBeanServer run() {
                return ManagementFactory.getPlatformMBeanServer();
            }
        });
        return value;
    }

    public static MBeanServer findWebLogicRuntimeMBeanServer(String jndiName) throws Exception {
        String METHOD_NAME = "findWebLogicRuntimeMBeanServer";
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            MBeanServer mBeanServer = (MBeanServer)ctx.lookup(jndiName);
            return mBeanServer;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                DMSUtil.logp(LOGGER, Level.FINE, CLASS_NAME, "findWebLogicRuntimeMBeanServer", "DMS-50980", new String[]{jndiName}, e);
            }
            throw e;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static MBeanServer getMBeanServer() {
        String METHOD_NAME = "getMBeanServer";
        Platform platform = PlatformSupportFactory.getPlatformSupport().getPlatform();
        MBeanServer mbeanServer = null;
        switch (platform) {
            case WebLogic: 
            case WebLogicAS: 
            case WebSphere: 
            case WebSphereND: 
            case WebSphereAS: {
                try {
                    PortableMBeanFactory portableMBeanFactory = new PortableMBeanFactory();
                    mbeanServer = portableMBeanFactory.getPrivilegedMBeanServer();
                }
                catch (NoClassDefFoundError e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.logp(Level.FINE, CLASS_NAME, "getMBeanServer", "DMS-50700", e);
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.logp(Level.FINE, CLASS_NAME, "getMBeanServer", "DMS-50700", e);
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break;
                    LOGGER.logp(Level.INFO, CLASS_NAME, "getMBeanServer", "DMS-50700", e);
                }
                break;
            }
        }
        if (mbeanServer == null) {
            switch (platform) {
                case WebLogic: 
                case WebLogicAS: {
                    try {
                        mbeanServer = MBeanServerSupport.findWebLogicRuntimeMBeanServer(JNDI_RUNTIME);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.logp(Level.FINE, CLASS_NAME, "getMBeanServer", "DMS-50700", e);
                    }
                    break;
                }
            }
        }
        if (mbeanServer == null) {
            mbeanServer = MBeanServerSupport.getPlatformMBeanServer();
        }
        return mbeanServer;
    }
}

