/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.ClockManager;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;

public class RollupSensor
extends Sensor {
    private static final byte STATE = 0;
    private static final byte EVENT = 1;
    private static final byte PHASE_EVENT = 2;
    private static final String STATE_NAME = "State";
    private static final String EVENT_NAME = "Event";
    private static final String PHASE_EVENT_NAME = "PhaseEvent";
    private static final int MAX_COUNT = 6;
    private static int[] s_max = new int[3];
    private byte m_type;
    private byte m_state_type;
    private String m_units = null;
    private int m_count;
    private int m_derived = 0;
    private double m_avg = 0.0;
    private Number m_sum;
    private Number m_max;
    private Number m_min;
    private long m_time = 0L;
    private int m_active = 0;

    private RollupSensor() {
    }

    private RollupSensor(Noun parent, Sensor sensor, byte type) {
        super(parent, sensor.getName(), "rollup sensor for " + sensor.getName());
        this.m_type = type;
        this.m_count = sensor.getDescriptor().getMetricCount();
        switch (type) {
            case 0: {
                this.createStateMetrics((State)sensor);
                break;
            }
            case 1: {
                this.createEventMetrics((Event)sensor);
                break;
            }
            case 2: {
                this.createPhaseEventMetrics((PhaseEvent)sensor);
            }
        }
    }

    private void createStateMetrics(State state) {
        Object mdesc = null;
        Metric met = state.getMetric(1);
        if (met == null) {
            return;
        }
        this.m_units = met.getUnits();
        this.m_state_type = state.getValueType();
        this._metrics[4] = Metric.create(this._name + ".sum", this._description, this.m_units, this, false, this.m_state_type, (byte)4);
        this._metrics[5] = Metric.create(this._name + ".avg", this._description, this.m_units, this, false, (byte)1, (byte)5);
        met = state.getMetric(8);
        if (met != null) {
            this._metrics[3] = Metric.create(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, (byte)3);
            this.m_derived |= 8;
        }
        if ((met = state.getMetric(4)) != null) {
            this._metrics[2] = Metric.create(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, (byte)2);
            this.m_derived |= 4;
        }
    }

    private void createEventMetrics(Event event) {
        this._metrics[4] = Metric.create(this._name + ".sum", this._description, "ops", this, false, (byte)3, (byte)4);
        this._metrics[5] = Metric.create(this._name + ".avg", this._description, "ops", this, false, (byte)1, (byte)5);
    }

    private void createPhaseEventMetrics(PhaseEvent pe) {
        this.m_units = ClockManager.getUnits(DMSConsole.UNITS);
        Metric met = null;
        this._metrics[0] = Metric.create(this._name + ".time", this._description, this.m_units, this, false, (byte)2, (byte)0);
        met = pe.getMetric(4);
        if (met != null) {
            this._metrics[2] = Metric.create(this._name + ".minTime", this._description, this.m_units, this, false, (byte)2, (byte)2);
            this.m_derived |= 4;
        }
        if ((met = pe.getMetric(8)) != null) {
            this._metrics[3] = Metric.create(this._name + ".maxTime", this._description, this.m_units, this, false, (byte)2, (byte)3);
            this.m_derived |= 8;
        }
        if ((met = pe.getMetric(2)) != null) {
            this._metrics[1] = Metric.create(this._name + ".completed", this._description, "ops", this, false, (byte)3, (byte)1);
            this.m_derived |= 2;
        }
        if ((met = pe.getMetric(32)) != null && this._metrics[1] != null) {
            this._metrics[5] = Metric.create(this._name + ".avg", this._description, this.m_units, this, false, (byte)1, (byte)5);
            this.m_derived |= 0x20;
        }
        if ((met = pe.getMetric(64)) != null) {
            this._metrics[6] = Metric.create(this._name + ".active", this._description, "threads", this, false, (byte)3, (byte)6);
            this.m_derived |= 0x40;
        }
    }

    protected static RollupSensor create(Noun parent, Sensor sensor) {
        EventReportingManager eMgr;
        String stype = null;
        byte type = 0;
        if (sensor == null || (stype = sensor.getDescriptor().getType()) == null) {
            return null;
        }
        if (stype.equals(EVENT_NAME)) {
            type = 1;
        } else if (stype.equals(PHASE_EVENT_NAME)) {
            type = 2;
        } else if (stype.equals(STATE_NAME)) {
            type = 0;
            if (((State)sensor).getValueType() == 5) {
                return null;
            }
        } else {
            return null;
        }
        RollupSensor rollupSensor = new RollupSensor(parent, sensor, type);
        if (rollupSensor._refresh == null && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(rollupSensor, EventSourceType.ROLLUP_SENSOR, EventActionType.CREATE, rollupSensor.mCreateTime, null, null);
        }
        return rollupSensor;
    }

    protected void update(Noun[] nouns, String noun_type) {
        switch (this.m_type) {
            case 0: {
                this.updateState(nouns, noun_type);
                break;
            }
            case 1: {
                this.updateEvent(nouns, noun_type);
                break;
            }
            case 2: {
                this.updatePhaseEvent(nouns, noun_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(Noun[] nouns, String type) {
        Metric met = null;
        Number val = null;
        int count = 0;
        double total = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double minval = 0.0;
        double maxval = 0.0;
        for (int i = 0; i < nouns.length; ++i) {
            if (!type.equals(nouns[i].getType())) continue;
            ++count;
            State state = (State)nouns[i].getSensor(this._name);
            if (state == null) continue;
            met = state.getMetric(1);
            val = (Number)state.getValue(met);
            total += val.doubleValue();
            met = state.getMetric(4);
            if (met != null && (minval = (val = (Number)state.getValue(met)).doubleValue()) < min) {
                min = minval;
            }
            if ((met = state.getMetric(8)) == null || !((maxval = (val = (Number)state.getValue(met)).doubleValue()) > max)) continue;
            max = maxval;
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            switch (this.m_state_type) {
                case 3: {
                    this.m_sum = (int)total;
                    if (this._metrics[2] != null) {
                        this.m_min = (int)min;
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = (int)max;
                    break;
                }
                case 2: {
                    this.m_sum = (long)total;
                    if (this._metrics[2] != null) {
                        this.m_min = (long)min;
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = (long)max;
                    break;
                }
                case 1: {
                    this.m_sum = total;
                    if (this._metrics[2] != null) {
                        this.m_min = min;
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = max;
                }
            }
            this.m_avg = total / (double)count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEvent(Noun[] nouns, String type) {
        Event e = null;
        int total = 0;
        int count = 0;
        Integer val = null;
        for (int i = 0; i < nouns.length; ++i) {
            e = (Event)nouns[i].getSensor(this._name);
            if (e == null) continue;
            val = (Integer)e.getValue();
            total += val.intValue();
            ++count;
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            this.m_sum = total;
            this.m_avg = (double)total / (double)count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePhaseEvent(Noun[] nouns, String type) {
        PhaseEvent pe = null;
        long totalTime = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        int totalActive = 0;
        int totalCompleted = 0;
        Number val = null;
        long time = 0L;
        for (int i = 0; i < nouns.length; ++i) {
            pe = (PhaseEvent)nouns[i].getSensor(this._name);
            if (pe == null) continue;
            val = (Long)pe.getValue(1);
            totalTime += val.longValue();
            val = (Integer)pe.getValue(2);
            if (val != null) {
                totalCompleted += val.intValue();
            }
            if ((val = (Integer)pe.getValue(64)) != null) {
                totalActive += val.intValue();
            }
            if ((val = (Long)pe.getValue(4)) != null && (time = val.longValue()) < minTime) {
                minTime = time;
            }
            if ((val = (Long)pe.getValue(8)) == null || (time = val.longValue()) <= maxTime) continue;
            maxTime = time;
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            this.m_time = totalTime;
            this.m_sum = totalCompleted;
            this.m_active = totalActive;
            this.m_min = minTime;
            this.m_max = maxTime;
            if (totalCompleted > 0 && (this.m_derived & 0x20) == 32) {
                this.m_avg = (double)totalTime / (double)totalCompleted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException("DMS-50750");
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte index = metric.getIndex();
        if (this._metrics[index] != metric) {
            throw new InstrumentationException("DMS-50751", metric.toString(), this.toString());
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 4: {
                    return this.m_sum;
                }
                case 0: {
                    return this.m_time;
                }
                case 1: {
                    return this.m_sum;
                }
                case 2: {
                    return this.m_min;
                }
                case 3: {
                    return this.m_max;
                }
                case 6: {
                    return this.m_active;
                }
                case 5: {
                    return this.m_avg;
                }
            }
        }
        return null;
    }

    @Override
    EventSourceType getSourceType() {
        return EventSourceType.ROLLUP_SENSOR;
    }

    @Override
    public void deriveMetric(int met) {
        EventReportingManager eMgr;
        if (!this._alive) {
            return;
        }
        int toDerive = (met | this.m_derived) ^ this.m_derived;
        if (toDerive == 0) {
            return;
        }
        if (this.m_type == 1) {
            return;
        }
        boolean derived = false;
        if (this.m_type == 0) {
            if ((toDerive & 4) != 0) {
                this._metrics[2] = Metric.create(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, (byte)2);
                this.m_derived |= 4;
                derived = true;
            }
            if ((toDerive & 8) != 0) {
                this._metrics[3] = Metric.create(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, (byte)3);
                this.m_derived |= 8;
                derived = true;
            }
        }
        if (this.m_type == 2) {
            if ((toDerive & 4) != 0) {
                this._metrics[2] = Metric.create(this._name + ".minTime", this._description, this.m_units, this, false, (byte)2, (byte)2);
                this.m_derived |= 4;
                derived = true;
            }
            if ((toDerive & 8) != 0) {
                this._metrics[3] = Metric.create(this._name + ".maxTime", this._description, this.m_units, this, false, (byte)2, (byte)3);
                this.m_derived |= 8;
                derived = true;
            }
            if ((toDerive & 2) != 0) {
                this._metrics[1] = Metric.create(this._name + ".completed", this._description, "ops", this, false, (byte)3, (byte)1);
                this.m_derived |= 2;
                derived = true;
            }
            if ((toDerive & 0x20) != 0 && this._metrics[1] != null) {
                this._metrics[5] = Metric.create(this._name + ".avg", this._description, this.m_units, this, false, (byte)1, (byte)5);
                this.m_derived |= 0x20;
                derived = true;
            }
            if ((toDerive & 0x40) != 0) {
                this._metrics[6] = Metric.create(this._name + ".active", this._description, "threads", this, false, (byte)3, (byte)6);
                this.m_derived |= 0x40;
                derived = true;
            }
        }
        if (derived && (eMgr = EventSystem.getEventReportingManager()) != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.METRIC_SELECTION_CHANGED)) {
            eMgr.reportEvent(this, EventSourceType.ROLLUP_SENSOR, EventActionType.METRIC_SELECTION_CHANGED, this._lastUpdate, null, null);
        }
    }

    protected void updateMetrics(Sensor sensor) {
        if (this.m_type != 0 && this.m_type != 2) {
            return;
        }
        SensorDescriptor desc = sensor.getDescriptor();
        int count = desc.getMetricCount();
        SensorDescriptor my_desc = this.getDescriptor();
        int my_count = my_desc.getMetricCount();
        String[] mnames = null;
        int toDerive = 0;
        if (this.m_type == 0) {
            if (my_count == count + 1) {
                return;
            }
            mnames = desc.getMetricNames();
            for (int i = 0; i < mnames.length; ++i) {
                if (mnames[i].endsWith("minValue")) {
                    toDerive |= 4;
                }
                if (!mnames[i].endsWith("maxValue")) continue;
                toDerive |= 8;
            }
            this.deriveMetric(toDerive);
            return;
        }
        if (my_count == count || my_count == 6) {
            return;
        }
        mnames = desc.getMetricNames();
        for (int i = 0; i < mnames.length; ++i) {
            if (mnames[i].endsWith("minTime")) {
                toDerive |= 4;
            }
            if (mnames[i].endsWith("maxTime")) {
                toDerive |= 8;
            }
            if (mnames[i].endsWith("completed")) {
                toDerive |= 2;
            }
            if (mnames[i].endsWith("active")) {
                toDerive |= 0x40;
            }
            if (!mnames[i].endsWith("avg")) continue;
            toDerive |= 0x20;
        }
        this.deriveMetric(toDerive);
    }

    @Override
    public void reset() {
    }

    static {
        RollupSensor.s_max[0] = 3;
        RollupSensor.s_max[1] = 1;
        RollupSensor.s_max[2] = 7;
    }
}

