/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dms.producer.ColumnInfo;
import oracle.dms.producer.RowInfo;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletOptions;
import oracle.dms.spy.ErrorObject;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Indentation;

public class MBeanTreeletNode
extends BranchTreeletNode<RowInfo> {
    private HashMap<String, Serializable> m_columnValues = new HashMap();

    public MBeanTreeletNode(RowInfo rowInfo) {
        super(rowInfo);
    }

    public MBeanTreeletNode(RowInfo rowInfo, MBeanTreeletNode domain) {
        super(rowInfo.getObjectName().getCanonicalName(), domain, rowInfo);
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_columnValues.clear();
    }

    @Override
    public String getTable() {
        return ((RowInfo)this.getNode()).getTableName();
    }

    Serializable getObjectValue(String name) {
        return this.m_columnValues.get(name);
    }

    public void addColumnValues(Map<String, Serializable> columnValues) {
        if (columnValues == null) {
            return;
        }
        this.m_columnValues.putAll(columnValues);
    }

    @Override
    public String toString() {
        if (this.m_mappedNode == null) {
            return this.m_name;
        }
        return ((RowInfo)this.m_mappedNode).getObjectName().getCanonicalName();
    }

    @Override
    protected void startPrintNode(TreeletOptions options, PrintWriter out) {
        String format = options.getFormat();
        if ("pdml".equals(format)) {
            this._printPdml(options, out);
        } else {
            this._printRaw(options, out);
        }
    }

    @Override
    protected void endPrintNode(TreeletOptions options, PrintWriter out) {
    }

    private void _printPdml(TreeletOptions options, PrintWriter out) {
        out.print("<mbean name='");
        out.print(this.getName());
        out.print("' type='");
        out.print(this.getTable());
        out.print("'>\n");
        for (Map.Entry<String, ColumnInfo> entry : ((RowInfo)this.getNode()).getColumnInfos().entrySet()) {
            String name = entry.getKey();
            ColumnInfo attri = entry.getValue();
            out.print("<attribute name='");
            out.print(name);
            String description = null;
            if (options.includeDescriptions()) {
                description = attri.getDescription();
            }
            String unit = null;
            if (options.includeUnits()) {
                unit = attri.getUnit();
            }
            if (description != null || unit != null || options.includeValues()) {
                out.print("'>\n");
                if (unit != null) {
                    out.print('<');
                    out.print("unit");
                    out.print("><![CDATA[");
                    out.print(DMSUtil.xmlEscape(unit));
                    out.print("]]></");
                    out.print("unit");
                    out.print(">\n");
                }
                if (description != null) {
                    out.print('<');
                    out.print("description");
                    out.print("><![CDATA[");
                    out.print(DMSUtil.xmlEscape(description));
                    out.print("]]></");
                    out.print("description");
                    out.print(">\n");
                }
                if (options.includeValues()) {
                    Serializable metricValue = this.m_columnValues.get(name);
                    if (metricValue == null) {
                        out.print("<null/>\n");
                    } else if (metricValue instanceof ErrorObject) {
                        out.print("<error/>\n");
                    } else {
                        out.print("<value type='");
                        out.print(TreeletNode.getValueType(metricValue));
                        out.print("'><![CDATA[");
                        out.print(DMSUtil.xmlEscape(metricValue.toString()));
                        out.print("]]></value>\n");
                    }
                }
                out.print("</attribute>\n");
                continue;
            }
            out.print("'/>\n");
        }
        out.print("</mbean>\n");
    }

    private void _printRaw(TreeletOptions options, PrintWriter out) {
        Indentation indent = options.getIndentation();
        indent.indent(out);
        out.print(this.toString());
        out.print(" [type=");
        out.print(this.getTable());
        out.println(']');
        TreeMap<String, ColumnInfo> sortedMap = new TreeMap<String, ColumnInfo>(((RowInfo)this.getNode()).getColumnInfos());
        for (Map.Entry<String, ColumnInfo> entry : sortedMap.entrySet()) {
            String name = entry.getKey();
            ColumnInfo attri = entry.getValue();
            options.getIndentation().increIndent();
            indent.indent(out);
            out.print(name);
            out.print(":\t");
            Serializable metricValue = this.m_columnValues.get(name);
            if (metricValue instanceof ErrorObject) {
                out.println(DMSNLSupport.getString("NO_VALUE"));
            } else {
                out.print(metricValue);
                String unit = attri.getUnit();
                if (unit != null) {
                    out.print('\t');
                    out.println(unit);
                } else {
                    out.println();
                }
            }
            options.getIndentation().decreIndent();
        }
    }
}

