/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DmsThreadFactory
implements ThreadFactory {
    private AtomicInteger m_threadNumber = new AtomicInteger(1);
    private final ClassLoader m_ccl = Thread.currentThread().getContextClassLoader();
    private final AccessControlContext m_acc = AccessController.getContext();
    private static final String DMS_THREAD = "DmsThread-";

    @Override
    public Thread newThread(final Runnable r) {
        final Runnable runnalbe = new Runnable(){

            @Override
            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Thread.currentThread().setContextClassLoader(DmsThreadFactory.this.m_ccl);
                        r.run();
                        return null;
                    }
                }, DmsThreadFactory.this.m_acc);
            }
        };
        Thread tt = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread t = new Thread(runnalbe, DmsThreadFactory.DMS_THREAD + DmsThreadFactory.this.m_threadNumber.getAndIncrement());
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        }, this.m_acc);
        return tt;
    }
}

