/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigResourceBundle;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfig;
import oracle.dms.console.DMSError;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.LoggerFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.SensorFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.context.DMSContextManager;
import oracle.dms.event.Destination;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSourceTypeFilter;
import oracle.dms.event.EventSystem;
import oracle.dms.event.impl.EventManagerImpl;
import oracle.dms.http.SimpleRequest;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.EventFactory;
import oracle.dms.instrument.LoggerFactory;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounFactory;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventFactory;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorFactory;
import oracle.dms.instrument.StateFactory;
import oracle.dms.instrument.internal.ActivationParameterFactoryImpl;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SimpleAgency;
import oracle.dms.spy.Spy;
import oracle.dms.spy.jvm.MgmtStats;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportBasic;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.Time;

public class DMSConsole
extends oracle.dms.console.DMSConsole {
    public static final int NONE = 0;
    public static final int NORMAL = 5;
    public static final int HEAVY = 10;
    public static final int ALL = Integer.MAX_VALUE;
    private static int SENSOR_WEIGHT = 5;
    public static long UNITS = 1000L;
    private static Clock _clock = null;
    private static Config s_config = null;
    public static final int PRE_INIT = 0;
    public static final int ACTIVE = 1;
    public static final int SHUTDOWN = 2;
    public static final int INCONSISTENT = 3;
    private static volatile int _status = 0;
    private static EventFactoryIntf sEventFactory = null;
    private static NounFactoryIntf sNounFactory = null;
    private static PhaseEventFactoryIntf sPhaseEventFactory = null;
    private static SensorFactoryIntf sSensorFactory = null;
    private static StateFactoryIntf sStateFactory = null;
    private static LoggerFactoryIntf sLoggerFactory = null;
    private static ActivationParameterFactory sActivationParameterFactory = null;
    private static final String CLASS_NAME = DMSConsole.class.getName();
    private static final Logger LOGGER_TRACE = Logger.getLogger("oracle.dms.config", ConfigResourceBundle.class.getName());
    static Logger s_logger = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");
    public static final int UNKNOWN_INTEGER = -1;

    @Override
    @Deprecated
    public EventFactoryIntf newEventFactory() {
        sEventFactory = new EventFactory();
        return sEventFactory;
    }

    @Override
    @Deprecated
    public NounFactoryIntf newNounFactory() {
        sNounFactory = new NounFactory();
        return sNounFactory;
    }

    @Override
    @Deprecated
    public PhaseEventFactoryIntf newPhaseEventFactory() {
        sPhaseEventFactory = new PhaseEventFactory();
        return sPhaseEventFactory;
    }

    @Override
    @Deprecated
    public SensorFactoryIntf newSensorFactory() {
        sSensorFactory = new SensorFactory();
        return sSensorFactory;
    }

    @Override
    @Deprecated
    public StateFactoryIntf newStateFactory() {
        sStateFactory = new StateFactory();
        return sStateFactory;
    }

    @Override
    @Deprecated
    public LoggerFactoryIntf newLoggerFactory() {
        sLoggerFactory = new LoggerFactory();
        return sLoggerFactory;
    }

    @Override
    public EventFactoryIntf getEventFactory() {
        return sEventFactory;
    }

    @Override
    public NounFactoryIntf getNounFactory() {
        return sNounFactory;
    }

    @Override
    public PhaseEventFactoryIntf getPhaseEventFactory() {
        return sPhaseEventFactory;
    }

    @Override
    public SensorFactoryIntf getSensorFactory() {
        return sSensorFactory;
    }

    @Override
    public StateFactoryIntf getStateFactory() {
        return sStateFactory;
    }

    @Override
    public LoggerFactoryIntf getLoggerFactory() {
        return sLoggerFactory;
    }

    @Override
    public void setProcessID(int pid) {
        DMSUtil.setProcessID(pid);
    }

    @Override
    public void setProcessID(String uid) {
        DMSUtil.setProcessID(uid);
    }

    @Override
    public String getProcessID() {
        return DMSUtil.getProcessID();
    }

    @Override
    public Config getConfig() {
        return s_config;
    }

    @Override
    public void init(String name) throws DMSError {
        this.init(name, null);
    }

    @Override
    public void init(String name, Properties properties) throws DMSError {
        this.init(name, properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String name, Properties properties, boolean loadConfig) throws DMSError {
        String METHOD_NAME = "init";
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, this.getClass().getName(), "init", "DMSConsole is being initialized at {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
        Platform serverType = platformSupport.getPlatform();
        Class<DMSConsole> clazz = DMSConsole.class;
        synchronized (DMSConsole.class) {
            if (_status == 1) {
                if (name != null && name.length() > 0) {
                    Spy.setName(name, true);
                    if (platformSupport instanceof PlatformSupportBasic) {
                        ((PlatformSupportBasic)platformSupport).setServerName(name);
                    }
                }
                if (loadConfig && s_config == null) {
                    DMSConsole._loadConfiguration();
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            if (name == null || name.length() == 0) {
                name = platformSupport.getServerName();
            } else if (platformSupport instanceof PlatformSupportBasic) {
                ((PlatformSupportBasic)platformSupport).setServerName(name);
            }
            switch (serverType) {
                case WebSphere: 
                case WebSphereAS: 
                case WebSphereND: {
                    MgmtStats.enableMemoryStats(false);
                    break;
                }
            }
            try {
                if (sActivationParameterFactory == null) {
                    sActivationParameterFactory = new ActivationParameterFactoryImpl();
                }
                DMSConsole.initClock(properties);
                PhaseEvent.init(_clock);
                DMSConsole.initWeight();
                Spy.init(name, properties);
                _status = 1;
                DMSContextManager.init(DMSContextManager.InitOptions.create(true));
                EventConfigManager eventManager = EventSystem.getEventConfigManager();
                if (eventManager == null) {
                    eventManager = new EventManagerImpl();
                    EventSystem.setEventManagers(eventManager, null);
                    DMSConsole.registerEventListeners(eventManager);
                }
                if (sEventFactory == null) {
                    sEventFactory = new EventFactory();
                }
                if (sNounFactory == null) {
                    sNounFactory = new NounFactory();
                }
                if (sPhaseEventFactory == null) {
                    sPhaseEventFactory = new PhaseEventFactory();
                }
                if (sSensorFactory == null) {
                    sSensorFactory = new SensorFactory();
                }
                if (sStateFactory == null) {
                    sStateFactory = new StateFactory();
                }
                if (sLoggerFactory == null) {
                    sLoggerFactory = new LoggerFactory();
                }
            }
            catch (Exception e) {
                throw new DMSError(e);
            }
            if (loadConfig && s_config == null) {
                DMSConsole._loadConfiguration();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setName(String name) {
        Spy.setName(name);
    }

    @Override
    public String getName() {
        return Spy.getName();
    }

    @Override
    public Object getMetricValue(String name) {
        return Spy.getMetricValue(name);
    }

    @Override
    public void exit() {
        ShutdownOptions options = ShutdownOptions.getDefaultOptions();
        this.exit(options);
    }

    @Override
    @Deprecated
    public void exit(boolean dumpResults) {
        ShutdownOptions options = ShutdownOptions.create(dumpResults, DMSContextManager.ShutdownOptions.getDefaultOptions());
        this.exit(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void exit(ShutdownOptions options) {
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.log(Level.FINE, "DMSConsole is being exit'd at {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        Class<DMSConsole> clazz = DMSConsole.class;
        synchronized (DMSConsole.class) {
            if (_status == 2) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            _status = 2;
            if (options.getDumpMetricsToFile()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Spy.exit();
                        return null;
                    }
                });
            } else {
                Spy.exit(false);
            }
            sEventFactory = null;
            sNounFactory = null;
            sPhaseEventFactory = null;
            sSensorFactory = null;
            sStateFactory = null;
            sLoggerFactory = null;
            Noun.shutdown();
            PhaseEvent.shutdown();
            Sensor.shutdown();
            ClockManager.shutdown();
            EventConfigManager eventManager = EventSystem.getEventConfigManager();
            if (eventManager != null) {
                eventManager.shutdown();
            }
            EventSystem.setEventManagers(null, null);
            DMSContextManager.shutdown(options.getContextManagerOptions());
            if (s_config != null) {
                s_config.close();
                s_config = null;
            }
            _clock = null;
            SENSOR_WEIGHT = 5;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isActive() {
        return _status == 1;
    }

    @Override
    @Deprecated
    public void setDumpFile(String name) {
        Spy.setDumpFile(name);
    }

    @Override
    @Deprecated
    public String getDumpFile() {
        return Spy.getDumpFile();
    }

    @Override
    @Deprecated
    public void dump() {
        Spy.dump();
    }

    @Override
    @Deprecated
    public void dump(String filename, boolean pretty, boolean append) {
        Spy.dump(filename, pretty, append);
    }

    @Override
    @Deprecated
    public void dump(PrintWriter pw, boolean pretty) throws IOException {
        Spy.dump(pw, pretty);
    }

    @Override
    public void dump(PrintWriter pw, String format) {
        Noun.getRoot().dump(pw, format);
    }

    @Override
    public void dump(String filename, String format, boolean append) {
        Noun.getRoot().dump(filename, format, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(PrintWriter pw, String queryString) {
        if (queryString == null || queryString.trim().length() == 0 || pw == null) {
            return;
        }
        SimpleAgency agency = new SimpleAgency();
        SimpleRequest request = new SimpleRequest();
        Reporter reporter = null;
        try {
            request.parseQueryStrings(queryString);
            reporter = agency.getReporter(request);
            reporter.printResponse(pw);
        }
        finally {
            if (reporter != null) {
                reporter.clear();
            }
        }
    }

    private static synchronized void initWeight() {
        block8: {
            String weight = null;
            try {
                weight = DMSProperties.getProperty("oracle.dms.sensors");
                if (weight == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            try {
                SENSOR_WEIGHT = Integer.parseInt(weight);
            }
            catch (Exception e) {
                if (weight.equalsIgnoreCase("ALL")) {
                    SENSOR_WEIGHT = Integer.MAX_VALUE;
                }
                if (weight.equalsIgnoreCase("NONE")) {
                    SENSOR_WEIGHT = 0;
                }
                if (weight.equalsIgnoreCase("NORMAL")) {
                    SENSOR_WEIGHT = 5;
                }
                if (!weight.equalsIgnoreCase("HEAVY")) break block8;
                SENSOR_WEIGHT = 10;
            }
        }
    }

    public static synchronized boolean setSensorWeightOff() {
        if (_clock != null) {
            return false;
        }
        SENSOR_WEIGHT = 0;
        return true;
    }

    public static int getSensorWeight() {
        return SENSOR_WEIGHT;
    }

    private static synchronized void initClock(Properties props) {
        if (_clock != null) {
            return;
        }
        String clockname = null;
        String units = null;
        String enforceIncreasingTime = null;
        if (props != null) {
            clockname = props.getProperty("oracle.dms.clock");
            units = props.getProperty("oracle.dms.clock.units");
            enforceIncreasingTime = props.getProperty("oracle.dms.time.enforceNonDecreasingTime");
        }
        if (clockname == null) {
            clockname = DMSProperties.getProperty("oracle.dms.clock");
        }
        if (units == null) {
            units = DMSProperties.getProperty("oracle.dms.clock.units");
        }
        if (enforceIncreasingTime == null) {
            enforceIncreasingTime = DMSProperties.getProperty("oracle.dms.time.enforceNonDecreasingTime", "false");
        }
        Time.setEnforceNonDecreasingTime("true".equals(enforceIncreasingTime));
        if (clockname == null) {
            clockname = "default";
        }
        _clock = ClockManager.setClock(clockname);
        UNITS = units == null || _clock.getName().equals("logical") ? _clock.getReportedFrequency() : ClockManager.getFrequency(units);
    }

    public static synchronized Clock getClock() {
        if (_clock == null) {
            DMSConsole.initClock(null);
        }
        return _clock;
    }

    @Override
    public void debug(String msg) {
        DMSConsole._debug(msg);
    }

    public static void _debug(String msg) {
        System.err.println("<DMSDEBUG> " + msg + " </DMSDEBUG>");
    }

    public static synchronized int getStatus() {
        if (_status == 0 || _status == 2) {
            if (Spy.isActive()) {
                return 3;
            }
            if (_clock != null || sEventFactory != null || sPhaseEventFactory != null || sSensorFactory != null || sStateFactory != null || sLoggerFactory != null || sNounFactory != null) {
                return 3;
            }
            return _status;
        }
        if (_status == 1) {
            if (!Spy.isActive() || Noun.getRoot() == null) {
                return 3;
            }
            if (_clock == null) {
                return 3;
            }
            return _status;
        }
        return 3;
    }

    private static void registerEventListeners(EventConfigManager eventManager) {
        ArrayList destinationList;
        block4: {
            String METHOD_NAME = "registerEventListeners";
            String classNames = DMSProperties.getProperty("oracle.dms.event.defaultListeners");
            destinationList = new ArrayList();
            try {
                ClassUtils.getClassInstances(classNames, Destination.class, destinationList);
            }
            catch (RuntimeException re) {
                if (!s_logger.isLoggable(Level.WARNING)) break block4;
                s_logger.logp(Level.WARNING, CLASS_NAME, "registerEventListeners", re.getMessage());
            }
        }
        if (destinationList.size() > 0) {
            EventSourceTypeFilter f = new EventSourceTypeFilter("DMSConsole EventListener filter.", "oracle.dms.instrument.DMSConsole-instrumentationNodeFilter", new EventSourceType[]{EventSourceType.INSTRUMENTATION_NODE});
            for (Destination d : destinationList) {
                eventManager.associateInternalFilterWithDestination(f, d);
            }
        }
    }

    private static synchronized void _loadConfiguration() {
        block9: {
            String METHOD_NAME = "_loadConfiguration";
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, CLASS_NAME, "_loadConfiguration", "DMSConsole is loading the configuration");
            }
            if (s_config != null) {
                return;
            }
            PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
            String configFilename = platformSupport.getConfigFilename();
            if (configFilename != null && configFilename.length() > 0) {
                try {
                    s_config = new Config(configFilename, null);
                    s_config.setRuntime(true);
                    s_config.getEventConfig().activateConfiguration();
                    String deprecatedProperties = DMSProperties.deprecatedSystemPropertiesSet();
                    if (deprecatedProperties != null) {
                        LOGGER_TRACE.logrb(Level.WARNING, CLASS_NAME, "_loadConfiguration", "oracle.dms.config.ConfigResourceBundle", "DMS-58078", (Object[])new String[]{deprecatedProperties});
                    }
                    DMSProperties.setParamConfig(s_config.getParamConfig());
                    ParamScopedMetricsConfig psmc = s_config.getParamScopedMetricsConfig();
                    if (psmc != null) {
                        ParamScopedMetricsConfig.makeConfigActiveInRuntime(psmc);
                        ParamScopedMetricsConfig.setCurrentParamScopedMetricsConfig(psmc);
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (LOGGER_TRACE.isLoggable(Level.FINE)) {
                        LOGGER_TRACE.logp(Level.FINE, CLASS_NAME, "_loadConfiguration", "DMS-58021", new String[]{configFilename});
                        LOGGER_TRACE.logp(Level.FINE, CLASS_NAME, "_loadConfiguration", "DMS-58042", e);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER_TRACE.isLoggable(Level.WARNING)) break block9;
                    LOGGER_TRACE.logp(Level.WARNING, CLASS_NAME, "_loadConfiguration", "DMS-58021", new String[]{configFilename});
                    LOGGER_TRACE.logp(Level.WARNING, CLASS_NAME, "_loadConfiguration", "DMS-58042", e);
                }
            }
        }
    }

    public static ActivationParameterFactory getActivationParameterFactory() {
        return sActivationParameterFactory;
    }

    @Deprecated
    public static class ShutdownOptions {
        private boolean mDumpMetricsToFile = false;
        private DMSContextManager.ShutdownOptions mDMSContextManagerShutdownOptions;

        private ShutdownOptions() {
        }

        public static ShutdownOptions create(boolean dumpMetricsToFile, DMSContextManager.ShutdownOptions contextManagerShutdownOptions) {
            if (contextManagerShutdownOptions == null) {
                throw new IllegalArgumentException("DMSContextManager.ShutdownOptions can not be null.");
            }
            ShutdownOptions retVal = new ShutdownOptions();
            retVal.mDumpMetricsToFile = dumpMetricsToFile;
            retVal.mDMSContextManagerShutdownOptions = contextManagerShutdownOptions;
            return retVal;
        }

        public static ShutdownOptions getDefaultOptions() {
            ShutdownOptions retVal = ShutdownOptions.create(true, DMSContextManager.ShutdownOptions.getDefaultOptions());
            return retVal;
        }

        private boolean getDumpMetricsToFile() {
            return this.mDumpMetricsToFile;
        }

        private DMSContextManager.ShutdownOptions getContextManagerOptions() {
            return this.mDMSContextManagerShutdownOptions;
        }
    }
}

