/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.table.ColumnGroup;
import oracle.dms.util.NameSupport;
import oracle.dms.util.NetUtil;

public class ColumnGroupSupport
extends NameSupport
implements ColumnGroup {
    private String m_type = null;
    private String m_description = null;
    private TreeSet<String> m_members = new TreeSet();
    private static final long serialVersionUID = -1150676773410L;

    public ColumnGroupSupport(String name, String type, String description) {
        super(name);
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException(this.getClass().getName() + " column group name=" + name + " column group type=" + type);
        }
        this.m_type = type;
        this.m_description = description;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public int memberCount() {
        return this.m_members.size();
    }

    @Override
    public Enumeration<String> enumerateMemberNames(boolean sorted) {
        return Collections.enumeration(this.m_members);
    }

    public synchronized ColumnGroupSupport clone(boolean includeDescriptions) {
        ColumnGroupSupport clone = null;
        try {
            clone = (ColumnGroupSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (!includeDescriptions) {
            clone.m_description = null;
        }
        clone.m_members = new TreeSet<String>((SortedSet<String>)this.m_members);
        return clone;
    }

    public void addMember(String name) {
        if (name != null && name.trim().length() > 0) {
            this.m_members.add(name);
        }
    }

    public boolean update(ColumnGroupSupport group, boolean updateDescriptions) {
        if (group == null) {
            return false;
        }
        if (updateDescriptions) {
            this.m_description = group.m_description;
        }
        return this.m_members.addAll(group.m_members);
    }

    @Override
    public boolean containsMember(String member) {
        if (member == null || member.trim().length() == 0) {
            return false;
        }
        return this.m_members.contains(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMemberNames() {
        String[] ret = null;
        TreeSet<String> treeSet = this.m_members;
        synchronized (treeSet) {
            ret = new String[this.m_members.size()];
            this.m_members.toArray(ret);
        }
        return ret;
    }

    protected synchronized void close() {
        this.m_members.clear();
    }

    protected void printTbml(PrintWriter out) {
        TbmlReporter.printColumnGroup(this.m_name, this.m_type, this.m_members, this.m_description, out);
    }

    protected int size() {
        int size = 0;
        if (this.m_type != null) {
            size += this.m_type.length();
        }
        if (this.m_description != null) {
            size += this.m_description.length();
        }
        return size += NetUtil.getSize(this.m_members);
    }
}

