/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dms.http.Request;

public class SimpleRequest
extends Request {
    private Hashtable<String, ArrayList<String>> m_params = new Hashtable();

    public void addParameter(String key, String val) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        ArrayList<String> valueVec = this.m_params.get(key = key.toLowerCase());
        if (valueVec == null) {
            valueVec = new ArrayList();
            this.m_params.put(key, valueVec);
        }
        valueVec.add(val);
    }

    public void addParameters(String key, Collection<String> vals) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        ArrayList<String> valueVec = this.m_params.get(key = key.toLowerCase());
        if (valueVec == null) {
            valueVec = new ArrayList();
            this.m_params.put(key, valueVec);
        }
        valueVec.addAll(vals);
    }

    public void removeParameter(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        key = key.toLowerCase();
        this.m_params.remove(key);
    }

    public boolean containsParameter(String key) {
        if (key == null || key.trim().length() == 0) {
            return false;
        }
        key = key.toLowerCase();
        return this.m_params.containsKey(key);
    }

    public Set<String> getParameterNames() {
        return this.m_params.keySet();
    }

    public void parseQueryStrings(String queryStrings) {
        if (queryStrings == null || queryStrings.trim().length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(queryStrings, "&");
        while (tok.hasMoreTokens()) {
            String key;
            String pair = tok.nextToken();
            int index = pair.indexOf(61);
            if (index < 0 || (key = pair.substring(0, index)).length() == 0) continue;
            try {
                key = URLDecoder.decode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            String val = pair.substring(index + 1);
            if (val != null) {
                try {
                    val = URLDecoder.decode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            this.addParameter(key, val);
        }
    }

    @Override
    public String getParameter(String key) {
        if (key == null) {
            return null;
        }
        ArrayList<String> valueVec = this.m_params.get(key = key.toLowerCase());
        if (valueVec == null) {
            return null;
        }
        return valueVec.get(0);
    }

    @Override
    public String getMethod() {
        String method = this.getParameter("operation");
        if (method == null || method.trim().length() == 0) {
            return "get";
        }
        return method;
    }

    @Override
    public String getHeader(String name) {
        return null;
    }

    @Override
    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        ArrayList<String> values = this.m_params.get(name = name.toLowerCase());
        if (values == null) {
            return null;
        }
        String[] ret = new String[values.size()];
        values.toArray(ret);
        return ret;
    }

    @Override
    public String getQueryString() {
        if (this.m_params.size() == 0) {
            return "";
        }
        boolean isFirst = true;
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> entry : this.m_params.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> list = entry.getValue();
            if (list == null || list.size() == 0) continue;
            for (String value : list) {
                if (value == null || value.trim().length() == 0) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('&');
                }
                try {
                    buf.append(URLEncoder.encode(key, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                buf.append('=');
                try {
                    buf.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
        return buf.toString();
    }

    @Override
    public String getServerName() {
        return "unknown";
    }

    @Override
    public int getServerPort() {
        return -666;
    }

    @Override
    public String getRequestedSessionId() {
        return null;
    }

    @Override
    public String getRequestURI() {
        return null;
    }
}

