/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import oracle.dms.util.ClientObjectKey;

public class ClientObjectKeyManager {
    public static final int MAX_ENTRY_COUNT = 3;
    private static EnumMap<ClientObjectHolderType, Integer> sCurrentIndices = new EnumMap(ClientObjectHolderType.class);
    private static EnumMap<ClientObjectHolderType, Map<Object, ClientObjectKey>> sKeyMap = new EnumMap(ClientObjectHolderType.class);

    public static synchronized ClientObjectKey requestClientObjectKey(ClientObjectHolderType holderType, String requestorIdentifier) {
        if (requestorIdentifier == null) {
            throw new IllegalArgumentException("The requestot identifier must not be null.");
        }
        Map<Object, ClientObjectKey> requestorToKeyMap = sKeyMap.get((Object)holderType);
        ClientObjectKey retVal = requestorToKeyMap.get(requestorIdentifier);
        if (retVal == null) {
            Integer currentIndex = sCurrentIndices.get((Object)holderType);
            if (currentIndex < 3) {
                retVal = new ClientObjectKeyImpl(holderType, currentIndex, requestorIdentifier);
                sCurrentIndices.put(holderType, currentIndex + 1);
                requestorToKeyMap.put(requestorIdentifier, retVal);
            }
        } else if (retVal.getClientObjectHolderType() != holderType) {
            throw new IllegalArgumentException("The requestor identifier, " + requestorIdentifier + ", has been used to request a ClientObjectKey for a holderType of " + (Object)((Object)holderType) + ", but the requestor identifer is already associated " + "with a holderType of " + (Object)((Object)retVal.getClientObjectHolderType()));
        }
        return retVal;
    }

    static {
        for (ClientObjectHolderType coht : ClientObjectHolderType.values()) {
            sKeyMap.put(coht, new HashMap(3, 1.0f));
            sCurrentIndices.put(coht, new Integer(0));
        }
    }

    public static class ClientObjectKeyImpl
    implements ClientObjectKey {
        final int mIndex;
        final ClientObjectHolderType mType;
        final String mRequestorIdentifier;
        final String mString;

        ClientObjectKeyImpl(ClientObjectHolderType type, int index, String requestorIdentifier) {
            this.mType = type;
            this.mIndex = index;
            this.mRequestorIdentifier = requestorIdentifier;
            this.mString = "ClientObjectKeyImpl[type:" + (Object)((Object)this.mType) + ", index:" + this.mIndex + ", requestorId:" + this.mRequestorIdentifier + "]";
        }

        @Override
        public int getIndex() {
            return this.mIndex;
        }

        @Override
        public ClientObjectHolderType getClientObjectHolderType() {
            return this.mType;
        }

        public String toString() {
            return this.mString;
        }
    }

    public static enum ClientObjectHolderType {
        SENSOR,
        NOUN,
        NOUN_DESCRIPTOR,
        ACTIVATION_PARAMETER_DESCRIPTOR;

    }
}

