/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.QueryOptions;

public class MultiTableSource
extends TableSource {
    private List<TableSource> m_tableSources = Collections.synchronizedList(new ArrayList());

    public void registerTableSource(TableSource tableSource) {
        if (tableSource != null) {
            this.m_tableSources.add(tableSource);
        }
    }

    public void unregisterTableSource(TableSource tableSource) {
        if (tableSource != null) {
            this.m_tableSources.remove(tableSource);
        }
    }

    public void clear() {
        this.m_tableSources.clear();
    }

    @Override
    public String[] getTableNames(QueryOptions options) {
        HashSet<String> set = new HashSet<String>();
        this.getTableNames(set, options);
        String[] ret = new String[set.size()];
        set.toArray(ret);
        return ret;
    }

    @Override
    public void getTableNames(Collection<String> list, QueryOptions options) {
        if (list == null) {
            return;
        }
        List<TableSource> tableSources = this._cloneTableSources();
        for (TableSource tableSource : tableSources) {
            tableSource.getTableNames(list, options);
        }
    }

    @Override
    public int tableCount(QueryOptions options) {
        List<TableSource> tableSources = this._cloneTableSources();
        int count = 0;
        for (TableSource tableSource : tableSources) {
            count += tableSource.tableCount(options);
        }
        return count;
    }

    @Override
    public Table getTable(String name, QueryOptions options) {
        List<TableSource> tableSources = this._cloneTableSources();
        for (TableSource tableSource : tableSources) {
            Table table = tableSource.getTable(name, options);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    public boolean containsTable(String name, QueryOptions options) {
        List<TableSource> tableSources = this._cloneTableSources();
        for (TableSource tableSource : tableSources) {
            boolean isContain = tableSource.containsTable(name, options);
            if (!isContain) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableSource> _cloneTableSources() {
        ArrayList<TableSource> tableSources = new ArrayList<TableSource>();
        List<TableSource> list = this.m_tableSources;
        synchronized (list) {
            tableSources.addAll(this.m_tableSources);
        }
        return tableSources;
    }
}

