/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.MonitorStatistic;
import oracle.jvmmon.agent.SampleDataProcessor;

class MonitorObjectUsage
implements GroupRefresh {
    static final String NOUN_NAME = "MonitorObjectUsage";
    static final int MAX_ROW = 5;
    static final byte COL_OBJECTID = 0;
    static final byte COL_CLASSNAME = 1;
    static final byte COL_ENTRYCOUNT = 2;
    static final byte COL_MOSTWAITERCOUNT = 3;
    static final byte COL_MOSTNOTIFIEDCOUNT = 4;
    static final byte COL_THREADCOUNF = 5;
    static final byte COL_AVGENTEREDTIME = 6;
    static final byte COL_MAXENTEREDTIME = 7;
    static final byte COL_MINENTEREDTIME = 8;
    static final byte COL_AVGWAIT = 9;
    static final byte COL_MAXWAIT = 10;
    static final byte COL_MINWAIT = 11;
    static final byte COL_TIMEOUTCOUNT = 12;
    static final byte COL_AVGTIMEOUT = 13;
    static final byte COL_MAXTIMEOUT = 14;
    static final byte COL_MINTIMEOUT = 15;
    static final String[] COLUMN_NAMES = new String[]{"ObjectID", "ClassName", "EntryCount", "MostWaiterCount", "MostNotifiedWaiterCount", "ThreadCount", "AvgContentedEnteredTime", "MaxContentedEnteredTime", "MinContentedEnteredTime", "AvgWaitTime", "MaxWaitTime", "MinWaitTime", "TimeoutOccurrence", "AvgTimeout", "MaxTimeout", "MinTimeout"};
    static final String[] COLUMN_DESCS = new String[]{"ID of the contented monitor object", "Class name of the contented monitor object", "The number of times of all thread has entered the monitor", "The number of threads at most waiting to own this monitor", "The number of threads at most waiting to be notified by this monitor", "Number of threads which has used this monitor object", "Average time to take to enter a monitor", "Maximum time to take to enter monitor", "Minimum time to take to enter a monitor", "Average time to wait for the object", "Maximum time to wait for the object", "Minimum time to wait for the object", "Timeout occurrence in waiting for the object", "Average timeout for object.wait", "Maximum timeout for object.wait", "Minimum timeout for object.wait"};
    static final byte[] COLUMN_STATES = new byte[]{2, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static Noun s_baseNoun;
    private static Vector<MonitorObjectUsage> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    MonitorObjectUsage(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/MonitorObjectUsage") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_MonitorObjectUsage");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        MonitorObjectUsage.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new MonitorObjectUsage(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        MonitorStatistic[] mons = this.dataPsr_.getContentedMonitorTable();
        if (mons == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            MonitorObjectUsage usage = s_allStats.elementAt(index);
            block19: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = usage.states_[col];
                if (index >= mons.length) {
                    if (state.getValueType() == 5) {
                        state.update("-NA-");
                        continue;
                    }
                    state.update(0);
                    continue;
                }
                switch (col) {
                    case 0: {
                        state.update(mons[index].getObjectHashcode());
                        continue block19;
                    }
                    case 1: {
                        state.update(mons[index].getClassname());
                        continue block19;
                    }
                    case 2: {
                        state.update(mons[index].getTotalEntryCount());
                        continue block19;
                    }
                    case 3: {
                        state.update(mons[index].getMostWaitCount());
                        continue block19;
                    }
                    case 4: {
                        state.update(mons[index].getMostNotifyWaiterCount());
                        continue block19;
                    }
                    case 5: {
                        state.update(mons[index].getThreadCount());
                        continue block19;
                    }
                    case 6: {
                        state.update(mons[index].getAverageContentedTime());
                        continue block19;
                    }
                    case 7: {
                        state.update(mons[index].getMaxContentedTime());
                        continue block19;
                    }
                    case 8: {
                        state.update(mons[index].getMinContentedTime());
                        continue block19;
                    }
                    case 9: {
                        state.update(mons[index].getAvgWaitedTime());
                        continue block19;
                    }
                    case 10: {
                        state.update(mons[index].getMaxWaitTime());
                        continue block19;
                    }
                    case 11: {
                        state.update(mons[index].getMinWaitTime());
                        continue block19;
                    }
                    case 12: {
                        state.update(mons[index].getTimeoutCount());
                        continue block19;
                    }
                    case 13: {
                        state.update(mons[index].getAvgWaitTimeout());
                        continue block19;
                    }
                    case 14: {
                        state.update(mons[index].getMaxWaitTimeout());
                        continue block19;
                    }
                    case 15: {
                        state.update(mons[index].getMinWaitTimeout());
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

