/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.HeapStatistic;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class HeapSummary
implements GroupRefresh {
    static final String NOUN_NAME = "HeapSummary";
    static final byte COL_OCJCNT = 0;
    static final byte COL_CLSCNT = 1;
    static final byte COL_TOTSIZ = 2;
    static final String[] COLUMN_NAMES = new String[]{"TotalSampleObjectCount", "TotalSampleClassCount", "TotalSampleSize"};
    static final String[] COLUMN_DESCS = new String[]{"Total number of objects from in the samples", "total number of classes from in the samples", "Total size of all objects in the samples"};
    static final byte[] COLUMN_STATES = new byte[]{2, 2, 2};
    private static Noun s_baseNoun;
    private static HeapSummary s_stats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    HeapSummary(Noun baseNoun) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/HeapSummary") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, NOUN_NAME, "JVMMON_HeapSummary");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new HeapSummary(base);
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        HeapStatistic hs = this.dataPsr_.getHeapStatistic();
        if (hs == null) {
            return;
        }
        block5: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
            State state = this.states_[col];
            switch (col) {
                case 1: {
                    state.update(hs.getClassCount());
                    continue block5;
                }
                case 0: {
                    state.update(hs.getInstanceCount());
                    continue block5;
                }
                case 2: {
                    state.update(hs.getTotalSize());
                }
            }
        }
    }

    static void exit() {
        s_stats = null;
        s_baseNoun = null;
    }
}

