/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.GCEvent;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class FullGCEvents
implements GroupRefresh {
    static final String NOUN_NAME = "FullGCEvents";
    static final int MAX_ROW = 5;
    static final byte COL_TIME = 0;
    static final byte COL_ELAPSED = 1;
    static final byte COL_TOTALMEM = 2;
    static final byte COL_FREEMEM = 3;
    static final String[] COLUMN_NAMES = new String[]{"TimeOfOccurrence", "Elapsed", "TotalMemoryAfter", "FreeMemoryAfter"};
    static final String[] COLUMN_DESCS = new String[]{"Time stamp", "Elapsed time", "Approx. total amount of memory in the Java virtual machine.", "Approx. amount of free memory in the Java Virtual Machine."};
    static final byte[] COLUMN_STATES = new byte[]{2, 2, 2, 2};
    private static Noun s_baseNoun;
    private static Vector<FullGCEvents> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    FullGCEvents(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/FullGCEvents") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_FullGCEvents");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        FullGCEvents.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new FullGCEvents(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        GCEvent[] gcEv = this.dataPsr_.getGCStatistics().getFullGCEvents();
        if (gcEv == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            FullGCEvents stat = s_allStats.elementAt(index);
            block7: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = stat.states_[col];
                if (index >= gcEv.length) {
                    if (state.getValueType() == 5) {
                        state.update("-NA-");
                        continue;
                    }
                    state.update(0);
                    continue;
                }
                switch (col) {
                    case 0: {
                        state.update(gcEv[index].getBeginTime());
                        continue block7;
                    }
                    case 1: {
                        state.update(gcEv[index].getElapsedTime());
                        continue block7;
                    }
                    case 2: {
                        state.update(gcEv[index].getTotalMemoryAfter());
                        continue block7;
                    }
                    case 3: {
                        state.update(gcEv[index].getFreeMemoryAfter());
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

