/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.ClassStatComparator;
import oracle.jvmmon.agent.ClassStatistic;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class ClassHistogram
implements GroupRefresh {
    static final String NOUN_NAME = "ClassHistogram";
    static final int MAX_ROW = 10;
    static final byte COL_CLSNAME = 0;
    static final byte COL_SUMELIV = 1;
    static final byte COL_SUMCREA = 2;
    static final byte COL_SUMFREE = 3;
    static final byte COL_TOTALSZ = 4;
    static final byte COL_AVGSIZE = 5;
    static final byte COL_OLDESTA = 6;
    static final byte COL_YOUNGES = 7;
    static final byte COL_AVERAGE = 8;
    static final byte COL_AGEGPCT = 9;
    static final byte COL_STCKCNT = 10;
    static final String[] COLUMN_NAMES = new String[]{"classname", "totalLive", "totalInstCreated", "totalInstFreed", "totalSize", "avgSize", "oldestAge", "youngestAge", "avgAge", "ageGroupCount", "stackTraceCount"};
    static final String[] COLUMN_DESCS = new String[]{"Java  class name", "total number of live instances", "total number of instances have been created", "total number of instances have been freed", "total size of all live instances", "avg size", "oldest age among all live instances", "youngest age among all live instances", "average age among all live instances", "number of age groups", "number of origins of allocations"};
    static final byte[] COLUMN_STATES = new byte[]{5, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3};
    private static Noun s_baseNoun;
    private static Vector<ClassHistogram> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    ClassHistogram(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/ClassHistogram") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_ClassHistogram");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        ClassHistogram.create(base, 10);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new ClassHistogram(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        ClassStatistic[] cs = this.dataPsr_.getClassHistogram(ClassStatComparator.SORT_OPTIONS.LIVECOUNT);
        if (cs == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            ClassHistogram chgm = s_allStats.elementAt(index);
            block14: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = chgm.states_[col];
                switch (col) {
                    case 0: {
                        if (index < cs.length) {
                            state.update(cs[index].getClassname());
                            continue block14;
                        }
                        state.update("-NA-");
                        continue block14;
                    }
                    case 1: {
                        if (index < cs.length) {
                            state.update(cs[index].getLiveInstanceCount());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 2: {
                        if (index < cs.length) {
                            state.update(cs[index].getInstanceCreatedCount());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 3: {
                        if (index < cs.length) {
                            state.update(cs[index].getInstanceFreedCount());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 4: {
                        if (index < cs.length) {
                            state.update(cs[index].getTotalSize());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 5: {
                        if (index < cs.length) {
                            state.update(cs[index].getAverageSize());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 6: {
                        if (index < cs.length) {
                            state.update(cs[index].getOldestInstanceAge());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 7: {
                        if (index < cs.length) {
                            state.update(cs[index].getYoungestInstanceAge());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 8: {
                        if (index < cs.length) {
                            state.update(cs[index].getAverageAge());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 9: {
                        if (index < cs.length) {
                            state.update(cs[index].getAgeGroupCount());
                            continue block14;
                        }
                        state.update(0);
                        continue block14;
                    }
                    case 10: {
                        if (index < cs.length) {
                            state.update(cs[index].getDifferentStackTraceCount());
                            continue block14;
                        }
                        state.update(0);
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

