/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dms.util.TableQueryDescriptor;
import oracle.dms.util.TopoNodeIDInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryOptions
implements Cloneable {
    public static final long NO_TIME_STAMP = 0L;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final String QUERY_TYPE = "oracle.dms.jmx.querytype";
    public static final String QUERY_TIMEOUT = "oracle.dms.jmx.timeout";
    public static final String QUERY_INTERVAL = "oracle.dms.jmx.interval";
    public static final String USE_CACHE = "oracle.dms.jmx.usecache";
    public static final String PRE_FETCH = "oracle.dms.jmx.prefetch";
    private QueryType m_queryType = QueryType.ALL;
    private long m_startTime = Long.MAX_VALUE;
    private long m_endTime = Long.MAX_VALUE;
    private HashMap<String, TableQueryDescriptor> m_descriptors = new HashMap();
    private HashMap<String, Serializable> m_variables = new HashMap();
    private HashSet<String> m_tnIds = new HashSet();
    private HashMap<String, ArrayList<String>> m_properties = new HashMap();
    private int m_interval = 0;
    private UseCache m_useCache = UseCache.CACHE_COPY;
    private int m_timeout = 30000;
    private long m_timestamp = 0L;
    private boolean m_isPrefetch = true;
    private boolean m_dump = false;
    private TopoNodeIDInfo m_topoNodeIdInfo = null;
    private boolean m_isArchiveing = false;

    public QueryOptions() {
    }

    public QueryOptions(QueryType queryType) {
        if (queryType == null) {
            throw new IllegalArgumentException("queryType=" + (Object)((Object)queryType));
        }
        this.m_queryType = queryType;
    }

    public boolean includeSchema() {
        return this.m_queryType.includeSchema();
    }

    public boolean includeRows() {
        return this.m_queryType.includeRows();
    }

    public void setQueryType(QueryType queryType) {
        this.setQueryType(queryType, null);
    }

    public void setQueryType(QueryType queryType, String table) {
        if (queryType == null) {
            throw new IllegalArgumentException("queryType=" + (Object)((Object)queryType));
        }
        if (table == null || table.trim().length() == 0) {
            this.m_queryType = queryType;
            return;
        }
        TableQueryDescriptor desc = this.getTableQueryDescriptor(table);
        if (desc == null) {
            desc = new TableQueryDescriptor(table, queryType);
            this.setTableQueryDescriptor(desc);
        }
    }

    public QueryType getQueryType() {
        return this.m_queryType;
    }

    public QueryType getQueryType(String table) {
        TableQueryDescriptor desc = this.getTableQueryDescriptor(table);
        if (desc == null) {
            return this.m_queryType;
        }
        return desc.getQueryType();
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setHistoricalTime(long startTime, long endTime) {
        if (QueryOptions.isValidHistoricTime(startTime, endTime)) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }
    }

    public long getEndTime() {
        return this.m_endTime;
    }

    public static boolean isValidHistoricTime(long startTime, long endTime) {
        return startTime != Long.MAX_VALUE && endTime != 0L && startTime >= 0L && startTime <= endTime;
    }

    public boolean hasValidHistoricTime() {
        return QueryOptions.isValidHistoricTime(this.m_startTime, this.m_endTime);
    }

    public TableQueryDescriptor getTableQueryDescriptor(String table) {
        if (table == null || table.trim().length() == 0) {
            return null;
        }
        return this.m_descriptors.get(table);
    }

    public String[] getQueryDescriptorTableNames() {
        Set<String> keys = this.m_descriptors.keySet();
        String[] ret = new String[keys.size()];
        keys.toArray(ret);
        return ret;
    }

    public void setTableQueryDescriptor(TableQueryDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.m_descriptors.put(desc.getName(), desc);
    }

    public Serializable getValue(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return this.m_variables.get(name);
    }

    public Map<String, ? extends Serializable> getValues() {
        return this.m_variables;
    }

    public void setValue(String name, Serializable value) {
        if (name != null && name.trim().length() > 0) {
            this.m_variables.put(name, value);
        }
    }

    public void setValues(Map<String, ? extends Serializable> values) {
        if (values != null && values.size() > 0) {
            this.m_variables.putAll(values);
        }
    }

    public int getInterval() {
        return this.m_interval;
    }

    public void setInterval(int interval) {
        if (interval >= 1000) {
            this.m_interval = interval;
        }
    }

    public UseCache useCache() {
        return this.m_useCache;
    }

    public void setUseCache(UseCache useCache) {
        if (useCache != null) {
            this.m_useCache = useCache;
        }
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout >= 1000) {
            this.m_timeout = timeout;
        }
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp >= 1000L) {
            this.m_timestamp = timestamp;
        }
    }

    public void setPrefetching(boolean prefetch) {
        this.m_isPrefetch = prefetch;
    }

    public boolean isPrefetching() {
        return this.m_isPrefetch;
    }

    public Set<String> getTopoNodeIDs() {
        return this.m_tnIds;
    }

    public void addTopoNodeIDs(Set<String> tnIds) {
        if (tnIds == null || tnIds.size() == 0) {
            return;
        }
        for (String tnId : tnIds) {
            if (tnId == null || tnId.trim().length() == 0) continue;
            this.m_tnIds.add(tnId);
        }
    }

    public void addTopoNodeIDs(String[] tnIds) {
        if (tnIds == null || tnIds.length == 0) {
            return;
        }
        for (String tnId : tnIds) {
            if (tnId == null || tnId.trim().length() == 0) continue;
            this.m_tnIds.add(tnId);
        }
    }

    public void removeTopoNodeIds() {
        this.m_tnIds.clear();
    }

    public void addTopoNodeID(String tnId) {
        if (tnId == null || tnId.trim().length() == 0) {
            return;
        }
        this.m_tnIds.add(tnId);
    }

    public void setDump(boolean dump) {
        this.m_dump = dump;
    }

    public boolean isDump() {
        return this.m_dump;
    }

    public void setTopoNodeIDInfo(TopoNodeIDInfo tnIdInfo) {
        if (tnIdInfo != null) {
            this.m_topoNodeIdInfo = tnIdInfo;
        }
    }

    public TopoNodeIDInfo getTopoNodeIDInfo() {
        return this.m_topoNodeIdInfo;
    }

    public void setArchiving(boolean archiving) {
        this.m_isArchiveing = archiving;
    }

    public boolean isArchiving() {
        return this.m_isArchiveing;
    }

    public String getProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = this.m_properties.get(name);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public String[] getProperties(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = this.m_properties.get(name);
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    public boolean containsProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_properties.containsKey(name);
    }

    public static QueryOptions createQueryOptions(Map<String, Serializable> values, Map<String, String> properties) {
        QueryOptions options = new QueryOptions();
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                options.setValue(entry.getKey(), entry.getValue());
            }
        }
        if (properties == null || properties.size() == 0) {
            return options;
        }
        boolean foundQueryType = false;
        boolean foundTimeout = false;
        boolean foundInterval = false;
        boolean foundUseCache = false;
        boolean foundPreFetch = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            ArrayList<String> list = options.m_properties.get(name);
            if (list == null) {
                list = new ArrayList();
                options.m_properties.put(name, list);
            }
            list.add(value);
            try {
                if (!foundQueryType && name.equals(QUERY_TYPE)) {
                    foundQueryType = true;
                    if ("schema".equalsIgnoreCase(value)) {
                        options.setQueryType(QueryType.SCHEMA);
                        continue;
                    }
                    if ("rows".equalsIgnoreCase(value)) {
                        options.setQueryType(QueryType.ROWS);
                        continue;
                    }
                    options.setQueryType(QueryType.ALL);
                    continue;
                }
                if (!foundTimeout && name.equals(QUERY_TIMEOUT)) {
                    foundTimeout = true;
                    int timeout = Integer.parseInt(value.trim());
                    if (timeout <= 0) continue;
                    options.setTimeout(timeout);
                    continue;
                }
                if (!foundInterval && name.equals(QUERY_INTERVAL)) {
                    foundInterval = true;
                    int interval = Integer.parseInt(value.trim());
                    if (interval <= 0) continue;
                    options.setInterval(interval);
                    continue;
                }
                if (!foundUseCache && name.equals(USE_CACHE)) {
                    foundUseCache = true;
                    if ("all".equalsIgnoreCase(value) || "refreshall".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "refreshvalues".equalsIgnoreCase(value)) {
                        options.setUseCache(UseCache.REFRESH_ALL);
                        continue;
                    }
                    options.setUseCache(UseCache.CACHE_COPY);
                    continue;
                }
                if (foundPreFetch || !name.equals(PRE_FETCH)) continue;
                foundPreFetch = true;
                if (!"false".equalsIgnoreCase(value)) continue;
                options.setPrefetching(false);
            }
            catch (NumberFormatException e) {}
        }
        return options;
    }

    public synchronized Object clone() {
        QueryOptions clone = null;
        try {
            clone = (QueryOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.m_descriptors = new HashMap();
        for (Map.Entry<String, TableQueryDescriptor> entry : this.m_descriptors.entrySet()) {
            String table = entry.getKey();
            TableQueryDescriptor tclone = entry.getValue();
            tclone = tclone == null ? null : (TableQueryDescriptor)tclone.clone();
            clone.m_descriptors.put(table, tclone);
        }
        clone.m_variables = new HashMap<String, Serializable>(this.m_variables);
        clone.m_tnIds = new HashSet<String>(this.m_tnIds);
        clone.m_properties = new HashMap<String, ArrayList<String>>(this.m_properties);
        return clone;
    }

    public void close() {
        this.m_descriptors.clear();
        this.m_variables.clear();
        this.m_tnIds.clear();
        this.m_properties.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        SCHEMA,
        ROWS,
        ALL;


        public boolean includeSchema() {
            return this == SCHEMA || this == ALL;
        }

        public boolean includeRows() {
            return this == ROWS || this == ALL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseCache {
        CACHE_COPY,
        REFRESH_ALL,
        REFRESH_MAS;


        public boolean isRefreshValue() {
            return this == REFRESH_ALL || this == REFRESH_MAS;
        }

        public boolean isRefreshMas() {
            return this == REFRESH_MAS;
        }
    }
}

