/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.io.Serializable;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.NameSupport;

public class ColumnDefinitionSupport
extends NameSupport
implements ColumnDefinition {
    private SchemaSupport m_schema = null;
    private String m_unit = null;
    private String m_description = null;
    private String m_nlsId = null;
    private String m_displayName = null;
    private static final String UNKNOWN_STR = "n/a";
    private static final long serialVersionUID = -1150676720292L;

    ColumnDefinitionSupport(SchemaSupport schema, String name, String displayName, String description, String unit) {
        this(schema, name, displayName, null, description, unit);
    }

    protected ColumnDefinitionSupport(SchemaSupport schema, String name, String displayName, String nlsId, String description, String unit) {
        super(name);
        if (schema == null) {
            throw new IllegalArgumentException(" schema=" + schema + " display name=" + displayName + " nlsId=" + nlsId + " description=" + description + " unit=" + unit);
        }
        this.m_schema = schema;
        this.m_displayName = displayName;
        this.m_nlsId = nlsId;
        this.m_description = description;
        this.m_unit = unit;
        this.m_schema.addColumnDefinition(this);
    }

    public String getUnit() {
        return this.m_unit;
    }

    public boolean hasUnit() {
        return this.m_unit != null && this.m_unit.trim().length() > 0;
    }

    public void setUnit(String unit) {
        if (unit != null && unit.trim().length() > 0) {
            this.m_unit = unit;
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean hasDescription() {
        return this.m_description != null && this.m_description.trim().length() > 0;
    }

    public void setDescription(String description) {
        if (description != null && description.trim().length() > 0) {
            this.m_description = description;
        }
    }

    public String getType() {
        return this.getTypeID().toString();
    }

    public ValueType getTypeID() {
        return ((TableSupport)this.m_schema.getTable()).getColumnType(this.m_name);
    }

    public boolean isKey() {
        return this.m_schema.getTable().containsKey(this.m_name);
    }

    public String getNLSID() {
        return this.m_nlsId;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    protected void setNLSID(String tableName) {
        this.m_nlsId = "QU_" + tableName + '_' + this.m_name;
    }

    protected Object clone() {
        ColumnDefinitionSupport clone = null;
        try {
            clone = (ColumnDefinitionSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    protected ColumnDefinitionSupport clone(SchemaSupport schema) {
        ColumnDefinitionSupport clone = (ColumnDefinitionSupport)this.clone();
        if (schema != null) {
            clone.m_schema = schema;
        }
        return clone;
    }

    public static ValueType getValueTypeCode(String type) {
        if (type != null) {
            type = type.toUpperCase();
        }
        try {
            return ValueType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            return ValueType.UNKNOWN;
        }
    }

    public static ValueType getValueTypeCodeByClass(Serializable value) {
        if (value == null) {
            return ValueType.UNKNOWN;
        }
        if (value instanceof Integer) {
            return ValueType.INTEGER;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof Long) {
            return ValueType.LONG;
        }
        if (value instanceof String) {
            return ValueType.STRING;
        }
        return ValueType.UNKNOWN;
    }

    protected void printTbml(long schemaRefreshTime, boolean verbose, PrintWriter out) {
        if (!this.isPrintColumn(schemaRefreshTime)) {
            return;
        }
        String type = this.getType();
        ColumnDefinitionSupport.printTbml(this.m_name, type, verbose, this.m_unit, this.m_description, out);
    }

    protected boolean isPrintColumn(long schemaRefreshTime) {
        return true;
    }

    static void printTbml(String name, String type, boolean verbose, String unit, String description, PrintWriter out) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        out.print('<');
        out.print("columndef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (type != null && type.trim().length() > 0 && !"string".equalsIgnoreCase(type)) {
            out.print("' ");
            out.print("type");
            out.print("='");
            out.print(type);
        }
        if (verbose) {
            out.print("'>\n");
            if (unit != null && unit.trim().length() > 0) {
                out.print('<');
                out.print("unit");
                out.print("><![CDATA[");
                out.print(unit);
                out.print("]]></");
                out.print("unit");
                out.print(">\n");
            }
            if (description != null && description.trim().length() > 0) {
                out.print('<');
                out.print("description");
                out.print("><![CDATA[");
                out.print(description);
                out.print("]]></");
                out.print("description");
                out.print(">\n");
            }
            out.print("</");
            out.print("columndef");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }
}

