/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class ClassLoaderStats
implements GroupRefresh {
    private static ClassLoaderStats s_stats = null;
    private ClassLoadingMXBean m_klassLoader = null;
    private State m_loadedClasses = null;
    private State m_totalLoadedClasses = null;
    private State m_unloadedClasses = null;
    private State m_isLoaderVerbose = null;

    private ClassLoaderStats() {
    }

    private ClassLoaderStats(Noun baseNoun) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        this.m_klassLoader = ManagementFactory.getClassLoadingMXBean();
        Noun klassLoaderNoun = Noun.create(baseNoun, "classLoader", "JVM_ClassLoader");
        this.m_loadedClasses = State.create(klassLoaderNoun, "loaded", (byte)3, "classes", "number of classes currently loaded in the JVM");
        this.m_loadedClasses.setRefresh(this);
        this.m_totalLoadedClasses = State.create(klassLoaderNoun, "totalLoaded", (byte)3, "classes", "total number of classes loaded in the JVM since startup");
        this.m_totalLoadedClasses.setRefresh(this);
        this.m_unloadedClasses = State.create(klassLoaderNoun, "unloaded", (byte)3, "classes", "number of classes that have been unloaded in the JVM");
        this.m_unloadedClasses.setRefresh(this);
        this.m_isLoaderVerbose = State.create(klassLoaderNoun, "verboseClassLoading", (byte)5, "", "whether the Class Loader is operating in verbose mode");
        this.m_isLoaderVerbose.setRefresh(this);
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new ClassLoaderStats(base);
    }

    public void refresh() {
        this.m_loadedClasses.update(this.m_klassLoader.getLoadedClassCount());
        this.m_totalLoadedClasses.update(this.m_klassLoader.getTotalLoadedClassCount());
        this.m_unloadedClasses.update(this.m_klassLoader.getUnloadedClassCount());
        boolean verbose = this.m_klassLoader.isVerbose();
        this.m_isLoaderVerbose.update(verbose ? "TRUE" : "FALSE");
    }

    static void exit() {
        s_stats = null;
    }
}

