/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.util.DMSNLSupport;

public class RawReporter
extends TreeletReporter {
    public RawReporter(Request request) {
        super(request);
        this.m_isOrdered = true;
    }

    void printHeading(PrintWriter out) {
        out.print("<DMSDUMP version='");
        out.print("11.0");
        out.print("' timestamp='");
        long tstamp = System.currentTimeMillis();
        out.print(tstamp);
        out.print(" (");
        Date date = new Date(tstamp);
        out.print(date);
        out.print(")' id='");
        out.print(this.m_id);
        out.print("' name='");
        out.print(this.m_name);
        out.print("'>\n");
    }

    void printEnding(PrintWriter out) {
        out.print("</DMSDUMP>\n");
    }

    void startPrintNounNode(NounTreeletNode node, PrintWriter out) {
        this.m_indent.increIndent();
        this.m_indent.indent(out);
        out.print(node);
        out.print(" [type=");
        out.print(node.getTable());
        out.println(']');
    }

    void printMetricNode(MetricTreeletNode node, PrintWriter out) {
        this.m_indent.increIndent();
        this.m_indent.indent(out);
        out.print(node.getName());
        out.print(":\t");
        Serializable metricValue = node.getObjValue();
        if (metricValue instanceof ErrorObject) {
            out.println(DMSNLSupport.getString("NO_VALUE"));
        } else {
            out.print(metricValue);
            out.print('\t');
            out.println(node.getUnit());
        }
        this.m_indent.decreIndent();
    }

    void endPrintNounNode(NounTreeletNode node, PrintWriter out) {
        this.m_indent.decreIndent();
    }
}

