/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class LongValue
extends Value {
    private long _value = 0L;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;

    private void setValue(long newval) {
        this._value = newval;
        if (this.MAX && this._value > this._max) {
            this._max = newval;
        }
        if (this.MIN && this._value < this._min) {
            this._min = newval;
        }
    }

    public void update(long newval) {
        this.setValue(newval);
    }

    public void update(double newval) {
        long lval = 0L;
        lval = newval >= 0.0 ? Math.round(newval) : -Math.round(-newval);
        this.setValue(lval);
    }

    public void update(int newval) {
        long lval = newval;
        this.setValue(lval);
    }

    public void increment() {
        long lval = this._value + 1L;
        this.setValue(lval);
    }

    public void increment(int inc) {
        long lval = this._value + (long)inc;
        this.setValue(lval);
    }

    public void increment(long inc) {
        long lval = this._value + inc;
        this.setValue(lval);
    }

    public void increment(double inc) {
        long lval = (long)(inc + 0.5);
        this.setValue(lval += this._value);
    }

    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    public Object getValue() {
        return new Long(this._value);
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Long.MAX_VALUE) {
            return new Long(this._min);
        }
        return new Long(0L);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Long.MIN_VALUE) {
            return new Long(this._max);
        }
        return new Long(0L);
    }
}

