/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.instrument.TracerRecord;
import oracle.dms.instrument.TransTrace;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSUtil;

public class Tracer
extends Sensor {
    public static final int EVENT_OCCURRED = 0;
    public static final int PHASE_START = 1;
    public static final int PHASE_STOP = 2;
    public static final int PHASE_ABORT = 3;
    public static final int STATE_UPDATE = 4;
    public static final int REQUEST_BEGIN = 5;
    public static final int REQUEST_END = 6;
    public static final int NOUN_CREATE = 7;
    public static final int STATE_CREATE = 8;
    public static final int STATE_VALUE = 9;
    public static final int TRACE_FULL = 10;
    public static final int UNKNOWN = 11;
    public static final String[] ActionList = new String[12];
    private static final String DUMMY_VAL = "";
    private static int s_maxRecords;
    private static Object s_globalLock;
    private Vector m_theTrace = new Vector(50);
    private Hashtable m_nounTab = new Hashtable();
    private int m_startRecDex = 0;
    private TracerRecord m_beginRec = null;
    private boolean m_triggered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(String pathname, String desc, Tracer oldT) {
        if (pathname == null || pathname.length() == 0 || desc == null || oldT == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Tracer newT = (Tracer)Sensor.lookupCache(pathname = DMSUtil.sanitize(pathname, 511, true, true));
        if (newT == null) {
            Noun parent = Sensor.createParent(pathname);
            String name = DMSUtil.getLeafFromPath(pathname);
            Noun noun = parent;
            synchronized (noun) {
                newT = (Tracer)parent.getSensor(name);
                if (newT != null) {
                    newT.addToCache(pathname);
                } else {
                    Tracer.evict(parent);
                    newT = new Tracer(parent, name, desc);
                }
            }
        }
        if (oldT == newT) {
            return oldT;
        }
        newT.finishPreviousRequest();
        if (oldT != null && oldT.m_theTrace != null) {
            Tracer tracer = newT;
            synchronized (tracer) {
                Enumeration iter = oldT.m_theTrace.elements();
                while (iter.hasMoreElements() && !newT.isFull()) {
                    TracerRecord rec = (TracerRecord)iter.nextElement();
                    newT.m_theTrace.addElement(rec);
                    if (rec.actionID == 5) {
                        newT.m_beginRec = rec;
                        continue;
                    }
                    if (rec.actionID != 6) continue;
                    newT.m_beginRec = null;
                }
            }
        }
        return newT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(String pathname, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Tracer ev = (Tracer)Sensor.lookupCache(pathname);
        if (ev != null) {
            return ev;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        Noun noun = parent;
        synchronized (noun) {
            ev = (Tracer)parent.getSensor(name);
            if (ev != null) {
                ev.addToCache(pathname);
                return ev;
            }
            Tracer.evict(parent);
            return new Tracer(parent, name, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(Noun parent, String name, String desc) {
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Noun noun = parent;
        synchronized (noun) {
            Tracer e = (Tracer)parent.getSensor(name);
            if (e != null) {
                return e;
            }
            Tracer.evict(parent);
            return new Tracer(parent, name, desc);
        }
    }

    public Tracer(Noun parent, String name, String desc) {
        super(parent, name, desc);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this._lastUpdate = System.currentTimeMillis();
        s_maxRecords = TransTrace._getMaxRecords();
    }

    public Tracer() {
        this._lastUpdate = System.currentTimeMillis();
        s_maxRecords = TransTrace._getMaxRecords();
    }

    private void finishPreviousRequest() {
        if (this.m_theTrace.size() <= 0) {
            return;
        }
        TracerRecord lastRec = (TracerRecord)this.m_theTrace.lastElement();
        if (lastRec.actionID != 6 && this.m_beginRec != null) {
            TracerRecord newRec = new TracerRecord(6);
            newRec.setTime(lastRec.getTime());
            this.m_theTrace.addElement(newRec);
            this.m_beginRec = null;
            this.setUpdateTime();
        }
    }

    public void beginRequest() {
        this.reset();
        TracerRecord newRec = new TracerRecord(5);
        this.m_theTrace.addElement(newRec);
        this.m_beginRec = newRec;
    }

    void setTriggered(boolean triggered) {
        this.m_triggered = triggered;
    }

    public boolean isTriggered() {
        return this.m_triggered;
    }

    public void endRequest() {
        if (this.m_beginRec != null) {
            ExecutionContext ectx = ExecutionContext.get();
            TracerRecord newRec = new TracerRecord(6);
            this.m_theTrace.addElement(newRec);
            Map map = this.m_beginRec.getAttributeMap();
            map.putAll(ectx.getAttributeMap());
            if (this.m_triggered) {
                Tracer newT = Tracer.create("/TransTrace/" + ectx.getECID().getUniqueId().toString(), "transaction trace", this);
            }
            if (TransTrace._isDebugEnabled()) {
                this.dumpTraceToFile(TransTrace._getDebugDestination());
            }
            this.processTrace();
            this.reset();
        }
    }

    private boolean isFull() {
        int curSize = this.m_theTrace.size();
        if (curSize < s_maxRecords) {
            return false;
        }
        if (curSize == s_maxRecords) {
            TracerRecord rec = new TracerRecord((Sensor)this, 10);
            this.m_theTrace.addElement(rec);
        }
        return true;
    }

    public static void append(String pathname, Sensor sens, String action) {
        ((Tracer)Sensor.get(pathname)).append(sens, action);
    }

    public synchronized void append(Sensor sens, String action) {
        if (this.isFull()) {
            return;
        }
        TracerRecord rec = new TracerRecord(sens, action);
        this.appendTheRecordToTheTrace(rec);
    }

    public synchronized void append(Sensor sens, int actionID) {
        if (this.isFull()) {
            return;
        }
        if (actionID < 0 || actionID >= ActionList.length) {
            actionID = 11;
        }
        TracerRecord rec = new TracerRecord(sens, actionID);
        this.appendTheRecordToTheTrace(rec);
    }

    public synchronized void append(Sensor sens, int actionID, String detail) {
        if (this.isFull()) {
            return;
        }
        if (actionID < 0 || actionID >= ActionList.length) {
            actionID = 11;
        }
        TracerRecord rec = new TracerRecord(sens, actionID, detail);
        this.appendTheRecordToTheTrace(rec);
    }

    public synchronized void append(Noun noun, int actionID) {
        if (this.isFull()) {
            return;
        }
        if (actionID != 7) {
            return;
        }
        TracerRecord rec = new TracerRecord(noun, actionID);
        this.appendTheRecordToTheTrace(rec);
    }

    private void appendTheRecordToTheTrace(TracerRecord rec) {
        if (rec == null) {
            return;
        }
        Noun noun = rec.noun;
        if (noun != null && this.m_nounTab.get(noun) == null) {
            Sensor[] sArray = noun.getSensors();
            if (sArray == null) {
                return;
            }
            Sensor recSens = rec.sensor;
            for (int s = 0; s < sArray.length; ++s) {
                Sensor sens = sArray[s];
                if (sens == recSens || !(sens instanceof State)) continue;
                State state = (State)sens;
                Object val = state.getValue();
                String strVal = val == null ? DUMMY_VAL : val.toString();
                TracerRecord valRec = new TracerRecord(sens, 9, strVal);
                valRec.setTime(rec.getTime());
                this.m_theTrace.addElement(valRec);
            }
            this.m_nounTab.put(noun, DUMMY_VAL);
        }
        this.m_theTrace.addElement(rec);
        this.setUpdateTime();
    }

    public synchronized Object getValue(Metric m) {
        if (!this._alive) {
            return new ErrorObject();
        }
        if (m == null) {
            throw new InstrumentationException("Metric: " + m + " does not belong to Tracer " + this);
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("Metric: " + m + " does not belong to Tracer " + this);
        }
        switch (index) {
            case 1: {
                return new Integer(this.m_theTrace.size());
            }
        }
        throw new InstrumentationException("Metric: " + m + " does not belong to Tracer " + this);
    }

    public synchronized String getTraceString() {
        this.finishPreviousRequest();
        StringBuffer buf = new StringBuffer();
        Enumeration iter = this.m_theTrace.elements();
        while (iter.hasMoreElements()) {
            TracerRecord tr = (TracerRecord)iter.nextElement();
            tr.toStringBuffer(buf);
            buf.append("\n");
        }
        return buf.toString();
    }

    public synchronized void reset() {
        this.m_theTrace.clear();
        this.m_nounTab.clear();
        this.m_startRecDex = 0;
        this.m_beginRec = null;
        this.m_triggered = false;
        this.setUpdateTime();
    }

    public void deriveMetric(int metric) {
    }

    public void processTrace() {
        TracerRecord thisREC = null;
        try {
            if (!TransTrace._isDumpEnabled()) {
                return;
            }
            Stack<TracerRecord> stack = new Stack<TracerRecord>();
            long prevResume = 0L;
            Noun uriNoun = null;
            PhaseEvent uriPhase = null;
            long uriStart = 0L;
            if (this.m_theTrace == null || this.m_theTrace.size() <= 0) {
                return;
            }
            int traceSize = this.m_theTrace.size();
            for (int recDex = this.m_startRecDex; recDex < traceSize; ++recDex) {
                Sensor cous;
                Noun pre;
                PhaseEvent cous2;
                thisREC = (TracerRecord)this.m_theTrace.elementAt(recDex);
                long time = thisREC.getTime();
                if (thisREC.actionID == 5) {
                    uriNoun = null;
                    uriPhase = null;
                    uriStart = 0L;
                    stack.clear();
                    String uriStr = (String)thisREC.getAttributeMap().get("URI");
                    if (uriStr == null) break;
                    int qdex = uriStr.indexOf(63);
                    if (qdex >= 0) {
                        uriStr = uriStr.substring(0, qdex);
                    }
                    if (TransTrace._isDollarStrippingEnabled() && (qdex = uriStr.indexOf(36)) >= 0) {
                        uriStr = uriStr.substring(0, qdex);
                    }
                    uriStr = DMSUtil.sanitize(uriStr, 511, true, false);
                    Noun parentNoun = Noun.create(TransTrace.NOUN_PATHNAME, "n/a");
                    uriNoun = parentNoun.getChild(uriStr);
                    if (uriNoun == null) {
                        if (parentNoun.getNumChildNouns() < TransTrace._getMaxAggregates()) {
                            uriNoun = Noun.create(parentNoun, uriStr, "oc4j_uri");
                            uriPhase = PhaseEvent.create(uriNoun, "service", "servicing a URI request");
                            uriPhase.deriveMetric(287);
                        } else {
                            thisREC.detail = uriStr;
                            Event evt = Event.create(parentNoun, "ignoredURI", "URI {0} was not recorded because more than maxaggregates ({1}) unique URIs have been recorded since last dump");
                            if (evt.isGonnaLog()) {
                                Object[] sarray = new Object[]{uriStr, new Integer(TransTrace._getMaxAggregates())};
                                evt.occurred(sarray);
                            } else {
                                evt.occurred();
                            }
                        }
                    } else {
                        uriPhase = (PhaseEvent)uriNoun.getSensor("service");
                    }
                    prevResume = uriStart = time;
                    if (uriPhase != null) {
                        uriPhase.start(uriStart);
                    }
                    thisREC.sensor = uriPhase;
                    thisREC.noun = uriNoun;
                    thisREC.cousin = thisREC.sensor;
                    stack.push(thisREC);
                    continue;
                }
                if (thisREC.actionID == 6) {
                    if (uriPhase == null) continue;
                    uriPhase.addExclTime(time - prevResume);
                    uriPhase.stop(uriStart, time);
                    uriPhase = null;
                    continue;
                }
                if (thisREC.actionID == 1) {
                    PhaseEvent thisPE = (PhaseEvent)thisREC.sensor;
                    if (!stack.empty()) {
                        Noun pre2;
                        PhaseEvent cous3;
                        TracerRecord topREC = (TracerRecord)stack.peek();
                        PhaseEvent topPE = (PhaseEvent)topREC.sensor;
                        if (topPE != null) {
                            topPE.addExclTime(time - prevResume);
                        }
                        if (thisPE != null && topREC.cousin != null && (cous3 = thisPE.getCousin(pre2 = topREC.cousin.getParent())) != null) {
                            cous3.start(time);
                            thisREC.cousin = cous3;
                        }
                    }
                    prevResume = time;
                    stack.push(thisREC);
                    continue;
                }
                if (thisREC.actionID == 2) {
                    PhaseEvent thisPE = (PhaseEvent)thisREC.sensor;
                    TracerRecord match = thisREC.findMatchingStart(stack);
                    if (match != null) {
                        TracerRecord topREC;
                        thisPE.addExclTime(time - prevResume);
                        if (thisPE != null && (cous2 = (PhaseEvent)match.cousin) != null) {
                            cous2.stop(match.tstamp, time);
                        }
                        if ((topREC = (TracerRecord)stack.peek()) != null && topREC.actionID == 1) {
                            Map stateValues = match.getStateValues();
                            Map updatedStates = topREC.getUpdatedStates();
                            if (updatedStates != null && stateValues != null) {
                                for (Object key : updatedStates.keySet()) {
                                    if (!stateValues.containsKey(key)) continue;
                                    State cousin = (State)updatedStates.get(key);
                                    Object val = stateValues.get(key);
                                    cousin.update(val);
                                }
                            }
                        }
                    }
                    prevResume = time;
                    continue;
                }
                if (thisREC.actionID == 3) {
                    PhaseEvent thisPE = (PhaseEvent)thisREC.sensor;
                    TracerRecord match = thisREC.findMatchingStart(stack);
                    if (match != null && thisPE != null && (cous2 = (PhaseEvent)match.cousin) != null) {
                        cous2.abort(match.tstamp);
                    }
                    prevResume = time;
                    continue;
                }
                if (thisREC.actionID == 0) {
                    Event evt = (Event)thisREC.sensor;
                    if (evt == null || stack.empty()) continue;
                    TracerRecord topREC = (TracerRecord)stack.peek();
                    pre = topREC.cousin.getParent();
                    cous = evt.getCousin(pre);
                    if (cous == null) continue;
                    ((Event)cous).occurred();
                    continue;
                }
                if (thisREC.actionID == 4 || thisREC.actionID == 8) {
                    State st = (State)thisREC.sensor;
                    if (st == null || stack.empty()) continue;
                    TracerRecord topREC = (TracerRecord)stack.peek();
                    pre = topREC.cousin.getParent();
                    cous = st.getCousin(pre);
                    if (cous != null) {
                        ((State)cous).update(thisREC.detail);
                    }
                    Map stateValues = topREC.getStateValues();
                    stateValues.put(st, thisREC.detail);
                    Map updatedStates = topREC.getUpdatedStates();
                    updatedStates.put(st, cous);
                    continue;
                }
                if (thisREC.actionID == 7) {
                    Noun n = thisREC.noun;
                    if (stack.empty()) continue;
                    TracerRecord topREC = (TracerRecord)stack.peek();
                    pre = topREC.cousin.getParent();
                    Noun cousin = n.getCousin(pre);
                    continue;
                }
                if (thisREC.actionID == 9 || thisREC.actionID != 10) continue;
                int stackLen = stack.size();
                for (int i = stackLen - 1; i > 0; --i) {
                    TracerRecord rec = (TracerRecord)stack.get(i);
                    PhaseEvent phase = (PhaseEvent)rec.sensor;
                    PhaseEvent cousin = (PhaseEvent)rec.cousin;
                    phase.addExclTime(time - prevResume);
                    cousin.stop(rec.tstamp, time);
                }
                if (uriPhase == null) continue;
                uriPhase.addExclTime(time - prevResume);
                uriPhase.stop(uriStart, time);
                uriPhase = null;
            }
            this.m_startRecDex = traceSize;
        }
        catch (Exception e) {
            System.err.println("RBI: caught exception: ");
            e.printStackTrace();
            System.err.println("RBI: full trace:\n" + this.getTraceString());
            System.err.println("RBI: current record:\n  " + thisREC + '\n');
        }
    }

    static synchronized void evict(Noun noun) {
        if (noun == null) {
            return;
        }
        Sensor[] sensArray = noun.getSensors();
        if (sensArray == null) {
            return;
        }
        Vector<Sensor> tracerVect = new Vector<Sensor>();
        for (int sdex = 0; sdex < sensArray.length; ++sdex) {
            Sensor sens = sensArray[sdex];
            if (!(sens instanceof Tracer)) continue;
            tracerVect.addElement(sens);
        }
        int numTracers = tracerVect.size();
        int maxTraces = TransTrace._getMaxTraces();
        while (numTracers >= maxTraces && numTracers > 0) {
            int eDex = 0;
            long minTstamp = ((Tracer)tracerVect.elementAt(eDex)).getLastTstamp();
            for (int tdex = 1; tdex < numTracers; ++tdex) {
                Tracer tracer = (Tracer)tracerVect.elementAt(tdex);
                long tstamp = tracer.getLastTstamp();
                if (tstamp >= minTstamp) continue;
                minTstamp = tstamp;
                eDex = tdex;
            }
            Tracer tracer = (Tracer)tracerVect.elementAt(eDex);
            tracer.destroy();
            tracerVect.removeElementAt(eDex);
            numTracers = tracerVect.size();
        }
    }

    private long getLastTstamp() {
        long retval = 0L;
        TracerRecord rec = (TracerRecord)this.m_theTrace.lastElement();
        if (rec != null) {
            retval = rec.getTime();
        }
        return retval;
    }

    private long getDumpTime() {
        String metricname = "/DMS-Internal/transtrace/DumpInfo/nextDumpTime.value";
        Number Numb = (Number)Spy.getMetricValue(metricname);
        long retval = 0L;
        if (Numb != null) {
            retval = Numb.longValue();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpTraceToFile(String destname) {
        int traceSize = this.m_theTrace.size();
        if (traceSize <= 2) {
            return;
        }
        Object object = s_globalLock;
        synchronized (object) {
            File fil = new File(destname, "dmsTrace_" + this.getDumpTime() + ".trc");
            String filename = fil.getPath();
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            BufferedWriter bw = null;
            PrintWriter pw = null;
            try {
                fos = new FileOutputStream(filename, true);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                bw = new BufferedWriter(osw);
                pw = new PrintWriter(bw);
                pw.println(this.getTraceString());
            }
            catch (Exception e) {
                System.err.println("WARNING: DMS unable to dump trace : " + filename);
                e.printStackTrace();
            }
            finally {
                try {
                    pw.close();
                    bw.close();
                    osw.close();
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static synchronized void shutdown() {
        s_maxRecords = 1000;
        s_globalLock = new Object();
    }

    static {
        Tracer.ActionList[0] = "EventOccurred";
        Tracer.ActionList[1] = "PhaseStart";
        Tracer.ActionList[2] = "PhaseStop";
        Tracer.ActionList[3] = "PhaseAbort";
        Tracer.ActionList[4] = "StateUpdate";
        Tracer.ActionList[5] = "RequestBegin";
        Tracer.ActionList[6] = "RequestEnd";
        Tracer.ActionList[7] = "NounCreate";
        Tracer.ActionList[8] = "StateCreate";
        Tracer.ActionList[9] = "StateValue";
        Tracer.ActionList[10] = "TraceFull";
        Tracer.ActionList[11] = "unknown";
        s_maxRecords = 1000;
        s_globalLock = new Object();
    }
}

