/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dms.http.Request;

public class SimpleRequest
extends Request {
    private Hashtable<String, ArrayList<String>> m_params = new Hashtable();

    public void addParameter(String key, String val) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        ArrayList<String> valueVec = this.m_params.get(key = key.toLowerCase());
        if (valueVec == null) {
            valueVec = new ArrayList();
            this.m_params.put(key, valueVec);
        }
        valueVec.add(val);
    }

    public void removeParameter(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        key = key.toLowerCase();
        this.m_params.remove(key);
    }

    public boolean containsParameter(String key) {
        if (key == null || key.trim().length() == 0) {
            return false;
        }
        key = key.toLowerCase();
        return this.m_params.containsKey(key);
    }

    public void parseQueryStrings(String queryStrings) {
        if (queryStrings == null || queryStrings.trim().length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(queryStrings, "&");
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int index = pair.indexOf(61);
            if (index < 0) continue;
            String key = pair.substring(0, index);
            String val = pair.substring(index + 1);
            if (key.trim().length() == 0) continue;
            this.addParameter(key, val);
        }
    }

    public String getParameter(String key) {
        if (key == null) {
            return null;
        }
        ArrayList<String> valueVec = this.m_params.get(key = key.toLowerCase());
        if (valueVec == null) {
            return null;
        }
        return valueVec.get(0);
    }

    public String getMethod() {
        String method = this.getParameter("operation");
        if (method == null || method.trim().length() == 0) {
            return "get";
        }
        return method;
    }

    public String getHeader(String name) {
        return null;
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        ArrayList<String> values = this.m_params.get(name = name.toLowerCase());
        if (values == null) {
            return null;
        }
        String[] ret = new String[values.size()];
        values.toArray(ret);
        return ret;
    }

    public String toQueryString() {
        boolean isFirst = true;
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> entry : this.m_params.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> list = entry.getValue();
            if (list == null || list.size() == 0) continue;
            if (list.size() == 1) {
                String value = list.get(0);
                if (value == null || value.trim().length() == 0) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('&');
                }
                buf.append(key);
                buf.append('=');
                buf.append(value);
                continue;
            }
            if (list.size() <= 1) continue;
            for (String value : list) {
                if (value == null || value.trim().length() == 0) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('&');
                }
                buf.append(key);
                buf.append('=');
                buf.append(value);
            }
        }
        return buf.toString();
    }

    public String getServerName() {
        return "unknown";
    }

    public int getServerPort() {
        return -666;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }
}

