/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.logging.Level;
import oracle.dms.context.DMSContextManager;

class ContextCleaner
extends Thread {
    public ContextCleaner() {
        DMSContextManager.getLogger().log(Level.FINEST, "CTX-00035");
        this.setName("ContextCleaner");
        this.setDaemon(true);
        this.setPriority(4);
    }

    public void run() {
        while (!DMSContextManager.isDone()) {
            DMSContextManager.cleanup();
            try {
                if (!this.isInterrupted()) {
                    ContextCleaner.sleep(DMSContextManager.getCleanerSleepMillis());
                    continue;
                }
                return;
            }
            catch (InterruptedException ie) {
                DMSContextManager.getLogger().log(Level.FINEST, "CTX-00034");
                return;
            }
        }
    }
}

