/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentFacts
implements Serializable {
    private String m_description;
    private String m_executionContextId;
    private long m_incidentTime;
    private ErrorMessage m_errorMessage;
    private Incident.IncidentSource m_incidentSource;
    private DiagnosticsCategory m_problemImpact;
    private Map<IncidentFactProperty, List<String>> m_secondaryFacts;

    private IncidentFacts(Incident.IncidentSource source, long incidentTime) {
        if (source == null) {
            throw new IllegalArgumentException("Invalid argument: source=" + (Object)((Object)source));
        }
        this.m_incidentSource = source;
        this.m_incidentTime = incidentTime != 0L ? incidentTime : System.currentTimeMillis();
        this.m_secondaryFacts = new HashMap<IncidentFactProperty, List<String>>();
    }

    public static IncidentFacts createSystemIncidentFacts(long incidentTime, ErrorMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid arguments message=" + message);
        }
        IncidentFacts facts = new IncidentFacts(Incident.IncidentSource.SYSTEM, incidentTime);
        facts.setErrorMessage(message);
        return facts;
    }

    public static IncidentFacts createManualIncidentFacts(long incidentTime) {
        return new IncidentFacts(Incident.IncidentSource.MANUAL, incidentTime);
    }

    public long getIncidentTime() {
        return this.m_incidentTime;
    }

    public Incident.IncidentSource getIncidentSource() {
        return this.m_incidentSource;
    }

    public void setErrorMessage(ErrorMessage msg) {
        this.m_errorMessage = msg;
    }

    public ErrorMessage getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setExecutionContextId(String id) {
        this.m_executionContextId = id;
    }

    public String getExecutionContextId() {
        return this.m_executionContextId;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void addProperty(IncidentFactProperty property, String ... value) {
        if (property == null || value == null || value.length == 0) {
            return;
        }
        List<String> propVals = this.m_secondaryFacts.get((Object)property);
        if (propVals == null) {
            propVals = new ArrayList<String>();
        }
        for (String val : value) {
            propVals.add(val);
        }
        this.m_secondaryFacts.put(property, propVals);
    }

    public Set<IncidentFactProperty> getIncidentFactPropertyNames() {
        return this.m_secondaryFacts.keySet();
    }

    public List<String> getIncidentFactPropertyValues(IncidentFactProperty property) {
        return this.m_secondaryFacts.get((Object)property);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[incidentSource=");
        sb.append((Object)this.m_incidentSource);
        sb.append(" incidentTime=");
        sb.append(this.m_incidentTime);
        sb.append(" errorMessage=");
        sb.append(this.m_errorMessage);
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentFactProperty {
        PROBLEM_IMPACT_PROP,
        TOPOLOGY_NODE_ID_PROP;


        public static final IncidentFactProperty getProperty(IncidentFactKeyword keyword) {
            switch (keyword) {
                case PROBLEM_IMPACT: {
                    return PROBLEM_IMPACT_PROP;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentFactKeyword {
        ECID,
        PROBLEM_IMPACT,
        INCIDENT_TIME;


        public static IncidentFactKeyword getIncidentFactKeyword(String keyword) {
            try {
                return IncidentFactKeyword.valueOf(keyword.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

