/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpResult;

public final class DumpWriter {
    private DumpContext m_context;
    private ODLHandler m_handler;
    private ODLLogRecord m_logRecord;
    private HashMap<String, String> m_supplAttributes = new HashMap(3);
    private String m_dumpFilename;
    private byte[] m_buffer = new byte[8192];
    private int m_offset = 0;
    private boolean m_isMultiLogRecord = false;
    private boolean m_logRecordOutput = false;
    private String m_externalDumpLocation;
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final String DEFAULT_DUMP_FILENAME = "log.xml";
    private static final char SEPARATOR_CHAR = File.separatorChar;
    private static final String DUMPS_ROOT_PATH = "diagnostics" + SEPARATOR_CHAR + "dumps" + SEPARATOR_CHAR;
    private static final String DUMP_NAME = "DUMP_NAME";
    private static final String DUMP_ID = "DUMP_ID";
    private static final String INCIDENT_ID = "INCIDENT_ID";
    private static final String DUMP_MESSAGE = "Diagnostic dump record";
    private static final String ADMIN_SERVER = "AdminServer";
    private static final String ADMIN_AGENT = "AdminAgent";
    private static final String ORACLE_COMP_TYPE = "oracle.component.type";
    private static final String ORACLE_COMP_NAME = "oracle.component.name";
    private static final String ORACLE_PROC_INDEX = "oracle.process.index";
    private static final String NEW_LINE = "\n";

    public DumpWriter(DumpContext context) {
        if (context == null) {
            throw new IllegalArgumentException("DumpContext cannot be null");
        }
        this.m_context = context;
        this.init();
    }

    public DumpWriter(DumpContext context, String externalDumpFile) {
        if (context == null || externalDumpFile == null || externalDumpFile.length() == 0) {
            throw new IllegalArgumentException("context=" + context + " externalDumpFile=" + externalDumpFile);
        }
        this.m_context = context;
        this.m_externalDumpLocation = externalDumpFile;
        this.init();
    }

    public DumpResult getDumpResult() {
        DumpResult result = new DumpResult(this.m_context, this.m_dumpFilename, this.m_context.getDumpID());
        if (this.m_offset > 0) {
            byte[] temp = new byte[this.m_offset];
            System.arraycopy(this.m_buffer, 0, temp, 0, this.m_offset);
            this.m_logRecord.setSupplDetail(new String(temp));
            this.m_handler.publish(this.m_logRecord);
            if (!this.m_isMultiLogRecord) {
                result.setDumpOutput(temp);
            }
            this.m_logRecordOutput = true;
            this.m_buffer = null;
            this.m_offset = 0;
        }
        if (this.m_externalDumpLocation != null) {
            result.setExternalDumpLocation(this.m_externalDumpLocation);
            if (!this.m_logRecordOutput) {
                this.m_handler.publish(this.m_logRecord);
            }
        }
        this.m_handler.close();
        return result;
    }

    public void dump(String s) {
        for (byte this.m_buffer[this.m_offset++] : s.getBytes()) {
            if (this.m_offset != 8192) continue;
            this.m_logRecord.setSupplDetail(new String(this.m_buffer));
            this.m_handler.publish(this.m_logRecord);
            this.m_offset = 0;
            this.m_isMultiLogRecord = true;
            this.m_logRecordOutput = true;
        }
    }

    public void dumpln(String s) {
        this.dump(s);
        this.dump(NEW_LINE);
    }

    public void dumpln() {
        this.dump(NEW_LINE);
    }

    public void setDumpProperty(String name, String value) {
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        this.m_supplAttributes.put(name, value);
        this.m_logRecord.setSupplAttributes(this.m_supplAttributes);
    }

    private void init() {
        this.m_dumpFilename = this.buildDumpFilename();
        this.m_handler = new ODLHandler(new ODL11Formatter(), this.m_dumpFilename, null);
        this.m_logRecord = new ODLLogRecord(Level.INFO, DUMP_MESSAGE);
        this.setDumpProperty(DUMP_NAME, this.m_context.getDumpName());
        this.setDumpProperty(DUMP_ID, this.m_context.getDumpID());
        if (this.m_context.getIncidentID() != null) {
            this.setDumpProperty(INCIDENT_ID, this.m_context.getIncidentID());
        }
        if (this.m_externalDumpLocation != null) {
            this.m_logRecord.setDetailLocation(this.m_externalDumpLocation);
        }
    }

    private String buildDumpFilename() {
        String filename = this.m_context.getOracleInstancePath() + SEPARATOR_CHAR + DUMPS_ROOT_PATH;
        String sysProp = System.getProperty(ORACLE_COMP_TYPE);
        if (sysProp != null) {
            filename = filename + sysProp + SEPARATOR_CHAR;
            if (sysProp.compareTo(ADMIN_SERVER) != 0 && sysProp.compareTo(ADMIN_AGENT) != 0 && (sysProp = System.getProperty(ORACLE_COMP_NAME)) != null) {
                filename = filename + sysProp + System.getProperty(ORACLE_PROC_INDEX) + SEPARATOR_CHAR;
            }
        }
        if (this.m_context.getIncidentID() != null) {
            filename = filename + this.m_context.getIncidentID() + SEPARATOR_CHAR;
        }
        filename = filename + DEFAULT_DUMP_FILENAME;
        return filename;
    }
}

