/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.util.EnumSet;
import java.util.Enumeration;
import java.util.logging.Level;
import oracle.dfw.common.ArgumentDescriptor;
import oracle.dfw.common.ArgumentDescriptorMap;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.InvalidDumpContextException;
import oracle.dfw.impl.common.ArgumentDescriptorMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagnosticDump
implements Comparable<DiagnosticDump> {
    private ArgumentDescriptorMapImpl m_mandatoryArguments = new ArgumentDescriptorMapImpl();
    private ArgumentDescriptorMapImpl m_optionalArguments = new ArgumentDescriptorMapImpl();

    public abstract String getOwner();

    public abstract String getName();

    public String getFullDumpName() {
        return this.getOwner() + "." + this.getName();
    }

    public abstract EnumSet<DiagnosticsCategory> getDumpCategories();

    public abstract String getDumpDescription();

    public void validateDumpContext(DumpContext context) throws InvalidDumpContextException {
        String argName;
        ArgumentMap map = context.getArguments();
        Enumeration<String> args = this.getMandatoryArguments().enumerateKeys();
        while (args.hasMoreElements()) {
            argName = args.nextElement();
            if (map.containsKey(argName)) continue;
            throw new InvalidDumpContextException("40354", argName);
        }
        args = map.enumerateKeys();
        while (args.hasMoreElements()) {
            argName = args.nextElement();
            ArgumentDescriptor desc = this.getMandatoryArguments().get(argName);
            if (desc == null) {
                desc = this.getOptionalArguments().get(argName);
            }
            if (desc == null) {
                LoggerFactory.getFrameworkLogger().log(Level.INFO, "MAS-40355", new String[]{argName, this.getFullDumpName()});
                continue;
            }
            if (desc.getType().isValidType(map.get(argName)) || desc.getType().convertToType(map.get(argName).toString()) != null) continue;
            InvalidDumpContextException e = new InvalidDumpContextException("40356");
            e.addToken(argName);
            e.addToken(desc.getType().toString());
            throw e;
        }
    }

    public abstract DumpResult executeDump(DumpContext var1) throws DumpExecutionException;

    public final void defineArgument(String name, ArgumentType type, boolean isRequired, String desc) {
        if (name == null || name.length() == 0 || type == null || desc == null || desc.length() == 0) {
            return;
        }
        if (isRequired) {
            this.m_mandatoryArguments.put(name, type, desc);
        } else {
            this.m_optionalArguments.put(name, type, desc);
        }
    }

    public final ArgumentDescriptorMap getMandatoryArguments() {
        return this.m_mandatoryArguments;
    }

    public final ArgumentDescriptorMap getOptionalArguments() {
        return this.m_optionalArguments;
    }

    @Override
    public int compareTo(DiagnosticDump dump) {
        if (dump == null) {
            return -1;
        }
        return this.getName().compareTo(dump.getName());
    }

    public String toString() {
        return "[dump owner=" + this.getOwner() + " : dump name=" + this.getName() + "]";
    }
}

