/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticsEventManager {
    private static Map<Class<DiagnosticsEvent>, List<DiagnosticsListener>> m_listeners = new HashMap<Class<DiagnosticsEvent>, List<DiagnosticsListener>>();
    private static List<DiagnosticsListener> m_allEventsListeners = new Vector<DiagnosticsListener>();
    private static List<DiagnosticsEvent> m_queue = new ArrayList<DiagnosticsEvent>();
    private static NotifierThread m_notifierThread;

    private DiagnosticsEventManager() {
    }

    public static void registerListener(DiagnosticsListener listener) {
        if (listener.getHandledEventClasses() == null) {
            return;
        }
        if (listener.getHandledEventClasses().length == 0) {
            m_allEventsListeners.add(listener);
            return;
        }
        int size = listener.getHandledEventClasses().length;
        for (int i = 0; i < size; ++i) {
            List<Object> l;
            Class<DiagnosticsEvent> c = listener.getHandledEventClasses()[i];
            if (m_listeners.containsKey(c)) {
                l = m_listeners.get(c);
                l.add(listener);
                continue;
            }
            l = new Vector();
            l.add(listener);
            m_listeners.put(c, l);
        }
    }

    public static void deregisterListener(DiagnosticsListener listener) {
        if (listener.getHandledEventClasses() == null) {
            return;
        }
        if (listener.getHandledEventClasses().length == 0) {
            m_allEventsListeners.remove(listener);
            return;
        }
        int size = listener.getHandledEventClasses().length;
        for (int i = 0; i < size; ++i) {
            Class<DiagnosticsEvent> c = listener.getHandledEventClasses()[i];
            if (!m_listeners.containsKey(c)) continue;
            List<DiagnosticsListener> l = m_listeners.get(c);
            l.remove(listener);
            if (l.size() != 0) continue;
            m_listeners.remove(c);
        }
    }

    public static <T extends DiagnosticsEvent> void notifyListeners(T event) {
        List<DiagnosticsListener> l = m_listeners.get(event.getClass());
        if (l != null) {
            for (DiagnosticsListener listener : l) {
                listener.handleEvent(event);
            }
        }
        for (DiagnosticsListener listener : m_allEventsListeners) {
            listener.handleEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DiagnosticsEvent> void notifyListeners(T event, boolean immediately) {
        if (immediately) {
            DiagnosticsEventManager.notifyListeners(event);
        } else {
            if (m_notifierThread == null) {
                m_notifierThread = new NotifierThread();
            }
            List<DiagnosticsEvent> list = m_queue;
            synchronized (list) {
                m_queue.add(event);
                m_queue.notify();
            }
        }
    }

    private static class NotifierThread
    implements Runnable {
        protected NotifierThread() {
            Thread th = new Thread(this);
            th.setDaemon(true);
            th.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                DiagnosticsEvent de;
                List list = m_queue;
                synchronized (list) {
                    if (m_queue.size() == 0) {
                        try {
                            m_queue.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    de = (DiagnosticsEvent)m_queue.remove(0);
                }
                DiagnosticsEventManager.notifyListeners(de);
            }
        }
    }
}

