/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.query;

import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.core.ojdl.query.Condition;
import oracle.core.ojdl.query.LogRecordField;
import oracle.core.ojdl.reader.LogRecord;
import oracle.core.ojdl.util.StringOp;

public class SimpleCondition
extends Condition {
    public static final int OP_EQUALS = 1;
    public static final int OP_CONTAINS = 2;
    public static final int OP_STARTS_WITH = 3;
    public static final int OP_EQUALS_IGNORE_CASE = 4;
    public static final int OP_CONTAINS_IGNORE_CASE = 5;
    public static final int OP_STARTS_WITH_IGNORE_CASE = 6;
    public static final int OP_MATCHES = 7;
    public static final int OP_MATCHES_IGNORE_CASE = 8;
    private static final int[][] OP_MAP = new int[][]{{-1, -1}, {0, 0}, {2, 0}, {1, 0}, {0, 1}, {2, 1}, {1, 1}, {3, 0}, {3, 1}};
    private String m_field;
    private String[] m_values;
    private boolean m_supplAttr;
    private int m_op;
    private StringOp[] m_strOps;
    private static String[] s_itemNames = new String[]{"type", "field", "values", "supplAttr", "op"};
    private static CompositeType s_compositeType;

    public SimpleCondition(String field, String value, int op) {
        this(field, new String[]{value}, op);
    }

    public SimpleCondition(String field, String[] values, int op) {
        this(field, values, false, op);
    }

    public SimpleCondition(String field, String value, boolean supplAttr, int op) {
        this(field, new String[]{value}, supplAttr, op);
    }

    public SimpleCondition(String name, String[] values, boolean supplAttr, int op) {
        this.m_field = name;
        this.m_values = values;
        this.m_op = op;
        this.m_supplAttr = supplAttr;
    }

    public String getField() {
        return this.m_field;
    }

    public String[] getValues() {
        return this.m_values;
    }

    public boolean isSupplAttr() {
        return this.m_supplAttr;
    }

    public int getOp() {
        return this.m_op;
    }

    void toSql(StringBuffer buf) {
        int i;
        buf.append("(");
        LogRecordField f = this.m_supplAttr ? LogRecordField.getField("SUPPL_ATTR.NAME") : LogRecordField.getField(this.m_field);
        if (f.isCollectionField()) {
            buf.append("exists (select * from ");
            buf.append(f.getCollectionExpr());
            buf.append(" where ");
        }
        if (this.m_supplAttr) {
            buf.append("(");
            buf.append(f.getSqlExpr());
            buf.append("='");
            buf.append(this.escapeSingleQuote(this.m_field));
            buf.append("') and (");
            f = LogRecordField.getField("SUPPL_ATTR.VALUE");
        }
        String[] values = new String[this.m_values.length];
        for (i = 0; i < values.length; ++i) {
            values[i] = this.escapeSingleQuote(this.m_values[i]);
        }
        switch (this.m_op) {
            case 1: {
                buf.append(f.getSqlExpr());
                buf.append(" in ('");
                buf.append(values[0]);
                for (i = 1; i < values.length; ++i) {
                    buf.append("','");
                    buf.append(values[i]);
                }
                buf.append("')");
                break;
            }
            case 2: {
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(" or ");
                    }
                    buf.append(f.getSqlExpr());
                    buf.append(" LIKE ");
                    buf.append("'%");
                    buf.append(values[i]);
                    buf.append("%'");
                }
                break;
            }
            case 3: {
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(" or ");
                    }
                    buf.append(f.getSqlExpr());
                    buf.append(" LIKE '");
                    buf.append(values[i]);
                    buf.append("%'");
                }
                break;
            }
            case 4: {
                buf.append("lower(");
                buf.append(f.getSqlExpr());
                buf.append(") in ('");
                buf.append(values[0].toLowerCase());
                for (i = 1; i < values.length; ++i) {
                    buf.append("','");
                    buf.append(values[i].toLowerCase());
                }
                buf.append("')");
                break;
            }
            case 5: {
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(" or ");
                    }
                    buf.append("lower(");
                    buf.append(f.getSqlExpr());
                    buf.append(") LIKE ");
                    buf.append("'%");
                    buf.append(values[i].toLowerCase());
                    buf.append("%'");
                }
                break;
            }
            case 6: {
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(" or ");
                    }
                    buf.append("lower(");
                    buf.append(f.getSqlExpr());
                    buf.append(") LIKE '");
                    buf.append(values[i].toLowerCase());
                    buf.append("%'");
                }
                break;
            }
            case 7: 
            case 8: {
                boolean ic = this.m_op == 8;
                for (int i2 = 0; i2 < values.length; ++i2) {
                    if (i2 > 0) {
                        buf.append(" or ");
                    }
                    buf.append("REGEXP_LIKE(");
                    buf.append(f.getSqlExpr());
                    buf.append(",'");
                    buf.append(values[i2]);
                    buf.append("','");
                    buf.append(ic ? "i" : "c");
                    buf.append("')");
                }
                break;
            }
        }
        if (this.m_supplAttr) {
            buf.append("))");
        } else if (f.isCollectionField()) {
            buf.append(")");
        }
        buf.append(")");
    }

    private String escapeSingleQuote(String str) {
        if (str == null || str.indexOf(39) < 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length() + 2);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    boolean eval(LogRecord rec) {
        if (this.m_field.equals("SUPPL_ATTR.NAME") || this.m_field.equals("SUPPL_ATTR.VALUE") || this.m_supplAttr) {
            return this.evalMap((Map)rec.getField("SUPPL_ATTRS"));
        }
        Object fieldVal = rec.getField(this.m_field);
        if (fieldVal == null) {
            return false;
        }
        return this.evalField(fieldVal.toString());
    }

    private final boolean evalMap(Map map) {
        if (map == null) {
            return false;
        }
        if (this.m_supplAttr) {
            Object v = map.get(this.m_field);
            if (v == null) {
                return false;
            }
            return this.evalField(v.toString());
        }
        Iterator<Object> it = this.m_field.equals("SUPPL_ATTR.NAME") ? map.keySet().iterator() : map.values().iterator();
        while (it.hasNext()) {
            if (!this.evalField(it.next().toString())) continue;
            return true;
        }
        return false;
    }

    private final boolean evalField(String fieldVal) {
        if (fieldVal == null) {
            return false;
        }
        if (this.m_strOps == null) {
            StringOp[] strOps = new StringOp[this.m_values.length];
            for (int i = 0; i < this.m_values.length; ++i) {
                strOps[i] = new StringOp(OP_MAP[this.m_op][0], this.m_values[i], OP_MAP[this.m_op][1] == 1);
            }
            this.m_strOps = strOps;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            if (!this.m_strOps[i].eval(fieldVal)) continue;
            return true;
        }
        return false;
    }

    public static CompositeType toCompositeType() throws OpenDataException {
        if (s_compositeType == null) {
            s_compositeType = new CompositeType(Condition.toCompositeType().getTypeName(), Condition.toCompositeType().getDescription(), s_itemNames, s_itemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.BOOLEAN, SimpleType.INTEGER});
        }
        return s_compositeType;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (!Condition.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException();
        }
        return new CompositeDataSupport(SimpleCondition.toCompositeType(), s_itemNames, new Object[]{"SimpleCondition", this.getField(), this.getValues(), this.isSupplAttr(), this.getOp()});
    }

    public static Condition from(CompositeData cd) throws OpenDataException {
        if (!"SimpleCondition".equals(cd.get("type"))) {
            throw new IllegalArgumentException();
        }
        String field = (String)cd.get("field");
        String[] values = (String[])cd.get("values");
        boolean isSupplAttr = (Boolean)cd.get("supplAttr");
        int op = (Integer)cd.get("op");
        return new SimpleCondition(field, values, isSupplAttr, op);
    }
}

