/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.core.ojdl.BufferedLogWriter;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.ExceptionHandler;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.RotationSupport;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandlerException;
import oracle.core.ojdl.logging.ODLLevel;

public class ODLHandler
extends Handler {
    private static String PROP_PREFIX = "oracle.core.ojdl.logging.ODLHandler";
    private static String SUPPL_ATTRS_PROP = PROP_PREFIX + ".supplementalAttributes";
    private static String USE_SRCMET_PROP = PROP_PREFIX + ".useSourceClassAndMethod";
    private static String USE_DEF_ATTRS_PROP = PROP_PREFIX + ".useDefaultAttributes";
    private static String INCLUDE_MSG_ARGS_PROP = PROP_PREFIX + ".includeMessageArguments";
    private LogWriter m_logWriter;
    private ODLFormatter m_formatter;
    private Level m_autoFlushLevel = ODLLevel.NOTIFICATION;

    public ODLHandler(String logDirectory, long maxFileSize, long maxLogSize, String encoding) throws ODLHandlerException {
        try {
            this.m_formatter = new ODLFormatter();
            this.m_logWriter = BusStopLogWriter.create(logDirectory, maxFileSize, maxLogSize, encoding);
            this.setEncoding(encoding);
            this.m_logWriter.setExceptionHandler(new ExceptionHandler(true));
        }
        catch (Exception e) {
            throw new ODLHandlerException(e);
        }
        this.initProperties();
    }

    public ODLHandler(LogFormatter formatter, String filename, long maxFileSize, long maxLogSize, String encoding) throws ODLHandlerException {
        try {
            if (new File(filename).isDirectory()) {
                filename = new File(filename, "diagnostic.log").getAbsolutePath();
            }
            this.m_formatter = new ODLFormatter(formatter);
            this.m_logWriter = FileLogWriter.create(formatter, filename, true, maxFileSize, maxLogSize, encoding);
            this.m_logWriter.setExceptionHandler(new ExceptionHandler(true));
            this.setEncoding(encoding);
        }
        catch (Exception e) {
            throw new ODLHandlerException(e);
        }
        this.initProperties();
    }

    public ODLHandler(String logDirectory, long maxFileSize, long maxLogSize) throws ODLHandlerException {
        this(logDirectory, maxFileSize, maxLogSize, null);
    }

    public ODLHandler(String logDirectory, long maxFileSize) throws ODLHandlerException {
        this(logDirectory, maxFileSize, Long.MAX_VALUE, null);
    }

    public ODLHandler(String logDirectory) throws ODLHandlerException {
        this(logDirectory, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    public ODLHandler(String logDirectory, String encoding) throws ODLHandlerException {
        this(logDirectory, Long.MAX_VALUE, Long.MAX_VALUE, encoding);
    }

    public ODLHandler(LogFormatter formatter, String filename, String encoding) throws ODLHandlerException {
        this(formatter, filename, Long.MAX_VALUE, Long.MAX_VALUE, encoding);
    }

    public void setMaxFileSize(long sizeInBytes) {
        ((RotationSupport)((Object)this.m_logWriter)).setMaxSegmentSize(sizeInBytes);
    }

    public long getMaxFileSize() {
        return ((RotationSupport)((Object)this.m_logWriter)).getMaxSegmentSize();
    }

    public void setMaxLogSize(long sizeInBytes) {
        ((RotationSupport)((Object)this.m_logWriter)).setMaxSize(sizeInBytes);
    }

    public long getMaxLogSize() {
        return ((RotationSupport)((Object)this.m_logWriter)).getMaxSize();
    }

    public void setBaseRotationTime(long baseTime) {
        ((RotationSupport)((Object)this.m_logWriter)).setBaseRotationTime(baseTime);
    }

    public long getBaseRotationTime() {
        return ((RotationSupport)((Object)this.m_logWriter)).getBaseRotationTime();
    }

    public void setRotationFrequency(int frequency) {
        ((RotationSupport)((Object)this.m_logWriter)).setRotationFrequency(frequency);
    }

    public int getRotationFrequency() {
        return ((RotationSupport)((Object)this.m_logWriter)).getRotationFrequency();
    }

    public void setRetentionPeriod(int retentionPeriod) {
        ((RotationSupport)((Object)this.m_logWriter)).setRetentionPeriod(retentionPeriod);
    }

    public int getRetentionPeriod() {
        return ((RotationSupport)((Object)this.m_logWriter)).getRetentionPeriod();
    }

    public void setKeepOpen(boolean keepOpen) {
        ((RotationSupport)((Object)this.m_logWriter)).setKeepOpen(keepOpen);
    }

    public boolean getKeepOpen() {
        return ((RotationSupport)((Object)this.m_logWriter)).getKeepOpen();
    }

    public void setDeleteFiles(boolean deleteFiles) {
        ((RotationSupport)((Object)this.m_logWriter)).setDeleteFiles(deleteFiles);
    }

    public boolean getDeleteFiles() {
        return ((RotationSupport)((Object)this.m_logWriter)).getDeleteFiles();
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        super.setEncoding(encoding);
        try {
            ((BufferedLogWriter)this.m_logWriter).setEncoding(this.getEncoding());
        }
        catch (LogWriterException e) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public synchronized void close() {
        if (this.m_logWriter == null) {
            return;
        }
        try {
            this.m_logWriter.close();
        }
        catch (Exception e) {
            this.reportError("", e, 3);
        }
        this.m_logWriter = null;
    }

    public synchronized void flush() {
        if (this.m_logWriter == null) {
            return;
        }
        try {
            this.m_logWriter.flush();
        }
        catch (Exception e) {
            this.reportError("", e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord rec) {
        if (this.m_logWriter == null || !this.isLoggable(rec)) {
            return;
        }
        LogMessage msg = this.m_formatter.toLogMessage(rec);
        try {
            ODLHandler oDLHandler = this;
            synchronized (oDLHandler) {
                if (this.m_logWriter != null) {
                    this.m_logWriter.write(msg);
                }
            }
        }
        catch (Exception e) {
            this.reportError("", e, 1);
        }
        if (rec.getLevel().intValue() >= this.m_autoFlushLevel.intValue()) {
            this.flush();
        }
    }

    public void setAutoFlushLevel(Level level) {
        this.m_autoFlushLevel = level;
    }

    public Level getAutoFlushLevel() {
        return this.m_autoFlushLevel;
    }

    public void setSupplementalAttributes(String[] attrNames) {
        this.m_formatter.setSupplementalAttributes(attrNames);
    }

    public String[] getSupplementalAttributes() {
        return this.m_formatter.getSupplementalAttributes();
    }

    public void setUseSourceClassAndMethod(boolean useSrcClassAndMethod) {
        this.m_formatter.setUseSourceClassAndMethod(useSrcClassAndMethod);
    }

    public void setUseSourceClassAndMethod(Level level) {
        this.m_formatter.setUseSourceClassAndMethod(level);
    }

    public boolean getUseSourceClassAndMethod() {
        return this.m_formatter.getUseSourceClassAndMethod();
    }

    public Level getUseSourceClassAndMethodLevel() {
        return this.m_formatter.getUseSourceClassAndMethodLevel();
    }

    public void setUseDefaultAttributes(boolean useDefaultAttributes) {
        this.m_formatter.setUseDefaultAttributes(useDefaultAttributes);
    }

    public boolean getUseDefaultAttributes() {
        return this.m_formatter.getUseDefaultAttributes();
    }

    public void setIncludeMessageArguments(boolean includeMessageArguments) {
        this.m_formatter.setIncludeMessageArguments(includeMessageArguments);
    }

    public boolean getIncludeMessageArguments() {
        return this.m_formatter.getIncludeMessageArguments();
    }

    public void setLocale(Locale locale) {
        this.m_formatter.setLocale(locale);
    }

    public Locale getLocale() {
        return this.m_formatter.getLocale();
    }

    private void initProperties() {
        String s = this.getProperty(SUPPL_ATTRS_PROP);
        if (s != null) {
            this.setSupplementalAttributes(ODLHandler.parseAttrList(s));
        }
        if ((s = this.getProperty(USE_SRCMET_PROP)) != null) {
            this.setUseSourceClassAndMethod(s.equalsIgnoreCase("true"));
        }
        if ((s = this.getProperty(USE_DEF_ATTRS_PROP)) != null) {
            this.setUseDefaultAttributes(s.equalsIgnoreCase("true"));
        }
        if ((s = this.getProperty(INCLUDE_MSG_ARGS_PROP)) != null) {
            this.setIncludeMessageArguments(s.equalsIgnoreCase("true"));
        }
    }

    private String getProperty(String key) {
        String s = System.getProperty(key);
        if (s == null) {
            s = LogManager.getLogManager().getProperty(key);
        }
        return s;
    }

    static String[] parseAttrList(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

