/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.SimpleFormatter;

public class OutputStreamLogWriter
extends LogWriter {
    private OutputStreamWriter m_out;
    private LogFormatter m_formatter;

    private OutputStreamLogWriter(OutputStreamWriter out) {
        this(new SimpleFormatter(), out);
    }

    private OutputStreamLogWriter(LogFormatter formatter, OutputStreamWriter out) {
        this.m_out = out;
        this.m_formatter = formatter;
        String header = formatter.header();
        if (header != null) {
            this.write(header);
        }
    }

    public static OutputStreamLogWriter create(OutputStream out) {
        return new OutputStreamLogWriter(new OutputStreamWriter(out));
    }

    public static OutputStreamLogWriter create(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return new OutputStreamLogWriter(new OutputStreamWriter(out, encoding));
    }

    public static OutputStreamLogWriter create(LogFormatter formatter, OutputStream out) throws LogWriterException {
        if (formatter == null) {
            throw new LogWriterException("Illegal argument: LogFormatter argument cannot be null");
        }
        return new OutputStreamLogWriter(formatter, new OutputStreamWriter(out));
    }

    public static OutputStreamLogWriter create(LogFormatter formatter, OutputStream out, String encoding) throws LogWriterException, UnsupportedEncodingException {
        if (formatter == null) {
            throw new LogWriterException("Illegal argument: LogFormatter argument cannot be null");
        }
        return new OutputStreamLogWriter(formatter, new OutputStreamWriter(out, encoding));
    }

    public void close() {
        String tail = this.m_formatter.tail();
        if (tail != null) {
            this.write(tail);
        }
        super.close();
        if (this.m_out == null) {
            return;
        }
        try {
            this.m_out.flush();
            this.m_out.close();
        }
        catch (Exception e) {
            this.handleException(new LoggingException(e));
        }
        this.m_out = null;
    }

    public void flush() {
        super.flush();
        if (this.m_out == null) {
            this.handleException(new LoggingException("Attempt to flush a closed Writer"));
            return;
        }
        try {
            this.m_out.flush();
        }
        catch (Exception e) {
            this.handleException(new LoggingException(e));
        }
    }

    public void write(LogMessage msg) {
        this.write(this.m_formatter.format(msg));
    }

    private final void write(String s) {
        try {
            this.m_out.write(s);
        }
        catch (Exception e) {
            this.handleException(new LoggingException(e));
        }
    }

    private void handleException(Exception exn) {
        this.getExceptionHandler().onException(exn);
    }
}

