/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;

public class ODLTextFormatter
implements LogFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private Date m_date = new Date(0L);
    private DateFormat m_dateFmt = new DateFormat();

    public String format(LogMessage msg) {
        int nl;
        Map map;
        StringBuffer buf = new StringBuffer(200);
        buf.append("[");
        this.m_date.setTime(msg.getTimestamp());
        this.m_dateFmt.format(this.m_date, buf);
        buf.append("] ");
        buf.append("[");
        if (msg.getComponentId() != null) {
            buf.append(msg.getComponentId());
        }
        buf.append("] [");
        MessageType msgtype = msg.getMessageType();
        if (msgtype != null) {
            buf.append(msgtype.toString());
            if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
                buf.append(":");
                buf.append(msg.getMessageLevel());
            }
        } else {
            buf.append(MessageType.UNKNOWN.toString());
        }
        buf.append("] [");
        if (msg.getMessageId() != null) {
            buf.append(msg.getMessageId());
        }
        buf.append("] [");
        if (msg.getModuleId() != null) {
            buf.append(msg.getModuleId());
        }
        buf.append("] ");
        if (msg.getOrganizationId() != null) {
            buf.append("[org: ");
            buf.append(msg.getOrganizationId());
            buf.append("] ");
        }
        if (msg.getHostingClientId() != null) {
            buf.append("[hostingClientId: ");
            buf.append(msg.getHostingClientId());
            buf.append("] ");
        }
        if (msg.getMessageGroup() != null) {
            buf.append("[group: ");
            buf.append(msg.getMessageGroup());
            buf.append("] ");
        }
        if (msg.getHostId() != null) {
            buf.append("[host: ");
            buf.append(msg.getHostId());
            buf.append("] ");
        }
        if (msg.getHostNwAddr() != null) {
            buf.append("[nwaddr: ");
            buf.append(msg.getHostNwAddr());
            buf.append("] ");
        }
        if (msg.getProcessId() != null) {
            buf.append("[pid: ");
            buf.append(msg.getProcessId());
            buf.append("] ");
        }
        if (msg.getThreadId() != null) {
            buf.append("[tid: ");
            buf.append(msg.getThreadId());
            buf.append("] ");
        }
        if (msg.getUserId() != null) {
            buf.append("[userId: ");
            buf.append(msg.getUserId());
            buf.append("] ");
        }
        if (msg.getUpstreamCompId() != null) {
            buf.append("[upstreamComp: ");
            buf.append(msg.getUpstreamCompId());
            buf.append("] ");
        }
        if (msg.getDownstreamCompId() != null) {
            buf.append("[downstreamComp: ");
            buf.append(msg.getDownstreamCompId());
            buf.append("] ");
        }
        if (msg.getExecContextId() != null) {
            buf.append("[ecid: ");
            buf.append(msg.getExecContextId().getUniqueId());
            buf.append(",");
            buf.append(msg.getExecContextId().getRID());
            buf.append("] ");
        }
        if (msg.getErrorInstanceId() != null) {
            buf.append("[errid: ");
            buf.append(msg.getErrorInstanceId().getUniqueId());
            String rid = msg.getErrorInstanceId().getRID();
            if (rid != null) {
                buf.append(",");
                buf.append(msg.getErrorInstanceId().getRID());
            }
            buf.append("] ");
        }
        if (msg.getDetailLocation() != null) {
            buf.append("[detailLoc: ");
            buf.append(msg.getDetailLocation());
            buf.append("] ");
        }
        if (msg.getProblemKey() != null) {
            buf.append("[probKey: ");
            buf.append(msg.getProblemKey());
            buf.append("] ");
        }
        if ((map = msg.getSupplAttrs()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                buf.append("[");
                buf.append(entry.getKey());
                buf.append(": ");
                buf.append(entry.getValue());
                buf.append("] ");
            }
        }
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                buf.append("[arg: ");
                if (args[i].getName() != null) {
                    buf.append(args[i].getName());
                    buf.append("=");
                }
                buf.append(args[i].getValue());
                buf.append("] ");
            }
        }
        String txt = msg.getMessageText();
        String spl = msg.getSupplDetail();
        if (txt == null) {
            txt = "";
        }
        if ((nl = txt.indexOf(10)) >= 0) {
            String s = txt.substring(0, nl);
            spl = spl == null ? txt.substring(nl + 1) : txt.substring(nl + 1) + ' ' + spl;
            txt = s;
        }
        if (txt.startsWith("[")) {
            buf.append(" ");
        }
        buf.append(txt);
        if (spl != null) {
            buf.append("[[");
            buf.append(LSEP);
            this.escapeBracket(buf, spl);
            buf.append(LSEP);
            buf.append("]]");
        }
        buf.append(LSEP);
        return buf.toString();
    }

    private void escapeBracket(StringBuffer buf, String s) {
        int indx = s.indexOf("]]\n");
        if (indx < 0) {
            buf.append(s);
            return;
        }
        int start = 0;
        do {
            buf.append(s.substring(start, indx));
            buf.append("]] \n");
        } while ((indx = s.indexOf("]]\n", start = indx + 3)) >= 0);
        buf.append(s.substring(start));
    }

    public String header() {
        return null;
    }

    public String tail() {
        return null;
    }
}

