/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.ArrayList;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsProducer;
import oracle.jms.ThreadProxy;

public class AQjmsCompletionListenerWorker
extends AQjmsObject
implements Runnable {
    AQjmsProducer producer;
    ArrayList<CompletionListenerInfo> listeners;
    volatile boolean needToBeClosed = false;
    Thread completionListenerThread;

    public AQjmsCompletionListenerWorker(AQjmsProducer producer) {
        super("AQjmsCompletionListenerWorker", producer);
        this.producer = producer;
        this.listeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void add(AQjmsProducer producer, CompletionListener completionListener, Message message) throws JMSException {
        ArrayList<CompletionListenerInfo> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(new CompletionListenerInfo(producer, message, completionListener));
        }
        this.notifyCl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ArrayList<CompletionListenerInfo> localListeners = new ArrayList<CompletionListenerInfo>();
            ArrayList<CompletionListenerInfo> arrayList = this.listeners;
            synchronized (arrayList) {
                if (this.listeners.size() == 0) {
                    try {
                        this.listeners.wait();
                    }
                    catch (InterruptedException e) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsCompletionListenerWorker.run", e);
                    }
                }
                localListeners.addAll(this.listeners);
                this.listeners.clear();
            }
            for (CompletionListenerInfo lsnr : localListeners) {
                try {
                    lsnr.completionListener.onCompletion(lsnr.message);
                }
                catch (Exception e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsCompletionListenerWorker.onCompletion", e);
                }
            }
            arrayList = this.listeners;
            synchronized (arrayList) {
                if (this.needToBeClosed && this.listeners.size() == 0) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCl() {
        ArrayList<CompletionListenerInfo> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.notifyAll();
        }
    }

    @Override
    public synchronized void close() {
        this.needToBeClosed = true;
        this.notifyCl();
    }

    void launch() throws JMSException {
        this.launch(null);
    }

    void launch(ThreadProxy proxy) throws JMSException {
        try {
            if (proxy == null) {
                this.completionListenerThread = new Thread(this);
                this.completionListenerThread.setDaemon(true);
                this.completionListenerThread.start();
            } else {
                this.completionListenerThread = proxy.launch(this);
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.launch: error in staring the listening thread", e);
            AQjmsError.throwEx(237, (Throwable)e);
        }
    }

    class CompletionListenerInfo {
        Message message;
        CompletionListener completionListener;
        AQjmsProducer producer;

        public CompletionListenerInfo(AQjmsProducer producer, Message message, CompletionListener completionListener) {
            this.producer = producer;
            this.message = message;
            this.completionListener = completionListener;
        }
    }
}

