/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQUtil;

public class AQOracleQueueTableFactory
implements ObjectFactory {
    private String owner;
    private String qtname;
    AQQueueTableProperty property = null;
    static final String PLTYP_ATTR = "payloadtype";
    static final String MUCSM_ATTR = "multiconsumers";
    static final String MSGRP_ATTR = "messagegrouping";
    static final String COMMT_ATTR = "comment";
    static final String COMPT_ATTR = "compatible";
    static final String PRMIS_ATTR = "primaryinstance";
    static final String SCNIS_ATTR = "secondinstance";
    private String payload_type = null;
    private boolean multi_consumer = false;
    private int mess_grouping = 0;
    private String comment = null;
    private String compatible = null;
    private int primary_inst = 0;
    private int secondary_inst = 0;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws AQException {
        Reference ref = (Reference)obj;
        AQOracleDebug.trace(4, "AQOracleQueueTableFactory.getObjectInstance", "entry");
        if (ref == null) {
            AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!ref.getClassName().equals("oracle.AQ.AQOracleQueueTable")) {
            AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "unable to manufacture object of class: " + ref.getClassName());
            return null;
        }
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(0);
            NamingEnumeration<SearchResult> results = ((DirContext)nameCtx).search(name, "(objectclass=*)", constraints);
            if (results == null) {
                AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "failed to search attributes of queue table" + name.get(0));
                return null;
            }
            SearchResult si = results.next();
            Attributes attrs = si.getAttributes();
            this.owner = (String)attrs.get("orclDBAQObjOwner").get();
            this.qtname = (String)attrs.get("orclDBAQObjName").get();
            Attribute gen_attr = attrs.get("orclDBAQGeneric");
            for (int i = 0; i < gen_attr.size(); ++i) {
                String strval;
                String val = (String)gen_attr.get(i);
                if (val.toLowerCase().startsWith(PLTYP_ATTR)) {
                    this.payload_type = val.substring(PLTYP_ATTR.length() + 1);
                    continue;
                }
                if (val.toLowerCase().startsWith(MUCSM_ATTR)) {
                    strval = val.substring(MUCSM_ATTR.length() + 1);
                    if (!strval.toLowerCase().equals("true")) continue;
                    this.multi_consumer = true;
                    continue;
                }
                if (val.toLowerCase().startsWith(MSGRP_ATTR)) {
                    strval = val.substring(MSGRP_ATTR.length() + 1);
                    if (!strval.toLowerCase().equals("transactional")) continue;
                    this.mess_grouping = 1;
                    continue;
                }
                if (val.toLowerCase().startsWith(COMMT_ATTR)) {
                    this.comment = val.substring(COMMT_ATTR.length() + 1);
                    continue;
                }
                if (val.toLowerCase().startsWith(COMPT_ATTR)) {
                    this.compatible = val.substring(COMPT_ATTR.length() + 1);
                    continue;
                }
                if (val.toLowerCase().startsWith(PRMIS_ATTR)) {
                    this.primary_inst = Integer.valueOf(val.substring(PRMIS_ATTR.length() + 1));
                    continue;
                }
                if (!val.toLowerCase().startsWith(SCNIS_ATTR)) continue;
                this.secondary_inst = Integer.valueOf(val.substring(SCNIS_ATTR.length() + 1));
            }
            this.property = new AQQueueTableProperty(this.payload_type);
            this.property.setMultiConsumer(this.multi_consumer);
            this.property.setMessageGrouping(this.mess_grouping);
            this.property.setComment(this.comment);
            this.property.setCompatible(this.compatible);
            this.property.setPrimaryInstance(this.primary_inst);
            this.property.setSecondaryInstance(this.secondary_inst);
            AQOracleQueueTable qt = new AQOracleQueueTable(null, this.owner, this.qtname, this.property);
            AQOracleDebug.trace(4, "AQOracleQueueTableFactory.getObjectInstance", "exit");
            return qt;
        }
        catch (NamingException e) {
            AQOracleDebug.traceEx(3, "AQOracleQueueTableFactory.getObjectInstance", e);
            AQUtil.throwAQEx(205, e);
            return null;
        }
    }
}

