/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;

public class AQjmsObject {
    private final Object m_sync = new Object();
    private final List m_children = new ArrayList();
    private String m_id;
    private AQjmsObject m_parent;
    private String m_dmsName;
    private volatile int m_state = 1;
    private volatile boolean m_isStarted = false;
    private volatile Thread m_useThread = null;
    private volatile int m_useCount = 0;
    private volatile boolean m_lockedByRecv = false;
    private static final int OPEN = 1;
    private static final int MARK_CLOSE = 2;
    private static final int CLOSING = 3;
    private static final int CLOSED = 4;
    private static final int CLOSEWAITTIME = 1000;

    public AQjmsObject(String string, AQjmsObject aQjmsObject) {
        this.m_id = AQjmsUtil.newID(string);
        this.m_parent = aQjmsObject;
        if (this.m_parent != null) {
            this.m_isStarted = this.m_parent.isStarted();
            this.m_dmsName = this.m_parent.m_dmsName + "/" + this.m_id;
        } else {
            this.m_dmsName = "/JMS/" + this.m_id;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public final String getID() {
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attach(AQjmsObject aQjmsObject) throws JMSException {
        Object object = this.m_sync;
        synchronized (object) {
            this.checkClosed("attach");
            List list = this.m_children;
            synchronized (list) {
                AQjmsUtil.sync(this.m_children);
                this.m_children.add(new WeakReference<AQjmsObject>(aQjmsObject));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detach(AQjmsObject aQjmsObject) throws JMSException {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_state != 1) {
                return;
            }
            List list = this.m_children;
            synchronized (list) {
                this.m_children.remove(aQjmsObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int children() throws JMSException {
        int n = 0;
        Object object = this.m_sync;
        synchronized (object) {
            this.checkClosed("children");
            List list = this.m_children;
            synchronized (list) {
                AQjmsUtil.sync(this.m_children);
                n = this.m_children.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AQjmsObject anyChild() {
        AQjmsObject aQjmsObject = null;
        List list = this.m_children;
        synchronized (list) {
            AQjmsUtil.sync(this.m_children);
            if (this.m_children.size() > 0) {
                aQjmsObject = AQjmsUtil.get(this.m_children.iterator());
            }
        }
        return aQjmsObject;
    }

    public final boolean isOpen() {
        return this.m_state == 1;
    }

    final boolean isConnOpen() {
        if (this.m_parent != null) {
            return this.m_parent.isConnOpen() && this.m_state == 1;
        }
        return this.m_state == 1;
    }

    final void CheckConnClosed(String string) throws JMSException {
        if (!this.isConnOpen()) {
            AQjmsUtil.throwClosed(this, string + "():");
        }
    }

    final boolean isClosed() {
        return !this.isOpen();
    }

    final boolean isClosing() {
        return this.m_state == 3;
    }

    final boolean isStarted() {
        if (!(this instanceof Session)) {
            return this.m_parent == null ? this.m_isStarted : this.m_parent.isStarted();
        }
        return this.m_isStarted;
    }

    public final void checkClosed(String string) throws JMSException {
        if (!this.isOpen()) {
            AQjmsUtil.throwClosed(this, string + "():");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markClosed() {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_state == 1) {
                this.m_state = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeWait() throws JMSException {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        List list = this.m_children;
        synchronized (list) {
            Iterator iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                if (aQjmsObject == null) continue;
                try {
                    this.SYNCDBG("closeWait", "b4 close of " + aQjmsObject.getID());
                    aQjmsObject.close();
                    this.SYNCDBG("closeWait", "after close of " + aQjmsObject.getID());
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(2, "close of " + aQjmsObject.getID(), exception);
                    arrayList.add(exception);
                }
            }
            this.m_children.clear();
        }
        if (arrayList.size() > 0) {
            AQjmsError.throwEx("close of some children failed", (Throwable)((Exception)arrayList.get(0)));
        }
    }

    protected void localClose() throws JMSException {
    }

    protected AQjmsObject getParent() {
        return this.m_parent;
    }

    protected void preClose() throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Object object;
        Object object2;
        block21: {
            block20: {
                this.SYNCDBG("close", "ENTRY:waiting for sync");
                object2 = this.m_sync;
                synchronized (object2) {
                    this.markClosed();
                    while (this.m_state == 3) {
                        this.SYNCDBG("close", "state CLOSING, wait");
                        AQjmsUtil.wait(this.m_sync, 1000L);
                        this.SYNCDBG("close", "state CLOSING, finished wait");
                    }
                    if (this.m_state == 4) {
                        this.SYNCDBG("close", "ALREADY CLOSED");
                        return;
                    }
                    this.m_state = 3;
                    this.m_sync.notifyAll();
                    object = this.m_children;
                    synchronized (object) {
                        Iterator iterator = this.m_children.iterator();
                        while (iterator.hasNext()) {
                            AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                            if (aQjmsObject == null) continue;
                            this.SYNCDBG("close", "b4 markClosed of " + aQjmsObject.getID());
                            aQjmsObject.markClosed();
                            this.SYNCDBG("close", "after markClosed of " + aQjmsObject.getID());
                        }
                    }
                    while (this.m_useCount > 0) {
                        this.SYNCDBG("close", "usecount is " + this.m_useCount + " WAIT");
                        AQjmsUtil.wait(this.m_sync, 1000L);
                        this.SYNCDBG("close", "Finished WAIT: usecount is " + this.m_useCount);
                    }
                }
                object2 = null;
                try {
                    this.preClose();
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                }
                this.SYNCDBG("close", "b4 closeWait");
                try {
                    this.closeWait();
                }
                catch (Throwable throwable) {
                    if (object2 != null) break block20;
                    object2 = throwable;
                }
            }
            this.SYNCDBG("close", "after closeWait");
            try {
                this.localClose();
            }
            catch (Throwable throwable) {
                if (object2 != null) break block21;
                object2 = throwable;
            }
        }
        object = this.m_sync;
        synchronized (object) {
            this.m_state = 4;
            this.m_sync.notifyAll();
        }
        this.SYNCDBG("close", "EXIT");
        if (object2 != null) {
            AQjmsError.throwEx("Error in close", (Throwable)object2);
        }
    }

    boolean isInUse() {
        return this.m_useCount > 0;
    }

    boolean lockedByReceive() {
        return this.m_lockedByRecv;
    }

    final boolean lockReceive(String string, long l) throws JMSException {
        return this.getLock(string, l, true);
    }

    final boolean lock(String string, long l) throws JMSException {
        return this.getLock(string, l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean getLock(String string, long l, boolean bl) throws JMSException {
        long l2 = AQjmsUtil.javaTimeout(l);
        long l3 = System.currentTimeMillis() + l2;
        this.SYNCDBG("getLock", "after sync, timeout=" + l2);
        this.checkClosed(string);
        if (!(this instanceof Session)) {
            boolean bl2;
            boolean bl3 = bl2 = this.m_parent == null ? true : this.m_parent.getLock(string, l, bl);
            if (this instanceof MessageConsumer && bl2) {
                Object object = this.m_sync;
                synchronized (object) {
                    ++this.m_useCount;
                }
                this.SYNCDBG("getLock", "acquired consumer lock, usecount=" + this.m_useCount);
            }
            return bl2;
        }
        boolean bl4 = false;
        Object object = this.m_sync;
        synchronized (object) {
            while (this.m_useCount > 0 || bl && !this.isStarted()) {
                if (this.m_useThread == Thread.currentThread() && (!bl || this.isStarted())) {
                    this.SYNCDBG("getLock", "Thread " + this.m_useThread.getName() + " try to require lock mulitple times, grant it again.");
                    break;
                }
                this.SYNCDBG("getLock", (String)(this.m_useThread != null ? "Waiting for thread " + this.m_useThread.getName() : "Waiting for start") + ", timeout=" + l2);
                AQjmsUtil.wait(this.m_sync, l2);
                bl4 = true;
                this.checkClosed(string);
                if (l == -1L || System.currentTimeMillis() <= l3) continue;
                this.SYNCDBG("getLock", "TIMEDOUT");
                return false;
            }
            if (bl4) {
                this.SYNCDBG("getLock", "Successful wakeup from wait");
            }
            this.m_useThread = Thread.currentThread();
            this.m_lockedByRecv = bl;
            ++this.m_useCount;
            this.SYNCDBG("getLock", "acquired session lock, usecount=" + this.m_useCount);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlock(String string) {
        if (!(this instanceof Session)) {
            if (this.m_parent != null) {
                if (this instanceof MessageConsumer) {
                    Object object = this.m_sync;
                    synchronized (object) {
                        --this.m_useCount;
                    }
                    this.SYNCDBG("unLock", "released consumer lock, usecount=" + this.m_useCount);
                }
                this.m_parent.unlock(string);
            }
            return;
        }
        Object object = this.m_sync;
        synchronized (object) {
            this.SYNCDBG("releaseLock", "after sync");
            if (Thread.currentThread() != this.m_useThread) {
                this.SYNCDBG("releaseLock", "Thread " + (this.m_useThread != null ? this.m_useThread.getName() : "NULL") + " receiving, but Thread " + Thread.currentThread().getName() + " trying to unlock");
                return;
            }
            --this.m_useCount;
            this.m_lockedByRecv = false;
            if (this.m_useCount == 0) {
                this.m_useThread = null;
            }
            this.m_sync.notifyAll();
            this.SYNCDBG("unLock", "released session lock, EXIT, usecount=" + this.m_useCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void startAll(String string) throws JMSException {
        this.SYNCDBG("startAll", "ENTRY");
        if (this.m_parent == null) {
            Object object = this.m_sync;
            synchronized (object) {
                this.checkClosed(string);
                if (this.m_isStarted) {
                    this.SYNCDBG("startAll", "startAll is ignored if the object is already started");
                    return;
                }
                this.m_isStarted = true;
                List list = this.m_children;
                synchronized (list) {
                    Iterator iterator = this.m_children.iterator();
                    while (iterator.hasNext()) {
                        AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                        if (aQjmsObject == null) continue;
                        this.SYNCDBG("startAll", "Calling start for: " + aQjmsObject.getID());
                        if (aQjmsObject instanceof Session) {
                            aQjmsObject.startJMSNotification();
                        }
                        aQjmsObject.startAll(string);
                    }
                }
            }
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (!this.m_isStarted) {
                this.m_isStarted = true;
                this.m_sync.notifyAll();
                this.SYNCDBG("startAll", "Session: Woke up receivers");
            }
        }
        this.SYNCDBG("startAll", "EXIT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void stopAll(String string) throws JMSException {
        this.SYNCDBG("stopAll", "ENTRY");
        if (this.m_parent == null) {
            Object object = this.m_sync;
            synchronized (object) {
                this.checkClosed(string);
                if (!this.m_isStarted) {
                    this.SYNCDBG("stopAll", "stopAll is ignored if the object is already stopped");
                    return;
                }
                this.m_isStarted = false;
                List list = this.m_children;
                synchronized (list) {
                    Iterator iterator = this.m_children.iterator();
                    while (iterator.hasNext()) {
                        AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                        if (aQjmsObject == null) continue;
                        this.SYNCDBG("stopAll", "Calling stop for: " + aQjmsObject.getID());
                        if (aQjmsObject instanceof Session) {
                            aQjmsObject.stopJMSNotification();
                        }
                        aQjmsObject.stopAll(string);
                    }
                }
            }
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_isStarted) {
                this.m_isStarted = false;
                this.SYNCDBG("stopAll", "Session: Woke up receivers");
            }
        }
        this.SYNCDBG("stopAll", "EXIT");
    }

    void handleJMSNotification() throws JMSException, TimeoutException {
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
            if (aQjmsObject == null || !(aQjmsObject instanceof Session)) continue;
            aQjmsObject.handleJMSNotification();
        }
    }

    void startJMSNotification() throws JMSException {
    }

    void stopJMSNotification() throws JMSException {
    }

    private void SYNCDBG(String string, String string2) {
        AQjmsOracleDebug.trace(6, "[" + Thread.currentThread().getName() + "] " + string + " (" + this.getID() + ") ", string2);
    }
}

